/*
 * Decompiled with CFR 0.152.
 */
package io.github.yedaxia.apidocs.codegenerator;

import io.github.yedaxia.apidocs.DocContext;
import io.github.yedaxia.apidocs.Utils;
import io.github.yedaxia.apidocs.codegenerator.CodeFileBuilder;
import io.github.yedaxia.apidocs.parser.ClassNode;
import io.github.yedaxia.apidocs.parser.FieldNode;
import io.github.yedaxia.apidocs.parser.ResponseNode;
import java.io.File;
import java.io.IOException;

public abstract class CodeGenerator {
    private ResponseNode responseNode;
    private File codePath;
    private String codeRelativePath;

    public CodeGenerator(ResponseNode responseNode) {
        this.responseNode = responseNode;
        this.codeRelativePath = this.getRelativeCodeDir();
        this.codePath = new File(DocContext.getDocPath(), this.codeRelativePath);
        if (!this.codePath.exists()) {
            this.codePath.mkdirs();
        }
    }

    public String generateCode() throws IOException {
        if (this.responseNode.getChildNodes() == null || this.responseNode.getChildNodes().isEmpty()) {
            return "";
        }
        StringBuilder codeBodyBuilder = new StringBuilder();
        this.generateCodeForBuilder(this.responseNode, codeBodyBuilder);
        String sCodeTemplate = this.getCodeTemplate();
        CodeFileBuilder codeBuilder = new CodeFileBuilder(this.responseNode.getClassName(), codeBodyBuilder.toString(), sCodeTemplate);
        String javaFileName = String.format("%s_%s_%s_%s.html", this.responseNode.getRequestNode().getControllerNode().getPackageName().replace(".", "_"), this.responseNode.getRequestNode().getControllerNode().getClassName(), this.responseNode.getRequestNode().getMethodName(), this.responseNode.getClassName());
        Utils.writeToDisk(new File(this.codePath, javaFileName), codeBuilder.build());
        return String.format("%s/%s", this.codeRelativePath, javaFileName);
    }

    private void generateCodeForBuilder(ClassNode rootNode, StringBuilder codeBodyBuilder) throws IOException {
        codeBodyBuilder.append(this.generateNodeCode(rootNode));
        codeBodyBuilder.append('\n');
        for (FieldNode recordNode : rootNode.getChildNodes()) {
            if (recordNode.getChildNode() == null) continue;
            this.generateCodeForBuilder(recordNode.getChildNode(), codeBodyBuilder);
        }
    }

    public abstract String generateNodeCode(ClassNode var1) throws IOException;

    public abstract String getRelativeCodeDir();

    public abstract String getCodeTemplate();
}

