/*
 * Decompiled with CFR 0.152.
 */
package io.github.yedaxia.apidocs.doc;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.github.yedaxia.apidocs.DocContext;
import io.github.yedaxia.apidocs.LogUtils;
import io.github.yedaxia.apidocs.Resources;
import io.github.yedaxia.apidocs.Utils;
import io.github.yedaxia.apidocs.doc.AbsDocGenerator;
import io.github.yedaxia.apidocs.doc.HtmlControllerDocBuilder;
import io.github.yedaxia.apidocs.parser.ControllerNode;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;

public class HtmlDocGenerator
extends AbsDocGenerator {
    public HtmlDocGenerator() {
        super(DocContext.controllerParser(), new HtmlControllerDocBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void generateIndex(List<ControllerNode> controllerNodeList) {
        FileWriter docFileWriter = null;
        try {
            LogUtils.info("generate index start !!!", new Object[0]);
            Template ctrlTemplate = this.getIndexTpl();
            File docFile = new File(DocContext.getDocPath(), "index.html");
            docFileWriter = new FileWriter(docFile);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("controllerNodeList", controllerNodeList);
            data.put("currentApiVersion", DocContext.getCurrentApiVersion());
            data.put("apiVersionList", DocContext.getApiVersionList());
            data.put("projectName", DocContext.getDocsConfig().getProjectName());
            data.put("i18n", DocContext.getI18n());
            ctrlTemplate.process(data, (Writer)docFileWriter);
            LogUtils.info("generate index done !!!", new Object[0]);
            Utils.closeSilently(docFileWriter);
        }
        catch (TemplateException | IOException ex) {
            LogUtils.error("generate index fail !!!", ex);
        }
        finally {
            Utils.closeSilently(docFileWriter);
        }
        this.copyCssStyle();
    }

    private void copyCssStyle() {
        try {
            String cssFileName = "style.css";
            File cssFile = new File(DocContext.getDocPath(), cssFileName);
            Utils.writeToDisk(cssFile, Utils.streamToString(Resources.getTemplateFile(cssFileName)));
        }
        catch (IOException e) {
            LogUtils.error("copyCssStyle fail", e);
        }
    }

    private Template getIndexTpl() throws IOException {
        return Resources.getFreemarkerTemplate("api-index.html.ftl");
    }
}

