/*
 * Decompiled with CFR 0.152.
 */
package io.github.yedaxia.apidocs.plugin.rap;

import io.github.yedaxia.apidocs.DocContext;
import io.github.yedaxia.apidocs.DocsConfig;
import io.github.yedaxia.apidocs.IPluginSupport;
import io.github.yedaxia.apidocs.LogUtils;
import io.github.yedaxia.apidocs.Utils;
import io.github.yedaxia.apidocs.http.DHttpRequest;
import io.github.yedaxia.apidocs.http.DHttpResponse;
import io.github.yedaxia.apidocs.http.DHttpUtils;
import io.github.yedaxia.apidocs.parser.ControllerNode;
import io.github.yedaxia.apidocs.plugin.rap.DeleteActionFrom;
import io.github.yedaxia.apidocs.plugin.rap.ModelResponse;
import io.github.yedaxia.apidocs.plugin.rap.Module;
import io.github.yedaxia.apidocs.plugin.rap.Project;
import io.github.yedaxia.apidocs.plugin.rap.ProjectForm;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RapSupportPlugin
implements IPluginSupport {
    private String rapHost;
    private Integer projectId;
    private String cookie;
    private List<ControllerNode> controllerNodeList;

    @Override
    public void execute(List<ControllerNode> controllerNodeList) {
        this.controllerNodeList = controllerNodeList;
        this.postToRap();
    }

    private void postToRap() {
        DocsConfig docsConfig = DocContext.getDocsConfig();
        if (this.controllerNodeList == null || this.controllerNodeList.isEmpty() || docsConfig == null || docsConfig.getRapHost() == null || docsConfig.getRapProjectId() == null) {
            LogUtils.warn("docs config properties miss, we don't think you want to post to rap!", new Object[0]);
            return;
        }
        this.rapHost = docsConfig.getRapHost();
        this.projectId = Integer.valueOf(docsConfig.getRapProjectId());
        this.cookie = docsConfig.getRapLoginCookie();
        if (!Utils.isNotEmpty(this.cookie)) {
            String account = docsConfig.getRapAccount();
            String password = docsConfig.getRapPassword();
            DHttpResponse response = this.doLogin(this.loginUrl(this.rapHost), account, password);
            this.cookie = response.getHeader("Set-Cookie");
        }
        Set<Module> moduleSet = this.getModuleList();
        ProjectForm projectForm = new ProjectForm();
        projectForm.setId(this.projectId);
        HashSet<DeleteActionFrom> deleteModuleForms = new HashSet<DeleteActionFrom>(moduleSet.size());
        if (moduleSet != null && !moduleSet.isEmpty()) {
            for (Module module : moduleSet) {
                if (!"API List".equalsIgnoreCase(module.getName())) continue;
                DeleteActionFrom delForm = new DeleteActionFrom();
                delForm.setClassName("Module");
                delForm.setId(module.getId());
                deleteModuleForms.add(delForm);
            }
        }
        projectForm.setDeletedObjectListData(Utils.toJson(deleteModuleForms));
        Project project = Project.valueOf(this.projectId, this.controllerNodeList);
        projectForm.setProjectData(Utils.toJson(project));
        this.postProject(projectForm);
    }

    public DHttpResponse doLogin(String loginUrl, String userName, String password) {
        DHttpRequest request = new DHttpRequest();
        request.setAutoRedirect(false);
        request.setUrl(loginUrl);
        request.addParam("account", userName);
        request.addParam("password", password);
        try {
            return DHttpUtils.httpPost(request);
        }
        catch (IOException ex) {
            LogUtils.error("login rap fail , userName : %s, pass : %s", userName, password);
            throw new RuntimeException(ex);
        }
    }

    private Set<Module> getModuleList() {
        try {
            DHttpResponse modelResp = DHttpUtils.httpGet(this.queryModelUrl(this.rapHost, this.projectId));
            if (modelResp.getCode() == 200) {
                ModelResponse model = Utils.jsonToObject(modelResp.streamAsString(), ModelResponse.class);
                return model.getModel().getModuleList();
            }
            LogUtils.error("request module data fail, rapHost : %s, projectId : %s", this.rapHost, this.projectId);
            throw new RuntimeException("request module data fail , code : " + modelResp.getCode());
        }
        catch (IOException e) {
            LogUtils.error("get rap models fail", e);
            throw new RuntimeException(e);
        }
    }

    private void postProject(ProjectForm projectForm) {
        DHttpRequest request = new DHttpRequest();
        request.setUrl(this.checkInUrl(this.rapHost));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(projectForm.getId()));
        params.put("projectData", projectForm.getProjectData());
        if (projectForm.getDeletedObjectListData() != null) {
            params.put("deletedObjectListData", projectForm.getDeletedObjectListData());
        }
        if (projectForm.getDescription() != null) {
            params.put("description", projectForm.getDescription());
        }
        if (projectForm.getVersionPosition() != null) {
            params.put("versionPosition", projectForm.getVersionPosition());
        }
        request.setParams(params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        headers.put("Cookie", this.cookie);
        request.setHeaders(headers);
        try {
            DHttpResponse response = DHttpUtils.httpPost(request);
            if (response.getCode() == 200) {
                LogUtils.info("post project to rap success, response : %s ", response.streamAsString());
            } else {
                LogUtils.error("post project to rap fail !!! code : %s", response.streamAsString());
            }
        }
        catch (IOException e) {
            LogUtils.error("post project to rap fail", e);
            throw new RuntimeException(e);
        }
    }

    private String queryModelUrl(String host, Integer projectId) {
        return String.format("%s/api/queryModel.do?projectId=%s", host, projectId);
    }

    private String checkInUrl(String host) {
        return String.format("%s/workspace/checkIn.do", host);
    }

    private String loginUrl(String host) {
        return String.format("%s/account/doLogin.do", host);
    }
}

