/*
 * Decompiled with CFR 0.152.
 */
package hasher;

import java.security.SecureRandom;

final class GenerateSalt {
    private static final String SALT_RANDOM_ALGORITHM = "SHA1PRNG";
    private final SecureRandom random = GenerateSalt.getSecureRandom();
    private final int keyLength;

    GenerateSalt(int keyLength) {
        this.keyLength = keyLength;
    }

    public byte[] generateKey() {
        byte[] bytes = new byte[this.keyLength];
        this.random.nextBytes(bytes);
        return bytes;
    }

    private static SecureRandom getSecureRandom() {
        try {
            return SecureRandom.getInstance(SALT_RANDOM_ALGORITHM);
        }
        catch (Exception e) {
            return new SecureRandom();
        }
    }
}

