/*
 * Decompiled with CFR 0.152.
 */
package helper;

import helper.ConstantUtil;
import helper.ValidationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CommonUtil.class);

    private CommonUtil() {
    }

    public static int getNumberLength(int x) {
        if (!ValidationUtil.isPositiveNumber(x)) {
            CommonUtil.printWarn("Input integer is not positive.");
            return 0;
        }
        int i = 0;
        while (x > ConstantUtil.INT_SIZE_TABLE[i]) {
            ++i;
        }
        return i + 1;
    }

    public static long getNumberLength(long x) {
        if (!ValidationUtil.isPositiveNumber(x)) {
            CommonUtil.printWarn("Input integer is not positive.");
            return 0L;
        }
        int i = 0;
        while (x > ConstantUtil.LONG_SIZE_TABLE[i]) {
            ++i;
        }
        return i + 1;
    }

    public static void printInfo(String message) {
        LOG.info(message);
    }

    public static void printInfo(String message, String param) {
        LOG.info(message, (Object)param);
    }

    public static void printInfo(String message, Logger logger) {
        logger.info(message);
    }

    public static void printInfo(String message, String param, Logger logger) {
        logger.info(message, (Object)param);
    }

    public static void printWarn(String message) {
        LOG.warn(message);
    }

    public static void printWarn(String message, String param) {
        LOG.warn(message, (Object)param);
    }

    public static void printWarn(String message, Logger logger) {
        logger.warn(message);
    }

    public static void printWarn(String message, String param, Logger logger) {
        logger.warn(message, (Object)param);
    }

    public static void printDebug(String message) {
        LOG.debug(message);
    }

    public static void printDebug(String message, String param) {
        LOG.debug(message, (Object)param);
    }

    public static void printDebug(String message, Logger logger) {
        logger.debug(message);
    }

    public static void printDebug(String message, String param, Logger logger) {
        logger.debug(message, (Object)param);
    }

    public static void printError(String message) {
        LOG.error(message);
    }

    public static void printError(String message, String param) {
        LOG.error(message, (Object)param);
    }

    public static void printError(String message, Logger logger) {
        logger.error(message);
    }

    public static void printError(String message, String param, Logger logger) {
        logger.error(message, (Object)param);
    }
}

