/*
 * Decompiled with CFR 0.152.
 */
package helper;

import helper.ValidationUtil;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DateTimeUtil.class);

    private DateTimeUtil() {
    }

    public static String getDateTime(Instant instant, String zoneId, String pattern) {
        try {
            if (ValidationUtil.isEmptyString(zoneId)) {
                LOG.warn("ZoneId is null or empty");
                return null;
            }
            if (ValidationUtil.isEmptyString(pattern)) {
                LOG.warn("ZoneId is null or empty");
                return null;
            }
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneId.of(zoneId));
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
            return zonedDateTime.format(formatter);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage());
            return null;
        }
    }

    public static String getCurrentDateTime(String zoneId) {
        return DateTimeUtil.getDateTime(Instant.now(), zoneId, "yyyy-MM-dd HH:mm:ss.SSS");
    }

    public static String getCurrentDateTime(String zoneId, String pattern) {
        return DateTimeUtil.getDateTime(Instant.now(), zoneId, pattern);
    }

    public static String getCurrentUTCDateTime() {
        return DateTimeUtil.getDateTime(Instant.now(), "UTC", "yyyy-MM-dd HH:mm:ss.SSS");
    }

    public static String getCurrentUTCDateTime(String pattern) {
        return DateTimeUtil.getDateTime(Instant.now(), "UTC", pattern);
    }

    public static String getUTCDateTime(Instant instant, String pattern) {
        return DateTimeUtil.getDateTime(instant, "UTC", pattern);
    }

    public static String getCurrentMMDateTime() {
        return DateTimeUtil.getDateTime(Instant.now(), "Asia/Yangon", "yyyy-MM-dd HH:mm:ss.SSS");
    }

    public static String getCurrentMMDateTime(String pattern) {
        return DateTimeUtil.getDateTime(Instant.now(), "Asia/Yangon", pattern);
    }

    public static String getMMDateTime(Instant instant, String pattern) {
        return DateTimeUtil.getDateTime(instant, "Asia/Yangon", pattern);
    }

    public static LocalDateTime getCurrentLocalDateTime() {
        return LocalDateTime.now();
    }

    public static LocalTime getCurrentLocalTime() {
        LocalDateTime dateTime = LocalDateTime.now();
        return dateTime.toLocalTime();
    }

    public static long differenceDateByMilliSeconds(LocalDateTime before, LocalDateTime after) {
        return ChronoUnit.MILLIS.between(before, after);
    }

    public static long differenceDateBySeconds(LocalDateTime before, LocalDateTime after) {
        return ChronoUnit.SECONDS.between(before, after);
    }

    public static long differenceDateByMinutes(LocalDateTime before, LocalDateTime after) {
        return ChronoUnit.MINUTES.between(before, after);
    }

    public static long differenceDateByHours(LocalDateTime before, LocalDateTime after) {
        return ChronoUnit.HOURS.between(before, after);
    }

    public static long differenceDateByDays(LocalDateTime before, LocalDateTime after) {
        return ChronoUnit.DAYS.between(before, after);
    }

    public static long differenceDateByMonths(LocalDateTime before, LocalDateTime after) {
        return ChronoUnit.MONTHS.between(before, after);
    }

    public static long differenceDateByYears(LocalDateTime before, LocalDateTime after) {
        return ChronoUnit.YEARS.between(before, after);
    }
}

