/*
 * Decompiled with CFR 0.152.
 */
package helper;

import hasher.Argon2IDHasher;
import helper.ValidationUtil;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordUtil.class);

    private PasswordUtil() {
    }

    public static String encode(String rawPassword) {
        try {
            if (ValidationUtil.isEmptyString(rawPassword)) {
                LOG.warn("Raw Password is null or empty.");
                return null;
            }
            Argon2IDHasher argon2IDHasher = new Argon2IDHasher();
            return argon2IDHasher.encode(rawPassword);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("Cannot Encode Password.");
            return null;
        }
    }

    public static boolean checkPassword(String rawPassword, String encodedPassword) {
        try {
            if (ValidationUtil.isEmptyString(rawPassword)) {
                LOG.warn("Raw Password is null or empty.");
                return false;
            }
            if (ValidationUtil.isEmptyString(encodedPassword)) {
                LOG.warn("Encoded Password is null or empty.");
                return false;
            }
            Argon2IDHasher argon2IDHasher = new Argon2IDHasher();
            Argon2IDHasher.Argon2Hash decodedHash = argon2IDHasher.decode(encodedPassword);
            byte[] hashBytes = new byte[decodedHash.getHash().length];
            Argon2BytesGenerator generator = new Argon2BytesGenerator();
            generator.init(decodedHash.getParameters());
            generator.generateBytes(rawPassword.toCharArray(), hashBytes);
            return PasswordUtil.constantTimeArrayEquals(decodedHash.getHash(), hashBytes);
        }
        catch (IllegalArgumentException var6) {
            LOG.warn("Malformed Password Hash", (Throwable)var6);
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("Cannot Check Password.");
            return false;
        }
    }

    private static boolean constantTimeArrayEquals(byte[] expected, byte[] actual) {
        if (expected.length != actual.length) {
            return false;
        }
        int result = 0;
        for (int i = 0; i < expected.length; ++i) {
            result |= expected[i] ^ actual[i];
        }
        return result == 0;
    }
}

