/*
 * Decompiled with CFR 0.152.
 */
package helper;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ValidationUtil.class);

    private ValidationUtil() {
    }

    public static boolean isEmptyString(String input) {
        return input == null || input.trim().equals("");
    }

    public static boolean isEmptyString(String input, String message) {
        if (!ValidationUtil.isEmptyString(input)) {
            return false;
        }
        return ValidationUtil.printEmpty(input, message, true);
    }

    public static boolean isEmptyCollection(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmptyCollection(Collection<?> collection, String message) {
        return (collection == null || collection.isEmpty()) && ValidationUtil.printEmpty(collection, message);
    }

    public static boolean isValidEmail(String email) {
        if (ValidationUtil.isEmptyString(email)) {
            return ValidationUtil.printEmpty(email, "Input email address", false);
        }
        Pattern pattern = Pattern.compile("^[\\w!#$%&amp;'*+/=?`{|}~^-]+(?:\\.[\\w!#$%&amp;'*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$");
        Matcher matcher = pattern.matcher(email);
        return matcher.matches();
    }

    public static boolean isValidEmail(String email, String message) {
        if (ValidationUtil.isValidEmail(email)) {
            return true;
        }
        return ValidationUtil.printInvalidFormat(email, message);
    }

    public static boolean isPositiveNumber(Integer input) {
        return input != null && input > 0;
    }

    public static boolean isPositiveNumber(Integer input, String message) {
        return input != null && input > 0 || ValidationUtil.printNegative(input, message);
    }

    public static boolean isPositiveNumber(Long input) {
        return input != null && input > 0L;
    }

    public static boolean isPositiveNumber(Long input, String message) {
        return input != null && input > 0L || ValidationUtil.printNegative(input, message);
    }

    public static boolean isIntegerNumber(String input) {
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isIntegerNumber(String input, String message) {
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (NumberFormatException e) {
            return ValidationUtil.printNotNumber(input, message);
        }
    }

    public static boolean isLongNumber(String input) {
        try {
            Long.parseLong(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isLongNumber(String input, String message) {
        try {
            Long.parseLong(input);
            return true;
        }
        catch (NumberFormatException e) {
            return ValidationUtil.printNotNumber(input, message);
        }
    }

    private static boolean printEmpty(String input, String message, boolean action) {
        LOG.warn("{} is null or empty, input: {}", (Object)message, (Object)input);
        return action;
    }

    private static boolean printEmpty(Collection<?> collection, String message) {
        LOG.warn("{} is null or empty, input: {}", (Object)message, collection);
        return true;
    }

    private static boolean printInvalidFormat(String input, String message) {
        LOG.warn("{} is invalid format, input: {}", (Object)message, (Object)input);
        return false;
    }

    private static boolean printNegative(Integer input, String message) {
        LOG.warn("{} is null or not positive number, input: {}", (Object)message, (Object)input);
        return false;
    }

    private static boolean printNegative(Long input, String message) {
        LOG.warn("{} is null or not positive number, input: {}", (Object)message, (Object)input);
        return false;
    }

    private static boolean printNotNumber(String input, String message) {
        LOG.warn("{} is not a number, input: {}", (Object)message, (Object)input);
        return false;
    }
}

