/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.base.framework.utils.app;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.Keep;
import com.sdk.f.c;
import com.sdk.n.b;
import com.sdk.u.a;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Stack;

@Keep
public class AppUtils
extends com.sdk.i.a {
    private static final String TAG = "com.sdk.base.framework.utils.app.AppUtils";
    private static boolean isDebug = c.b;
    private static Stack<Activity> activityStack = new Stack();
    private static int targetSdkVersion = -1;

    public static String getLocalIPAddress() {
        block11: {
            InetAddress inetAddress;
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            block9: while (true) {
                if (!enumeration.hasMoreElements()) break block11;
                Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
                while (true) {
                    if (!enumeration2.hasMoreElements()) continue block9;
                    inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    if (inetAddress instanceof Inet4Address) break block9;
                    continue;
                    break;
                }
                break;
            }
            try {
                return inetAddress.getHostAddress().toString();
            }
            catch (SocketException socketException) {}
        }
        return "null";
    }

    public static String getVersionName(Context context) {
        String string2;
        block4: {
            string2 = null;
            if (context == null) {
                return string2;
            }
            context = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            if (context == null) break block4;
            try {
                string2 = context.versionName;
            }
            catch (Exception exception) {
                b.a(TAG, exception.getMessage(), isDebug);
            }
        }
        return string2;
    }

    public static <T> T getMetaData(Context context, String string2) {
        Object object = null;
        if (context != null && !b.a(string2).booleanValue()) {
            block5: {
                context = context.getPackageManager().getApplicationInfo(AppUtils.getPackageName(context), 128);
                if (context == null) break block5;
                context = context.metaData;
                if (context == null) break block5;
                try {
                    object = context.get(string2);
                }
                catch (Exception exception) {
                    b.b(TAG, exception.getMessage(), isDebug);
                }
            }
            return (T)object;
        }
        return (T)object;
    }

    public static String getApiKey(Context object, String string2) {
        if (b.a((String)(object = (String)AppUtils.getMetaData(object, string2))).booleanValue()) {
            object = a.c;
        }
        return object;
    }

    public static int getVersionCode(Context context) {
        int n2;
        block4: {
            n2 = -1;
            if (context == null) {
                return n2;
            }
            context = context.getPackageManager().getPackageInfo(AppUtils.getPackageName(context), 1);
            if (context == null) break block4;
            try {
                n2 = context.versionCode;
            }
            catch (Exception exception) {
                b.a(TAG, exception.getMessage(), isDebug);
            }
        }
        return n2;
    }

    public static String getPackageName(Context context) {
        if (context == null) {
            b.c(TAG, "mContext \u4e3a\u7a7a", isDebug);
            return null;
        }
        try {
            return context.getPackageName();
        }
        catch (Exception exception) {
            b.a(TAG, exception.getMessage(), isDebug);
            return null;
        }
    }

    public static String getPackageName() {
        Class<?> clazz;
        try {
            clazz = Class.forName("android.app.ActivityThread");
        }
        catch (Exception exception) {
            b.a(TAG, exception.getMessage(), isDebug);
            return null;
        }
        Method method = clazz.getDeclaredMethod("currentPackageName", new Class[0]);
        Method method2 = method;
        method.setAccessible(true);
        return (String)method2.invoke(null, new Object[0]);
    }

    @SuppressLint(value={"NewApi"})
    public static int getAndroidSDKVersion(Context context) {
        int n2 = -1;
        try {
            n2 = Build.VERSION.SDK_INT;
        }
        catch (Exception exception) {
            b.a(TAG, exception.getMessage(), isDebug);
        }
        return n2;
    }

    public static String getAppLable(Context context) {
        String string2 = null;
        if (context == null) {
            boolean bl = isDebug;
            com.sdk.i.a.logError(TAG, "getAppLable", "mContext \u4e3a\u7a7a", bl);
            return string2;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            string2 = packageManager.getApplicationLabel(packageManager.getApplicationInfo(context.getPackageName(), 128)).toString();
        }
        catch (Exception exception) {
            b.a(TAG, exception.getMessage(), isDebug);
        }
        return string2;
    }

    public static Drawable getAppIcon(Context context) {
        Drawable drawable;
        block5: {
            drawable = null;
            if (context == null) {
                boolean bl = isDebug;
                com.sdk.i.a.logError(TAG, "getAppIcon", "mContext \u4e3a\u7a7a", bl);
                return drawable;
            }
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            if (packageInfo == null) break block5;
            Context context2 = context;
            int n2 = packageInfo.applicationInfo.icon;
            try {
                drawable = context2.getResources().getDrawable(n2);
            }
            catch (Exception exception) {
                b.a(TAG, exception.getMessage(), isDebug);
            }
        }
        return drawable;
    }

    public static boolean isServiceRunning(Context context, String string2) {
        Iterator iterator;
        if (context == null) {
            b.c(TAG, "isServiceRunning: mContext \u4e3a\u7a7a", isDebug);
            return false;
        }
        boolean bl = false;
        try {
            iterator = ((ActivityManager)context.getSystemService("activity")).getRunningServices(Integer.MAX_VALUE).iterator();
        }
        catch (Exception exception) {
            b.a(TAG, exception.getMessage(), isDebug);
            return bl;
        }
        while (true) {
            if (!iterator.hasNext()) break;
            if (!string2.equals(((ActivityManager.RunningServiceInfo)iterator.next()).service.getClassName())) continue;
            bl = true;
            continue;
            break;
        }
        return bl;
    }

    public static boolean isFirstLogin(Context context) {
        return false;
    }

    public static long getInstallDate(Context context) {
        Long l2 = com.sdk.j.a.b(context, c.a);
        if (l2 == 0L) {
            l2 = System.currentTimeMillis();
            com.sdk.j.a.a(context, c.a, l2);
        }
        return l2;
    }

    @SuppressLint(value={"NewApi"})
    public static int getTargetSdkVersion(Context context) {
        block5: {
            if (context == null) {
                return targetSdkVersion;
            }
            if (targetSdkVersion == -1) {
                context = context.getPackageManager().getPackageInfo(AppUtils.getPackageName(context), 1);
                if (context == null) break block5;
                try {
                    targetSdkVersion = context.applicationInfo.targetSdkVersion;
                }
                catch (Exception exception) {
                    b.a(TAG, exception.getMessage(), isDebug);
                }
            }
        }
        return targetSdkVersion;
    }

    public static String getAppMd5(Context context) {
        PackageManager packageManager = context.getPackageManager();
        Context context2 = context;
        context = null;
        try {
            context = packageManager.getPackageInfo(context2.getPackageName(), 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            b.a(TAG, nameNotFoundException.getMessage(), isDebug);
        }
        String string2 = null;
        if (context != null) {
            Context context3 = context;
            int cfr_ignored_0 = context3.applicationInfo.flags;
            try {
                string2 = AppUtils.doFingerprint(context3.signatures[0].toByteArray(), "MD5");
            }
            catch (Exception exception) {
                b.a(TAG, exception.getMessage(), isDebug);
            }
        }
        return string2;
    }

    private static String doFingerprint(byte[] byArray, String string2) {
        MessageDigest messageDigest = MessageDigest.getInstance(string2);
        messageDigest.update(byArray);
        byArray = messageDigest.digest();
        string2 = "";
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            String string3;
            if (i2 != 0) {
                string2 = string2 + ":";
            }
            if ((string3 = Integer.toHexString(byArray[i2] & 0xFF)).length() == 1) {
                string2 = string2 + "0";
            }
            string2 = string2 + string3;
        }
        return string2;
    }

    public void addActivity(Activity activity) {
        activityStack.add(activity);
    }

    public Activity currentActivity() {
        return (Activity)activityStack.lastElement();
    }

    public void finishActivity() {
        this.finishActivity((Activity)activityStack.lastElement());
    }

    public void finishActivity(Activity activity) {
        if (activity != null) {
            activityStack.remove(activity);
            activity.finish();
        }
    }

    public void finishActivity(Class<?> clazz) {
        for (Activity activity : activityStack) {
            if (!activity.getClass().equals(clazz)) continue;
            this.finishActivity(activity);
        }
    }

    public void finishAllActivity() {
        for (int i2 = 0; i2 < activityStack.size(); ++i2) {
            if (activityStack.get(i2) == null) continue;
            ((Activity)activityStack.get(i2)).finish();
        }
        activityStack.clear();
    }
}

