/*
 * Decompiled with CFR 0.152.
 */
package com.youth.banner;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.CompositePageTransformer;
import androidx.viewpager2.widget.MarginPageTransformer;
import androidx.viewpager2.widget.ViewPager2;
import com.youth.banner.R;
import com.youth.banner.adapter.BannerAdapter;
import com.youth.banner.config.BannerConfig;
import com.youth.banner.config.IndicatorConfig;
import com.youth.banner.indicator.Indicator;
import com.youth.banner.listener.OnBannerListener;
import com.youth.banner.listener.OnPageChangeListener;
import com.youth.banner.transformer.MZScaleInTransformer;
import com.youth.banner.transformer.ScaleInTransformer;
import com.youth.banner.util.BannerLifecycleObserver;
import com.youth.banner.util.BannerLifecycleObserverAdapter;
import com.youth.banner.util.BannerUtils;
import com.youth.banner.util.ScrollSpeedManger;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.List;

public class Banner<T, BA extends BannerAdapter<T, RecyclerView.ViewHolder>>
extends FrameLayout
implements BannerLifecycleObserver {
    public static final int INVALID_VALUE = -1;
    private ViewPager2 mViewPager2;
    private AutoLoopTask<T, BA> mLoopTask;
    private OnPageChangeListener mOnPageChangeListener;
    private BA mAdapter;
    private Indicator mIndicator;
    private CompositePageTransformer mCompositePageTransformer;
    private BannerOnPageChangeCallback mPageChangeCallback;
    private boolean mIsInfiniteLoop = true;
    private boolean mIsAutoLoop = true;
    private long mLoopTime = 3000L;
    private int mScrollTime = 600;
    private int mStartPosition = 1;
    private float mBannerRadius = 0.0f;
    private boolean mRoundTopLeft;
    private boolean mRoundTopRight;
    private boolean mRoundBottomLeft;
    private boolean mRoundBottomRight;
    private int normalWidth = BannerConfig.INDICATOR_NORMAL_WIDTH;
    private int selectedWidth = BannerConfig.INDICATOR_SELECTED_WIDTH;
    private int normalColor = -1996488705;
    private int selectedColor = -2013265920;
    private int indicatorGravity = 1;
    private int indicatorSpace;
    private int indicatorMargin;
    private int indicatorMarginLeft;
    private int indicatorMarginTop;
    private int indicatorMarginRight;
    private int indicatorMarginBottom;
    private int indicatorHeight = BannerConfig.INDICATOR_HEIGHT;
    private int indicatorRadius = BannerConfig.INDICATOR_RADIUS;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int mOrientation = 0;
    private int mTouchSlop;
    private float mStartX;
    private float mStartY;
    private boolean mIsViewPager2Drag;
    private boolean isIntercept = true;
    private Paint mRoundPaint;
    private Paint mImagePaint;
    private final RecyclerView.AdapterDataObserver mAdapterDataObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            if (Banner.this.getItemCount() <= 1) {
                Banner.this.stop();
            } else {
                Banner.this.start();
            }
            Banner.this.setIndicatorPageChange();
        }
    };

    public Banner(Context context) {
        this(context, null);
    }

    public Banner(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public Banner(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
        this.initTypedArray(context, attrs);
    }

    private void init(Context context) {
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop() / 2;
        this.mCompositePageTransformer = new CompositePageTransformer();
        this.mPageChangeCallback = new BannerOnPageChangeCallback();
        this.mLoopTask = new AutoLoopTask(this);
        this.mViewPager2 = new ViewPager2(context);
        this.mViewPager2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mViewPager2.setOffscreenPageLimit(2);
        this.mViewPager2.registerOnPageChangeCallback((ViewPager2.OnPageChangeCallback)this.mPageChangeCallback);
        this.mViewPager2.setPageTransformer((ViewPager2.PageTransformer)this.mCompositePageTransformer);
        ScrollSpeedManger.reflectLayoutManager(this);
        this.addView((View)this.mViewPager2);
        this.mRoundPaint = new Paint();
        this.mRoundPaint.setColor(0);
        this.mRoundPaint.setAntiAlias(true);
        this.mRoundPaint.setStyle(Paint.Style.FILL);
        this.mRoundPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
        this.mImagePaint = new Paint();
        this.mImagePaint.setXfermode(null);
    }

    private void initTypedArray(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Banner);
            this.mBannerRadius = a.getDimensionPixelSize(R.styleable.Banner_banner_radius, 0);
            this.mLoopTime = a.getInt(R.styleable.Banner_banner_loop_time, 3000);
            this.mIsAutoLoop = a.getBoolean(R.styleable.Banner_banner_auto_loop, true);
            this.mIsInfiniteLoop = a.getBoolean(R.styleable.Banner_banner_infinite_loop, true);
            this.normalWidth = a.getDimensionPixelSize(R.styleable.Banner_banner_indicator_normal_width, BannerConfig.INDICATOR_NORMAL_WIDTH);
            this.selectedWidth = a.getDimensionPixelSize(R.styleable.Banner_banner_indicator_selected_width, BannerConfig.INDICATOR_SELECTED_WIDTH);
            this.normalColor = a.getColor(R.styleable.Banner_banner_indicator_normal_color, -1996488705);
            this.selectedColor = a.getColor(R.styleable.Banner_banner_indicator_selected_color, -2013265920);
            this.indicatorGravity = a.getInt(R.styleable.Banner_banner_indicator_gravity, 1);
            this.indicatorSpace = a.getDimensionPixelSize(R.styleable.Banner_banner_indicator_space, 0);
            this.indicatorMargin = a.getDimensionPixelSize(R.styleable.Banner_banner_indicator_margin, 0);
            this.indicatorMarginLeft = a.getDimensionPixelSize(R.styleable.Banner_banner_indicator_marginLeft, 0);
            this.indicatorMarginTop = a.getDimensionPixelSize(R.styleable.Banner_banner_indicator_marginTop, 0);
            this.indicatorMarginRight = a.getDimensionPixelSize(R.styleable.Banner_banner_indicator_marginRight, 0);
            this.indicatorMarginBottom = a.getDimensionPixelSize(R.styleable.Banner_banner_indicator_marginBottom, 0);
            this.indicatorHeight = a.getDimensionPixelSize(R.styleable.Banner_banner_indicator_height, BannerConfig.INDICATOR_HEIGHT);
            this.indicatorRadius = a.getDimensionPixelSize(R.styleable.Banner_banner_indicator_radius, BannerConfig.INDICATOR_RADIUS);
            this.mOrientation = a.getInt(R.styleable.Banner_banner_orientation, 0);
            this.mRoundTopLeft = a.getBoolean(R.styleable.Banner_banner_round_top_left, false);
            this.mRoundTopRight = a.getBoolean(R.styleable.Banner_banner_round_top_right, false);
            this.mRoundBottomLeft = a.getBoolean(R.styleable.Banner_banner_round_bottom_left, false);
            this.mRoundBottomRight = a.getBoolean(R.styleable.Banner_banner_round_bottom_right, false);
            a.recycle();
        }
        this.setOrientation(this.mOrientation);
        this.setInfiniteLoop();
    }

    private void initIndicatorAttr() {
        if (this.indicatorMargin != 0) {
            this.setIndicatorMargins(new IndicatorConfig.Margins(this.indicatorMargin));
        } else if (this.indicatorMarginLeft != 0 || this.indicatorMarginTop != 0 || this.indicatorMarginRight != 0 || this.indicatorMarginBottom != 0) {
            this.setIndicatorMargins(new IndicatorConfig.Margins(this.indicatorMarginLeft, this.indicatorMarginTop, this.indicatorMarginRight, this.indicatorMarginBottom));
        }
        if (this.indicatorSpace > 0) {
            this.setIndicatorSpace(this.indicatorSpace);
        }
        if (this.indicatorGravity != 1) {
            this.setIndicatorGravity(this.indicatorGravity);
        }
        if (this.normalWidth > 0) {
            this.setIndicatorNormalWidth(this.normalWidth);
        }
        if (this.selectedWidth > 0) {
            this.setIndicatorSelectedWidth(this.selectedWidth);
        }
        if (this.indicatorHeight > 0) {
            this.setIndicatorHeight(this.indicatorHeight);
        }
        if (this.indicatorRadius > 0) {
            this.setIndicatorRadius(this.indicatorRadius);
        }
        this.setIndicatorNormalColor(this.normalColor);
        this.setIndicatorSelectedColor(this.selectedColor);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (!this.getViewPager2().isUserInputEnabled()) {
            return super.dispatchTouchEvent(ev);
        }
        int action = ev.getActionMasked();
        if (action == 1 || action == 3 || action == 4) {
            this.start();
        } else if (action == 0) {
            this.stop();
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (!this.getViewPager2().isUserInputEnabled() || !this.isIntercept) {
            return super.onInterceptTouchEvent(event);
        }
        switch (event.getAction()) {
            case 0: {
                this.mStartX = event.getX();
                this.mStartY = event.getY();
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 2: {
                float endX = event.getX();
                float endY = event.getY();
                float distanceX = Math.abs(endX - this.mStartX);
                float distanceY = Math.abs(endY - this.mStartY);
                this.mIsViewPager2Drag = this.getViewPager2().getOrientation() == 0 ? distanceX > (float)this.mTouchSlop && distanceX > distanceY : distanceY > (float)this.mTouchSlop && distanceY > distanceX;
                this.getParent().requestDisallowInterceptTouchEvent(this.mIsViewPager2Drag);
                break;
            }
            case 1: 
            case 3: {
                this.getParent().requestDisallowInterceptTouchEvent(false);
            }
        }
        return super.onInterceptTouchEvent(event);
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.mBannerRadius > 0.0f) {
            canvas.saveLayer(new RectF(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight()), this.mImagePaint, 31);
            super.dispatchDraw(canvas);
            if (!(this.mRoundTopRight || this.mRoundTopLeft || this.mRoundBottomRight || this.mRoundBottomLeft)) {
                this.drawTopLeft(canvas);
                this.drawTopRight(canvas);
                this.drawBottomLeft(canvas);
                this.drawBottomRight(canvas);
                canvas.restore();
                return;
            }
            if (this.mRoundTopLeft) {
                this.drawTopLeft(canvas);
            }
            if (this.mRoundTopRight) {
                this.drawTopRight(canvas);
            }
            if (this.mRoundBottomLeft) {
                this.drawBottomLeft(canvas);
            }
            if (this.mRoundBottomRight) {
                this.drawBottomRight(canvas);
            }
            canvas.restore();
        } else {
            super.dispatchDraw(canvas);
        }
    }

    private void drawTopLeft(Canvas canvas) {
        Path path = new Path();
        path.moveTo(0.0f, this.mBannerRadius);
        path.lineTo(0.0f, 0.0f);
        path.lineTo(this.mBannerRadius, 0.0f);
        path.arcTo(new RectF(0.0f, 0.0f, this.mBannerRadius * 2.0f, this.mBannerRadius * 2.0f), -90.0f, -90.0f);
        path.close();
        canvas.drawPath(path, this.mRoundPaint);
    }

    private void drawTopRight(Canvas canvas) {
        int width = this.getWidth();
        Path path = new Path();
        path.moveTo((float)width - this.mBannerRadius, 0.0f);
        path.lineTo((float)width, 0.0f);
        path.lineTo((float)width, this.mBannerRadius);
        path.arcTo(new RectF((float)width - 2.0f * this.mBannerRadius, 0.0f, (float)width, this.mBannerRadius * 2.0f), 0.0f, -90.0f);
        path.close();
        canvas.drawPath(path, this.mRoundPaint);
    }

    private void drawBottomLeft(Canvas canvas) {
        int height = this.getHeight();
        Path path = new Path();
        path.moveTo(0.0f, (float)height - this.mBannerRadius);
        path.lineTo(0.0f, (float)height);
        path.lineTo(this.mBannerRadius, (float)height);
        path.arcTo(new RectF(0.0f, (float)height - 2.0f * this.mBannerRadius, this.mBannerRadius * 2.0f, (float)height), 90.0f, 90.0f);
        path.close();
        canvas.drawPath(path, this.mRoundPaint);
    }

    private void drawBottomRight(Canvas canvas) {
        int height = this.getHeight();
        int width = this.getWidth();
        Path path = new Path();
        path.moveTo((float)width - this.mBannerRadius, (float)height);
        path.lineTo((float)width, (float)height);
        path.lineTo((float)width, (float)height - this.mBannerRadius);
        path.arcTo(new RectF((float)width - 2.0f * this.mBannerRadius, (float)height - 2.0f * this.mBannerRadius, (float)width, (float)height), 0.0f, 90.0f);
        path.close();
        canvas.drawPath(path, this.mRoundPaint);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.start();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stop();
    }

    private void initIndicator() {
        if (this.getIndicator() == null || this.getAdapter() == null) {
            return;
        }
        if (this.getIndicator().getIndicatorConfig().isAttachToBanner()) {
            this.removeIndicator();
            this.addView(this.getIndicator().getIndicatorView());
        }
        this.initIndicatorAttr();
        this.setIndicatorPageChange();
    }

    private void setInfiniteLoop() {
        if (!this.isInfiniteLoop()) {
            this.isAutoLoop(false);
        }
        this.setStartPosition(this.isInfiniteLoop() ? this.mStartPosition : 0);
    }

    private void setRecyclerViewPadding(int itemPadding) {
        this.setRecyclerViewPadding(itemPadding, itemPadding);
    }

    private void setRecyclerViewPadding(int leftItemPadding, int rightItemPadding) {
        RecyclerView recyclerView = (RecyclerView)this.getViewPager2().getChildAt(0);
        if (this.getViewPager2().getOrientation() == 1) {
            recyclerView.setPadding(this.mViewPager2.getPaddingLeft(), leftItemPadding, this.mViewPager2.getPaddingRight(), rightItemPadding);
        } else {
            recyclerView.setPadding(leftItemPadding, this.mViewPager2.getPaddingTop(), rightItemPadding, this.mViewPager2.getPaddingBottom());
        }
        recyclerView.setClipToPadding(false);
    }

    public int getCurrentItem() {
        return this.getViewPager2().getCurrentItem();
    }

    public int getItemCount() {
        if (this.getAdapter() != null) {
            return this.getAdapter().getItemCount();
        }
        return 0;
    }

    public int getScrollTime() {
        return this.mScrollTime;
    }

    public boolean isInfiniteLoop() {
        return this.mIsInfiniteLoop;
    }

    public BannerAdapter getAdapter() {
        return this.mAdapter;
    }

    public ViewPager2 getViewPager2() {
        return this.mViewPager2;
    }

    public Indicator getIndicator() {
        return this.mIndicator;
    }

    public IndicatorConfig getIndicatorConfig() {
        if (this.getIndicator() != null) {
            return this.getIndicator().getIndicatorConfig();
        }
        return null;
    }

    public int getRealCount() {
        if (this.getAdapter() != null) {
            return this.getAdapter().getRealCount();
        }
        return 0;
    }

    public Banner<T, BA> setIntercept(boolean intercept) {
        this.isIntercept = intercept;
        return this;
    }

    public Banner<T, BA> setCurrentItem(int position) {
        return this.setCurrentItem(position, true);
    }

    public Banner<T, BA> setCurrentItem(int position, boolean smoothScroll) {
        this.getViewPager2().setCurrentItem(position, smoothScroll);
        return this;
    }

    public Banner<T, BA> setIndicatorPageChange() {
        if (this.getIndicator() != null) {
            int realPosition = BannerUtils.getRealPosition(this.isInfiniteLoop(), this.getCurrentItem(), this.getRealCount());
            this.getIndicator().onPageChanged(this.getRealCount(), realPosition);
        }
        return this;
    }

    public Banner<T, BA> removeIndicator() {
        if (this.getIndicator() != null) {
            this.removeView(this.getIndicator().getIndicatorView());
        }
        return this;
    }

    public Banner<T, BA> setStartPosition(int mStartPosition) {
        this.mStartPosition = mStartPosition;
        return this;
    }

    public int getStartPosition() {
        return this.mStartPosition;
    }

    public Banner<T, BA> setUserInputEnabled(boolean enabled) {
        this.getViewPager2().setUserInputEnabled(enabled);
        return this;
    }

    public Banner<T, BA> addPageTransformer(@Nullable ViewPager2.PageTransformer transformer) {
        this.mCompositePageTransformer.addTransformer(transformer);
        return this;
    }

    public Banner<T, BA> setPageTransformer(@Nullable ViewPager2.PageTransformer transformer) {
        this.getViewPager2().setPageTransformer(transformer);
        return this;
    }

    public Banner<T, BA> removeTransformer(ViewPager2.PageTransformer transformer) {
        this.mCompositePageTransformer.removeTransformer(transformer);
        return this;
    }

    public Banner<T, BA> addItemDecoration(RecyclerView.ItemDecoration decor) {
        this.getViewPager2().addItemDecoration(decor);
        return this;
    }

    public Banner<T, BA> addItemDecoration(RecyclerView.ItemDecoration decor, int index) {
        this.getViewPager2().addItemDecoration(decor, index);
        return this;
    }

    public Banner<T, BA> isAutoLoop(boolean isAutoLoop) {
        this.mIsAutoLoop = isAutoLoop;
        return this;
    }

    public Banner<T, BA> setLoopTime(long loopTime) {
        this.mLoopTime = loopTime;
        return this;
    }

    public Banner<T, BA> setScrollTime(int scrollTime) {
        this.mScrollTime = scrollTime;
        return this;
    }

    public Banner<T, BA> start() {
        if (this.mIsAutoLoop) {
            this.stop();
            this.postDelayed(this.mLoopTask, this.mLoopTime);
        }
        return this;
    }

    public Banner<T, BA> stop() {
        if (this.mIsAutoLoop) {
            this.removeCallbacks(this.mLoopTask);
        }
        return this;
    }

    public void destroy() {
        if (this.getViewPager2() != null && this.mPageChangeCallback != null) {
            this.getViewPager2().unregisterOnPageChangeCallback((ViewPager2.OnPageChangeCallback)this.mPageChangeCallback);
            this.mPageChangeCallback = null;
        }
        this.stop();
    }

    public Banner<T, BA> setAdapter(BA adapter) {
        if (adapter == null) {
            throw new NullPointerException(this.getContext().getString(R.string.banner_adapter_null_error));
        }
        this.mAdapter = adapter;
        if (!this.isInfiniteLoop()) {
            this.getAdapter().setIncreaseCount(0);
        }
        this.getAdapter().registerAdapterDataObserver(this.mAdapterDataObserver);
        this.mViewPager2.setAdapter(adapter);
        this.setCurrentItem(this.mStartPosition, false);
        this.initIndicator();
        return this;
    }

    public Banner<T, BA> setAdapter(BA adapter, boolean isInfiniteLoop) {
        this.mIsInfiniteLoop = isInfiniteLoop;
        this.setInfiniteLoop();
        this.setAdapter(adapter);
        return this;
    }

    public Banner<T, BA> setDatas(List<T> datas) {
        if (this.getAdapter() != null) {
            this.getAdapter().setDatas(datas);
            this.getAdapter().notifyDataSetChanged();
            this.setCurrentItem(this.mStartPosition, false);
            this.setIndicatorPageChange();
            this.start();
        }
        return this;
    }

    public Banner<T, BA> setOrientation(int orientation) {
        this.getViewPager2().setOrientation(orientation);
        return this;
    }

    public Banner<T, BA> setTouchSlop(int mTouchSlop) {
        this.mTouchSlop = mTouchSlop;
        return this;
    }

    public Banner<T, BA> setOnBannerListener(OnBannerListener<T> listener) {
        if (this.getAdapter() != null) {
            this.getAdapter().setOnBannerListener(listener);
        }
        return this;
    }

    public Banner<T, BA> addOnPageChangeListener(OnPageChangeListener pageListener) {
        this.mOnPageChangeListener = pageListener;
        return this;
    }

    public Banner<T, BA> setBannerRound(float radius) {
        this.mBannerRadius = radius;
        return this;
    }

    @RequiresApi(api=21)
    public Banner<T, BA> setBannerRound2(float radius) {
        BannerUtils.setBannerRound((View)this, radius);
        return this;
    }

    public Banner<T, BA> setBannerGalleryEffect(int itemWidth, int pageMargin) {
        return this.setBannerGalleryEffect(itemWidth, pageMargin, 0.85f);
    }

    public Banner<T, BA> setBannerGalleryEffect(int leftItemWidth, int rightItemWidth, int pageMargin) {
        return this.setBannerGalleryEffect(leftItemWidth, rightItemWidth, pageMargin, 0.85f);
    }

    public Banner<T, BA> setBannerGalleryEffect(int itemWidth, int pageMargin, float scale) {
        return this.setBannerGalleryEffect(itemWidth, itemWidth, pageMargin, scale);
    }

    public Banner<T, BA> setBannerGalleryEffect(int leftItemWidth, int rightItemWidth, int pageMargin, float scale) {
        if (pageMargin > 0) {
            this.addPageTransformer((ViewPager2.PageTransformer)new MarginPageTransformer(BannerUtils.dp2px(pageMargin)));
        }
        if (scale < 1.0f && scale > 0.0f) {
            this.addPageTransformer(new ScaleInTransformer(scale));
        }
        this.setRecyclerViewPadding(leftItemWidth > 0 ? BannerUtils.dp2px(leftItemWidth + pageMargin) : 0, rightItemWidth > 0 ? BannerUtils.dp2px(rightItemWidth + pageMargin) : 0);
        return this;
    }

    public Banner<T, BA> setBannerGalleryMZ(int itemWidth) {
        return this.setBannerGalleryMZ(itemWidth, 0.88f);
    }

    public Banner<T, BA> setBannerGalleryMZ(int itemWidth, float scale) {
        if (scale < 1.0f && scale > 0.0f) {
            this.addPageTransformer(new MZScaleInTransformer(scale));
        }
        this.setRecyclerViewPadding(BannerUtils.dp2px(itemWidth));
        return this;
    }

    public Banner<T, BA> setIndicator(Indicator indicator) {
        return this.setIndicator(indicator, true);
    }

    public Banner<T, BA> setIndicator(Indicator indicator, boolean attachToBanner) {
        this.removeIndicator();
        indicator.getIndicatorConfig().setAttachToBanner(attachToBanner);
        this.mIndicator = indicator;
        this.initIndicator();
        return this;
    }

    public Banner<T, BA> setIndicatorSelectedColor(@ColorInt int color) {
        if (this.getIndicatorConfig() != null) {
            this.getIndicatorConfig().setSelectedColor(color);
        }
        return this;
    }

    public Banner<T, BA> setIndicatorSelectedColorRes(@ColorRes int color) {
        this.setIndicatorSelectedColor(ContextCompat.getColor((Context)this.getContext(), (int)color));
        return this;
    }

    public Banner<T, BA> setIndicatorNormalColor(@ColorInt int color) {
        if (this.getIndicatorConfig() != null) {
            this.getIndicatorConfig().setNormalColor(color);
        }
        return this;
    }

    public Banner<T, BA> setIndicatorNormalColorRes(@ColorRes int color) {
        this.setIndicatorNormalColor(ContextCompat.getColor((Context)this.getContext(), (int)color));
        return this;
    }

    public Banner<T, BA> setIndicatorGravity(int gravity) {
        if (this.getIndicatorConfig() != null && this.getIndicatorConfig().isAttachToBanner()) {
            this.getIndicatorConfig().setGravity(gravity);
            this.getIndicator().getIndicatorView().postInvalidate();
        }
        return this;
    }

    public Banner<T, BA> setIndicatorSpace(int indicatorSpace) {
        if (this.getIndicatorConfig() != null) {
            this.getIndicatorConfig().setIndicatorSpace(indicatorSpace);
        }
        return this;
    }

    public Banner<T, BA> setIndicatorMargins(IndicatorConfig.Margins margins) {
        if (this.getIndicatorConfig() != null && this.getIndicatorConfig().isAttachToBanner()) {
            this.getIndicatorConfig().setMargins(margins);
            this.getIndicator().getIndicatorView().requestLayout();
        }
        return this;
    }

    public Banner<T, BA> setIndicatorWidth(int normalWidth, int selectedWidth) {
        if (this.getIndicatorConfig() != null) {
            this.getIndicatorConfig().setNormalWidth(normalWidth);
            this.getIndicatorConfig().setSelectedWidth(selectedWidth);
        }
        return this;
    }

    public Banner<T, BA> setIndicatorNormalWidth(int normalWidth) {
        if (this.getIndicatorConfig() != null) {
            this.getIndicatorConfig().setNormalWidth(normalWidth);
        }
        return this;
    }

    public Banner<T, BA> setIndicatorSelectedWidth(int selectedWidth) {
        if (this.getIndicatorConfig() != null) {
            this.getIndicatorConfig().setSelectedWidth(selectedWidth);
        }
        return this;
    }

    public Banner setIndicatorRadius(int indicatorRadius) {
        if (this.getIndicatorConfig() != null) {
            this.getIndicatorConfig().setRadius(indicatorRadius);
        }
        return this;
    }

    public Banner setIndicatorHeight(int indicatorHeight) {
        if (this.getIndicatorConfig() != null) {
            this.getIndicatorConfig().setHeight(indicatorHeight);
        }
        return this;
    }

    public Banner<T, BA> addBannerLifecycleObserver(LifecycleOwner owner) {
        if (owner != null) {
            owner.getLifecycle().addObserver((LifecycleObserver)new BannerLifecycleObserverAdapter(owner, this));
        }
        return this;
    }

    @Override
    public void onStart(LifecycleOwner owner) {
        this.start();
    }

    @Override
    public void onStop(LifecycleOwner owner) {
        this.stop();
    }

    @Override
    public void onDestroy(LifecycleOwner owner) {
        this.destroy();
    }

    static class AutoLoopTask<T, BA extends BannerAdapter<T, RecyclerView.ViewHolder>>
    implements Runnable {
        private final WeakReference<Banner<T, BA>> reference;

        AutoLoopTask(Banner<T, BA> banner) {
            this.reference = new WeakReference<Banner<Banner<T, BA>, BA>>(banner);
        }

        @Override
        public void run() {
            Banner banner = (Banner)this.reference.get();
            if (banner != null && banner.mIsAutoLoop) {
                int count = banner.getItemCount();
                if (count == 0) {
                    return;
                }
                int next = (banner.getCurrentItem() + 1) % count;
                banner.setCurrentItem(next);
                banner.postDelayed(banner.mLoopTask, banner.mLoopTime);
            }
        }
    }

    class BannerOnPageChangeCallback
    extends ViewPager2.OnPageChangeCallback {
        private int mTempPosition = -1;
        private boolean isScrolled;

        BannerOnPageChangeCallback() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            int realPosition = BannerUtils.getRealPosition(Banner.this.isInfiniteLoop(), position, Banner.this.getRealCount());
            if (Banner.this.mOnPageChangeListener != null && realPosition == Banner.this.getCurrentItem() - 1) {
                Banner.this.mOnPageChangeListener.onPageScrolled(realPosition, positionOffset, positionOffsetPixels);
            }
            if (Banner.this.getIndicator() != null && realPosition == Banner.this.getCurrentItem() - 1) {
                Banner.this.getIndicator().onPageScrolled(realPosition, positionOffset, positionOffsetPixels);
            }
        }

        public void onPageSelected(int position) {
            if (this.isScrolled) {
                this.mTempPosition = position;
                int realPosition = BannerUtils.getRealPosition(Banner.this.isInfiniteLoop(), position, Banner.this.getRealCount());
                if (Banner.this.mOnPageChangeListener != null) {
                    Banner.this.mOnPageChangeListener.onPageSelected(realPosition);
                }
                if (Banner.this.getIndicator() != null) {
                    Banner.this.getIndicator().onPageSelected(realPosition);
                }
            }
        }

        public void onPageScrollStateChanged(int state) {
            if (state == 1 || state == 2) {
                this.isScrolled = true;
            } else if (state == 0) {
                this.isScrolled = false;
                if (this.mTempPosition != -1 && Banner.this.mIsInfiniteLoop) {
                    if (this.mTempPosition == 0) {
                        Banner.this.setCurrentItem(Banner.this.getRealCount(), false);
                    } else if (this.mTempPosition == Banner.this.getItemCount() - 1) {
                        Banner.this.setCurrentItem(1, false);
                    }
                }
            }
            if (Banner.this.mOnPageChangeListener != null) {
                Banner.this.mOnPageChangeListener.onPageScrollStateChanged(state);
            }
            if (Banner.this.getIndicator() != null) {
                Banner.this.getIndicator().onPageScrollStateChanged(state);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Orientation {
    }
}

