/*
 * Decompiled with CFR 0.152.
 */
package com.youth.banner.indicator;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import com.youth.banner.indicator.BaseIndicator;

public class CircleIndicator
extends BaseIndicator {
    private int mNormalRadius;
    private int mSelectedRadius;
    private int maxRadius;

    public CircleIndicator(Context context) {
        this(context, null);
    }

    public CircleIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mNormalRadius = this.config.getNormalWidth() / 2;
        this.mSelectedRadius = this.config.getSelectedWidth() / 2;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int count = this.config.getIndicatorSize();
        if (count <= 1) {
            return;
        }
        this.mNormalRadius = this.config.getNormalWidth() / 2;
        this.mSelectedRadius = this.config.getSelectedWidth() / 2;
        this.maxRadius = Math.max(this.mSelectedRadius, this.mNormalRadius);
        int width = (count - 1) * this.config.getIndicatorSpace() + this.config.getSelectedWidth() + this.config.getNormalWidth() * (count - 1);
        this.setMeasuredDimension(width, Math.max(this.config.getNormalWidth(), this.config.getSelectedWidth()));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int count = this.config.getIndicatorSize();
        if (count <= 1) {
            return;
        }
        float left = 0.0f;
        for (int i = 0; i < count; ++i) {
            this.mPaint.setColor(this.config.getCurrentPosition() == i ? this.config.getSelectedColor() : this.config.getNormalColor());
            int indicatorWidth = this.config.getCurrentPosition() == i ? this.config.getSelectedWidth() : this.config.getNormalWidth();
            int radius = this.config.getCurrentPosition() == i ? this.mSelectedRadius : this.mNormalRadius;
            canvas.drawCircle(left + (float)radius, (float)this.maxRadius, (float)radius, this.mPaint);
            left += (float)(indicatorWidth + this.config.getIndicatorSpace());
        }
    }
}

