/*
 * Decompiled with CFR 0.152.
 */
package com.youth.banner.indicator;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import com.youth.banner.indicator.BaseIndicator;

public class RoundLinesIndicator
extends BaseIndicator {
    public RoundLinesIndicator(Context context) {
        this(context, null);
    }

    public RoundLinesIndicator(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundLinesIndicator(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int count = this.config.getIndicatorSize();
        if (count <= 1) {
            return;
        }
        this.setMeasuredDimension(this.config.getSelectedWidth() * count, this.config.getHeight());
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int count = this.config.getIndicatorSize();
        if (count <= 1) {
            return;
        }
        this.mPaint.setColor(this.config.getNormalColor());
        RectF oval = new RectF(0.0f, 0.0f, (float)canvas.getWidth(), (float)this.config.getHeight());
        canvas.drawRoundRect(oval, (float)this.config.getRadius(), (float)this.config.getRadius(), this.mPaint);
        this.mPaint.setColor(this.config.getSelectedColor());
        int left = this.config.getCurrentPosition() * this.config.getSelectedWidth();
        RectF rectF = new RectF((float)left, 0.0f, (float)(left + this.config.getSelectedWidth()), (float)this.config.getHeight());
        canvas.drawRoundRect(rectF, (float)this.config.getRadius(), (float)this.config.getRadius(), this.mPaint);
    }
}

