/*
 * Decompiled with CFR 0.152.
 */
package com.youth.banner.transformer;

import android.view.View;
import androidx.annotation.NonNull;
import com.youth.banner.transformer.BasePageTransformer;

public class RotateYTransformer
extends BasePageTransformer {
    private static final float DEFAULT_MAX_ROTATE = 35.0f;
    private float mMaxRotate = 35.0f;

    public RotateYTransformer() {
    }

    public RotateYTransformer(float maxRotate) {
        this.mMaxRotate = maxRotate;
    }

    public void transformPage(@NonNull View view, float position) {
        view.setPivotY((float)(view.getHeight() / 2));
        if (position < -1.0f) {
            view.setRotationY(-1.0f * this.mMaxRotate);
            view.setPivotX((float)view.getWidth());
        } else if (position <= 1.0f) {
            view.setRotationY(position * this.mMaxRotate);
            if (position < 0.0f) {
                view.setPivotX((float)view.getWidth() * (0.5f + 0.5f * -position));
                view.setPivotX((float)view.getWidth());
            } else {
                view.setPivotX((float)view.getWidth() * 0.5f * (1.0f - position));
                view.setPivotX(0.0f);
            }
        } else {
            view.setRotationY(1.0f * this.mMaxRotate);
            view.setPivotX(0.0f);
        }
    }
}

