/*
 * Decompiled with CFR 0.152.
 */
package com.youth.banner.itemdecoration;

import android.graphics.Rect;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Px;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

public class MarginDecoration
extends RecyclerView.ItemDecoration {
    private int mMarginPx;

    public MarginDecoration(@Px int margin) {
        this.mMarginPx = margin;
    }

    public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        LinearLayoutManager linearLayoutManager = this.requireLinearLayoutManager(parent);
        if (linearLayoutManager.getOrientation() == 1) {
            outRect.top = this.mMarginPx;
            outRect.bottom = this.mMarginPx;
        } else {
            outRect.left = this.mMarginPx;
            outRect.right = this.mMarginPx;
        }
    }

    private LinearLayoutManager requireLinearLayoutManager(@NonNull RecyclerView parent) {
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            return (LinearLayoutManager)layoutManager;
        }
        throw new IllegalStateException("The layoutManager must be LinearLayoutManager");
    }
}

