/*
 * Decompiled with CFR 0.152.
 */
package com.youth.banner.adapter;

import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.youth.banner.R;
import com.youth.banner.holder.IViewHolder;
import com.youth.banner.listener.OnBannerListener;
import com.youth.banner.util.BannerUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class BannerAdapter<T, VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH>
implements IViewHolder<T, VH> {
    protected List<T> mDatas = new ArrayList<T>();
    private OnBannerListener<T> mOnBannerListener;
    private VH mViewHolder;
    private int mIncreaseCount = 2;

    public BannerAdapter(List<T> datas) {
        this.setDatas(datas);
    }

    public void setDatas(List<T> datas) {
        if (datas == null) {
            datas = new ArrayList<T>();
        }
        this.mDatas.clear();
        this.mDatas.addAll(datas);
        this.notifyDataSetChanged();
    }

    public T getData(int position) {
        if (position > this.mDatas.size() - 1) {
            return null;
        }
        return this.mDatas.get(position);
    }

    public T getRealData(int position) {
        int realPosition = this.getRealPosition(position);
        if (realPosition > this.mDatas.size() - 1) {
            return null;
        }
        return this.mDatas.get(realPosition);
    }

    public final void onBindViewHolder(@NonNull VH holder, int position) {
        this.mViewHolder = holder;
        int real = this.getRealPosition(position);
        T data = this.mDatas.get(real);
        ((RecyclerView.ViewHolder)holder).itemView.setTag(R.id.banner_data_key, data);
        ((RecyclerView.ViewHolder)holder).itemView.setTag(R.id.banner_pos_key, (Object)real);
        this.onBindView(holder, this.mDatas.get(real), real, this.getRealCount());
        if (this.mOnBannerListener != null) {
            ((RecyclerView.ViewHolder)holder).itemView.setOnClickListener(view -> this.mOnBannerListener.OnBannerClick(data, real));
        }
    }

    @NonNull
    public VH onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        RecyclerView.ViewHolder vh = (RecyclerView.ViewHolder)this.onCreateHolder(parent, viewType);
        vh.itemView.setOnClickListener(v -> {
            if (this.mOnBannerListener != null) {
                Object data = vh.itemView.getTag(R.id.banner_data_key);
                int real = (Integer)vh.itemView.getTag(R.id.banner_pos_key);
                this.mOnBannerListener.OnBannerClick(data, real);
            }
        });
        return (VH)vh;
    }

    public int getItemCount() {
        return this.getRealCount() > 1 ? this.getRealCount() + this.mIncreaseCount : this.getRealCount();
    }

    public int getRealCount() {
        return this.mDatas == null ? 0 : this.mDatas.size();
    }

    public int getRealPosition(int position) {
        return BannerUtils.getRealPosition(this.mIncreaseCount == 2, position, this.getRealCount());
    }

    public void setOnBannerListener(OnBannerListener<T> listener) {
        this.mOnBannerListener = listener;
    }

    public VH getViewHolder() {
        return this.mViewHolder;
    }

    public void setIncreaseCount(int increaseCount) {
        this.mIncreaseCount = increaseCount;
    }
}

