/*
 * Decompiled with CFR 0.152.
 */
package io.github.yurimarx.hibernateirisdialect.function;

import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class IRISFunctionFactory
extends CommonFunctionFactory {
    private final BasicType<Double> doubleType;
    private final BasicType<String> stringType;
    private final BasicType<Integer> integerType;
    private final SqmFunctionRegistry functionRegistry;
    private final TypeConfiguration typeConfiguration;

    public IRISFunctionFactory(FunctionContributions functionContributions) {
        super(functionContributions);
        this.functionRegistry = functionContributions.getFunctionRegistry();
        this.typeConfiguration = functionContributions.getTypeConfiguration();
        BasicTypeRegistry basicTypeRegistry = this.typeConfiguration.getBasicTypeRegistry();
        this.doubleType = basicTypeRegistry.resolve(StandardBasicTypes.DOUBLE);
        this.stringType = basicTypeRegistry.resolve(StandardBasicTypes.STRING);
        this.integerType = basicTypeRegistry.resolve(StandardBasicTypes.INTEGER);
    }

    public void cot() {
        this.functionRegistry.patternDescriptorBuilder("cot", "{fn cot(?1)}").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.NUMERIC}).register();
    }

    public void exp() {
        this.functionRegistry.patternDescriptorBuilder("exp", "{fn exp(?1)}").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.NUMERIC}).register();
    }

    public void sinCosTanAtan2() {
        this.functionRegistry.patternDescriptorBuilder("sin", "{fn sin(?1)}").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.NUMERIC}).register();
        this.functionRegistry.patternDescriptorBuilder("cos", "{fn cos(?1)}").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.NUMERIC}).register();
        this.functionRegistry.patternDescriptorBuilder("tan", "{fn tan(?1)}").setInvariantType(this.doubleType).setExactArgumentCount(1).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.NUMERIC}).register();
        this.functionRegistry.patternDescriptorBuilder("atan2", "{fn atan2(?1,?2)}").setInvariantType(this.doubleType).setExactArgumentCount(2).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.NUMERIC, FunctionParameterType.NUMERIC}).register();
    }

    public void pi() {
        this.functionRegistry.patternDescriptorBuilder("pi", "{fn pi()}").setInvariantType(this.doubleType).setExactArgumentCount(0).setArgumentListSignature("").register();
    }

    public void daynameMonthname() {
        this.functionRegistry.patternDescriptorBuilder("monthname", "{fn monthname(?1)}").setInvariantType(this.stringType).setExactArgumentCount(1).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.DATE}).register();
        this.functionRegistry.patternDescriptorBuilder("dayname", "{fn dayname(?1)}").setInvariantType(this.stringType).setExactArgumentCount(1).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.DATE}).register();
    }

    public void dayofweekmonthyear() {
        this.functionRegistry.patternDescriptorBuilder("dayofweek", "{fn dayofweek(?1)}").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.DATE}).register();
        this.functionRegistry.patternDescriptorBuilder("dayofmonth", "{fn dayofmonth(?1)}").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.DATE}).register();
        this.functionRegistry.patternDescriptorBuilder("dayofyear", "{fn dayofyear(?1)}").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.DATE}).register();
        this.functionRegistry.registerAlternateKey("day", "dayofmonth");
    }
}

