/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.format;

import com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import com.sedmelluq.discord.lavaplayer.format.transcoder.AudioChunkDecoder;
import com.sedmelluq.discord.lavaplayer.format.transcoder.AudioChunkEncoder;
import com.sedmelluq.discord.lavaplayer.format.transcoder.PcmChunkDecoder;
import com.sedmelluq.discord.lavaplayer.format.transcoder.PcmChunkEncoder;
import com.sedmelluq.discord.lavaplayer.player.AudioConfiguration;

public class Pcm16AudioDataFormat
extends AudioDataFormat {
    public static final String CODEC_NAME_BE = "PCM_S16_BE";
    public static final String CODEC_NAME_LE = "PCM_S16_LE";
    private final boolean bigEndian;
    private final byte[] silenceBytes;

    public Pcm16AudioDataFormat(int channelCount, int sampleRate, int chunkSampleCount, boolean bigEndian) {
        super(channelCount, sampleRate, chunkSampleCount);
        this.bigEndian = bigEndian;
        this.silenceBytes = new byte[channelCount * chunkSampleCount * 2];
    }

    @Override
    public String codecName() {
        return this.bigEndian ? CODEC_NAME_BE : CODEC_NAME_LE;
    }

    @Override
    public byte[] silenceBytes() {
        return this.silenceBytes;
    }

    @Override
    public int expectedChunkSize() {
        return this.silenceBytes.length;
    }

    @Override
    public int maximumChunkSize() {
        return this.silenceBytes.length;
    }

    @Override
    public AudioChunkDecoder createDecoder() {
        return new PcmChunkDecoder(this, this.bigEndian);
    }

    @Override
    public AudioChunkEncoder createEncoder(AudioConfiguration configuration) {
        return new PcmChunkEncoder(this, this.bigEndian);
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

