/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.source.youtube.DefaultYoutubeTrackDetails;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeSignatureCipher;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackDetails;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackDetailsLoader;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackJsonData;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultYoutubeTrackDetailsLoader
implements YoutubeTrackDetailsLoader {
    private static final Logger log = LoggerFactory.getLogger(DefaultYoutubeTrackDetailsLoader.class);
    private volatile CachedPlayerScript cachedPlayerScript = null;

    @Override
    public YoutubeTrackDetails loadDetails(HttpInterface httpInterface, String videoId, boolean requireFormats, YoutubeAudioSourceManager sourceManager) {
        try {
            return this.load(httpInterface, videoId, requireFormats, sourceManager);
        }
        catch (IOException e) {
            throw ExceptionTools.toRuntimeException(e);
        }
    }

    private YoutubeTrackDetails load(HttpInterface httpInterface, String videoId, boolean requireFormats, YoutubeAudioSourceManager sourceManager) throws IOException {
        JsonBrowser mainInfo = this.loadTrackInfoFromInnertube(httpInterface, videoId, sourceManager);
        try {
            YoutubeTrackJsonData initialData = this.loadBaseResponse(mainInfo, httpInterface, videoId);
            if (initialData == null) {
                return null;
            }
            YoutubeTrackJsonData finalData = this.augmentWithPlayerScript(initialData, httpInterface, requireFormats);
            return new DefaultYoutubeTrackDetails(videoId, finalData);
        }
        catch (FriendlyException e) {
            throw e;
        }
        catch (Exception e) {
            throw ExceptionTools.throwWithDebugInfo(log, e, "Error when extracting data", "mainJson", mainInfo.format());
        }
    }

    protected YoutubeTrackJsonData loadBaseResponse(JsonBrowser mainInfo, HttpInterface httpInterface, String videoId) throws IOException {
        YoutubeTrackJsonData data = YoutubeTrackJsonData.fromMainResult(mainInfo);
        InfoStatus status = this.checkPlayabilityStatus(data.playerResponse);
        if (status == InfoStatus.DOES_NOT_EXIST) {
            return null;
        }
        if (status == InfoStatus.REQUIRES_LOGIN) {
            throw new FriendlyException("This video requires age verification.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("You did not configured right YoutubeHttpContextFilter, check https://github.com/Walkyst/lavaplayer-fork/issues/18 issue for fixing this."));
        }
        if (status == InfoStatus.CONTENT_CHECK_REQUIRED) {
            JsonBrowser trackInfo = this.loadTrackInfoWithContentVerify(httpInterface, videoId);
            return YoutubeTrackJsonData.fromMainResult(trackInfo);
        }
        return data;
    }

    protected InfoStatus checkPlayabilityStatus(JsonBrowser playerResponse) {
        JsonBrowser statusBlock = playerResponse.get("playabilityStatus");
        if (statusBlock.isNull()) {
            throw new RuntimeException("No playability status block.");
        }
        String status = statusBlock.get("status").text();
        if (status == null) {
            throw new RuntimeException("No playability status field.");
        }
        if ("OK".equals(status)) {
            return InfoStatus.INFO_PRESENT;
        }
        if ("ERROR".equals(status)) {
            String reason = statusBlock.get("reason").text();
            if ("Video unavailable".equals(reason)) {
                return InfoStatus.DOES_NOT_EXIST;
            }
            throw new FriendlyException(reason, FriendlyException.Severity.COMMON, null);
        }
        if ("UNPLAYABLE".equals(status)) {
            String unplayableReason = this.getUnplayableReason(statusBlock);
            throw new FriendlyException(unplayableReason, FriendlyException.Severity.COMMON, null);
        }
        if ("LOGIN_REQUIRED".equals(status)) {
            String errorReason = statusBlock.get("errorScreen").get("playerErrorMessageRenderer").get("reason").get("simpleText").text();
            if ("Private video".equals(errorReason)) {
                throw new FriendlyException("This is a private video.", FriendlyException.Severity.COMMON, null);
            }
            return InfoStatus.REQUIRES_LOGIN;
        }
        if ("CONTENT_CHECK_REQUIRED".equals(status)) {
            return InfoStatus.CONTENT_CHECK_REQUIRED;
        }
        throw new FriendlyException("This video cannot be viewed anonymously.", FriendlyException.Severity.COMMON, null);
    }

    protected String getUnplayableReason(JsonBrowser statusBlock) {
        JsonBrowser playerErrorMessage = statusBlock.get("errorScreen").get("playerErrorMessageRenderer");
        String unplayableReason = statusBlock.get("reason").text();
        if (!playerErrorMessage.get("subreason").isNull()) {
            JsonBrowser subreason = playerErrorMessage.get("subreason");
            if (!subreason.get("simpleText").isNull()) {
                unplayableReason = subreason.get("simpleText").text();
            } else if (!subreason.get("runs").isNull() && subreason.get("runs").isList()) {
                StringBuilder reasonBuilder = new StringBuilder();
                subreason.get("runs").values().forEach(item -> reasonBuilder.append(item.get("text").text()).append('\n'));
                unplayableReason = reasonBuilder.toString();
            }
        }
        return unplayableReason;
    }

    protected JsonBrowser loadTrackInfoFromInnertube(HttpInterface httpInterface, String videoId, YoutubeAudioSourceManager sourceManager) throws IOException {
        if (this.cachedPlayerScript == null) {
            this.fetchScript(httpInterface);
        }
        YoutubeSignatureCipher playerScriptTimestamp = sourceManager.getSignatureResolver().getCipherKeyAndTimestampFromScript(httpInterface, this.cachedPlayerScript.playerScriptUrl);
        HttpPost post = new HttpPost("https://www.youtube.com/youtubei/v1/player?key=AIzaSyAO_FJ2SlqU8Q4STEHLGCilw_Y9_11qcW8");
        StringEntity payload = new StringEntity(String.format("{\"context\":{\"client\":{\"clientName\":\"ANDROID\",\"clientVersion\":\"16.24\"}},\"racyCheckOk\":true,\"contentCheckOk\":true,\"videoId\":\"%s\",\"playbackContext\":{\"contentPlaybackContext\":{\"signatureTimestamp\":%s}}}", videoId, playerScriptTimestamp.scriptTimestamp), "UTF-8");
        post.setEntity(payload);
        try (CloseableHttpResponse response = httpInterface.execute(post);){
            JsonBrowser jsonBrowser = this.processResponse(response);
            return jsonBrowser;
        }
    }

    protected JsonBrowser loadTrackInfoFromMainPage(HttpInterface httpInterface, String videoId) throws IOException {
        String url = "https://www.youtube.com/watch?v=" + videoId + "&pbj=1" + "&hl=en";
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(url));){
            JsonBrowser jsonBrowser = this.processResponse(response);
            return jsonBrowser;
        }
    }

    protected JsonBrowser loadTrackInfoWithContentVerify(HttpInterface httpInterface, String videoId) throws IOException {
        HttpPost post = new HttpPost("https://www.youtube.com/youtubei/v1/verify_age?key=AIzaSyAO_FJ2SlqU8Q4STEHLGCilw_Y9_11qcW8");
        StringEntity payload = new StringEntity(String.format("{\"context\":{\"client\":{\"clientName\":\"ANDROID\",\"clientVersion\":\"16.24\"}},\"nextEndpoint\":{\"urlEndpoint\":{\"url\":\"%s\"}},\"setControvercy\":true}", "/watch?v=" + videoId), "UTF-8");
        post.setEntity(payload);
        try (CloseableHttpResponse response = httpInterface.execute(post);){
            HttpClientTools.assertSuccessWithContent(response, "content verify response");
            String json = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
            String fetchedContentVerifiedLink = JsonBrowser.parse(json).get("actions").index(0).get("navigateAction").get("endpoint").get("urlEndpoint").get("url").text();
            if (fetchedContentVerifiedLink != null) {
                JsonBrowser jsonBrowser = this.loadTrackInfoFromMainPage(httpInterface, fetchedContentVerifiedLink.substring(9));
                return jsonBrowser;
            }
            log.error("Did not receive requested content verified link on track {} response: {}", (Object)videoId, (Object)json);
        }
        throw new FriendlyException("Track requires content verification.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Expected response is not present."));
    }

    protected JsonBrowser processResponse(CloseableHttpResponse response) throws IOException {
        HttpClientTools.assertSuccessWithContent(response, "video page response");
        String responseText = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
        try {
            return JsonBrowser.parse(responseText);
        }
        catch (FriendlyException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FriendlyException("Received unexpected response from YouTube.", FriendlyException.Severity.SUSPICIOUS, new RuntimeException("Failed to parse: " + responseText, e));
        }
    }

    protected YoutubeTrackJsonData augmentWithPlayerScript(YoutubeTrackJsonData data, HttpInterface httpInterface, boolean requireFormats) throws IOException {
        long now = System.currentTimeMillis();
        if (data.playerScriptUrl != null) {
            this.cachedPlayerScript = new CachedPlayerScript(data.playerScriptUrl, now);
            return data;
        }
        if (!requireFormats) {
            return data;
        }
        CachedPlayerScript cached = this.cachedPlayerScript;
        if (cached != null && cached.timestamp + 600000L >= now) {
            return data.withPlayerScriptUrl(cached.playerScriptUrl);
        }
        return data.withPlayerScriptUrl(this.fetchScript(httpInterface));
    }

    private String fetchScript(HttpInterface httpInterface) throws IOException {
        long now = System.currentTimeMillis();
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet("https://www.youtube.com/embed"));){
            HttpClientTools.assertSuccessWithContent(response, "youtube embed video id");
            String responseText = EntityUtils.toString(response.getEntity());
            String encodedUrl = DataFormatTools.extractBetween(responseText, "\"jsUrl\":\"", "\"");
            if (encodedUrl == null) {
                throw ExceptionTools.throwWithDebugInfo(log, null, "no jsUrl found", "html", responseText);
            }
            String fetchedPlayerScript = JsonBrowser.parse("{\"url\":\"" + encodedUrl + "\"}").get("url").text();
            this.cachedPlayerScript = new CachedPlayerScript(fetchedPlayerScript, now);
            String string = fetchedPlayerScript;
            return string;
        }
    }

    protected static class CachedPlayerScript {
        public final String playerScriptUrl;
        public final long timestamp;

        public CachedPlayerScript(String playerScriptUrl, long timestamp) {
            this.playerScriptUrl = playerScriptUrl;
            this.timestamp = timestamp;
        }
    }

    protected static enum InfoStatus {
        INFO_PRESENT,
        REQUIRES_LOGIN,
        DOES_NOT_EXIST,
        CONTENT_CHECK_REQUIRED;

    }
}

