/*
 * Decompiled with CFR 0.152.
 */
package io.github.yusufsdiscordbot.config;

import io.github.cdimascio.dotenv.Dotenv;
import io.github.yusufsdiscordbot.annotations.Author;
import org.jetbrains.annotations.NotNull;

@Author(firstName="Yusuf", lastName="Arfan Ismail", githubUserName="RealYusufIsmail")
public class Config {
    private static final Dotenv dotenv = Dotenv.configure().load();

    private Config() {
    }

    private static String get(@NotNull String key) {
        return dotenv.get(key);
    }

    private static String get(@NotNull String key, String defaultValue) {
        return dotenv.get(key, defaultValue);
    }

    public static String getString(@NotNull String key) {
        return dotenv.get(key.toUpperCase());
    }

    public static String getString(@NotNull String key, String defaultValue) {
        return dotenv.get(key.toUpperCase(), defaultValue);
    }

    public static int getInt(@NotNull String key) {
        return Integer.parseInt(Config.get(key));
    }

    public static int getInt(@NotNull String key, int defaultValue) {
        return Integer.parseInt(Config.get(key, Integer.toString(defaultValue)));
    }

    public static boolean getBoolean(@NotNull String key) {
        return Boolean.parseBoolean(Config.get(key));
    }

    public static boolean getBoolean(@NotNull String key, boolean defaultValue) {
        return Boolean.parseBoolean(Config.get(key, Boolean.toString(defaultValue)));
    }

    public static double getDouble(@NotNull String key) {
        return Double.parseDouble(Config.get(key));
    }

    public static double getDouble(@NotNull String key, double defaultValue) {
        return Double.parseDouble(Config.get(key, Double.toString(defaultValue)));
    }

    public static long getLong(@NotNull String key) {
        return Long.parseLong(Config.get(key));
    }

    public static long getLong(@NotNull String key, long defaultValue) {
        return Long.parseLong(Config.get(key, Long.toString(defaultValue)));
    }

    public static float getFloat(@NotNull String key) {
        return Float.parseFloat(Config.get(key));
    }

    public static float getFloat(@NotNull String key, float defaultValue) {
        return Float.parseFloat(Config.get(key, Float.toString(defaultValue)));
    }

    public static short getShort(@NotNull String key) {
        return Short.parseShort(Config.get(key));
    }

    public static short getShort(@NotNull String key, short defaultValue) {
        return Short.parseShort(Config.get(key, Short.toString(defaultValue)));
    }

    public static byte getByte(@NotNull String key) {
        return Byte.parseByte(Config.get(key));
    }

    public static byte getByte(@NotNull String key, byte defaultValue) {
        return Byte.parseByte(Config.get(key, Byte.toString(defaultValue)));
    }

    public static char getChar(@NotNull String key) {
        return Config.get(key).charAt(0);
    }

    public static char getChar(@NotNull String key, char defaultValue) {
        return Config.get(key, Character.toString(defaultValue)).charAt(0);
    }

    public static String @NotNull [] getStringArray(@NotNull String key) {
        return Config.get(key).split(",");
    }

    public static String @NotNull [] getStringArray(@NotNull String key, @NotNull String[] defaultValue) {
        return Config.get(key, String.join((CharSequence)",", defaultValue)).split(",");
    }

    public static int @NotNull [] getIntArray(@NotNull String key) {
        String[] stringArray = Config.getStringArray(key);
        int[] intArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            intArray[i] = Integer.parseInt(stringArray[i]);
        }
        return intArray;
    }

    public static boolean @NotNull [] getBooleanArray(@NotNull String key) {
        String[] stringArray = Config.getStringArray(key);
        boolean[] booleanArray = new boolean[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            booleanArray[i] = Boolean.parseBoolean(stringArray[i]);
        }
        return booleanArray;
    }

    public static double @NotNull [] getDoubleArray(@NotNull String key) {
        String[] stringArray = Config.getStringArray(key);
        double[] doubleArray = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            doubleArray[i] = Double.parseDouble(stringArray[i]);
        }
        return doubleArray;
    }

    public static long @NotNull [] getLongArray(@NotNull String key) {
        String[] stringArray = Config.getStringArray(key);
        long[] longArray = new long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            longArray[i] = Long.parseLong(stringArray[i]);
        }
        return longArray;
    }

    public static float @NotNull [] getFloatArray(@NotNull String key) {
        String[] stringArray = Config.getStringArray(key);
        float[] floatArray = new float[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            floatArray[i] = Float.parseFloat(stringArray[i]);
        }
        return floatArray;
    }

    public static short @NotNull [] getShortArray(@NotNull String key) {
        String[] stringArray = Config.getStringArray(key);
        short[] shortArray = new short[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            shortArray[i] = Short.parseShort(stringArray[i]);
        }
        return shortArray;
    }

    public static byte @NotNull [] getByteArray(@NotNull String key) {
        String[] stringArray = Config.getStringArray(key);
        byte[] byteArray = new byte[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            byteArray[i] = Byte.parseByte(stringArray[i]);
        }
        return byteArray;
    }

    public static char @NotNull [] getCharArray(@NotNull String key) {
        String[] stringArray = Config.getStringArray(key);
        char[] charArray = new char[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            charArray[i] = stringArray[i].charAt(0);
        }
        return charArray;
    }
}

