/*
 * Decompiled with CFR 0.152.
 */
package io.github.yusufsdiscordbot.yusufsdiscordcore.bot.core;

import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.core.YMember;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.core.YUser;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.core.utility.PermissionChecker;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.interaction.events.YSlashCommandInteractionEvent;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Region;
import net.dv8tion.jda.api.entities.AudioChannel;
import net.dv8tion.jda.api.entities.BaseGuildMessageChannel;
import net.dv8tion.jda.api.entities.Category;
import net.dv8tion.jda.api.entities.Channel;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Emote;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.GuildVoiceState;
import net.dv8tion.jda.api.entities.ICopyableChannel;
import net.dv8tion.jda.api.entities.Icon;
import net.dv8tion.jda.api.entities.Invite;
import net.dv8tion.jda.api.entities.ListedEmote;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.NewsChannel;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.StageChannel;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.ThreadChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.VanityInvite;
import net.dv8tion.jda.api.entities.VoiceChannel;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.entities.templates.Template;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.build.CommandData;
import net.dv8tion.jda.api.interactions.commands.privileges.CommandPrivilege;
import net.dv8tion.jda.api.managers.AudioManager;
import net.dv8tion.jda.api.managers.GuildManager;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.api.requests.restaction.ChannelAction;
import net.dv8tion.jda.api.requests.restaction.CommandCreateAction;
import net.dv8tion.jda.api.requests.restaction.CommandEditAction;
import net.dv8tion.jda.api.requests.restaction.CommandListUpdateAction;
import net.dv8tion.jda.api.requests.restaction.MemberAction;
import net.dv8tion.jda.api.requests.restaction.RoleAction;
import net.dv8tion.jda.api.requests.restaction.order.CategoryOrderAction;
import net.dv8tion.jda.api.requests.restaction.order.ChannelOrderAction;
import net.dv8tion.jda.api.requests.restaction.order.RoleOrderAction;
import net.dv8tion.jda.api.requests.restaction.pagination.AuditLogPaginationAction;
import net.dv8tion.jda.api.utils.MiscUtil;
import net.dv8tion.jda.api.utils.cache.MemberCacheView;
import net.dv8tion.jda.api.utils.cache.SnowflakeCacheView;
import net.dv8tion.jda.api.utils.cache.SortedSnowflakeCacheView;
import net.dv8tion.jda.api.utils.concurrent.Task;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record YGuild(Guild guild) {
    private static final Integer REASON_MAX_LENGTH = 512;

    @Nonnull
    @Contract(value=" -> new", pure=true)
    public PermissionChecker getPermissionChecker() {
        return new PermissionChecker(this.guild);
    }

    @Nonnull
    public String getGuildId() {
        return this.guild.getId();
    }

    @Nonnull
    public Long getGuildIdLong() {
        return this.guild.getIdLong();
    }

    @Nonnull
    public String getGuildName() {
        return this.guild.getName();
    }

    @CheckReturnValue
    @Nonnull
    public RestAction<List<Command>> retrieveCommands() {
        return this.guild.retrieveCommands();
    }

    @CheckReturnValue
    @Nonnull
    public RestAction<Command> retrieveCommandById(@Nonnull String commandId) {
        return this.guild.retrieveCommandById(commandId);
    }

    @CheckReturnValue
    @Nonnull
    public RestAction<Command> retrieveCommandById(long commandId) {
        return this.guild.retrieveCommandById(commandId);
    }

    @CheckReturnValue
    @Nonnull
    public RestAction<Command> upsertCommand(@Nonnull CommandData command) {
        return this.guild.upsertCommand(command);
    }

    @CheckReturnValue
    @Nonnull
    public CommandCreateAction upsertCommand(@Nonnull String name, @Nonnull String description) {
        return this.guild.upsertCommand(name, description);
    }

    @CheckReturnValue
    @Nonnull
    public CommandListUpdateAction updateCommands() {
        return this.guild.updateCommands();
    }

    @CheckReturnValue
    @Nonnull
    public CommandEditAction editCommandById(@Nonnull String commandId) {
        return this.guild.editCommandById(commandId);
    }

    @CheckReturnValue
    @Nonnull
    public CommandEditAction editCommandById(long commandId) {
        return this.guild.editCommandById(commandId);
    }

    @CheckReturnValue
    @Nonnull
    public RestAction<Void> deleteCommandById(@Nonnull String commandId) {
        return this.guild.deleteCommandById(commandId);
    }

    @CheckReturnValue
    @Nonnull
    public RestAction<Void> deleteCommandById(long commandId) {
        return this.guild.deleteCommandById(commandId);
    }

    @CheckReturnValue
    @Nonnull
    public RestAction<List<CommandPrivilege>> retrieveCommandPrivilegesById(@Nonnull String commandId) {
        return this.guild.retrieveCommandPrivilegesById(commandId);
    }

    @CheckReturnValue
    @Nonnull
    public RestAction<List<CommandPrivilege>> retrieveCommandPrivilegesById(long commandId) {
        return this.guild.retrieveCommandPrivilegesById(commandId);
    }

    @CheckReturnValue
    @Nonnull
    public RestAction<Map<String, List<CommandPrivilege>>> retrieveCommandPrivileges() {
        return this.guild.retrieveCommandPrivileges();
    }

    @CheckReturnValue
    @Nonnull
    public RestAction<List<CommandPrivilege>> updateCommandPrivilegesById(@Nonnull String id, @Nonnull Collection<? extends CommandPrivilege> privileges) {
        return this.guild.updateCommandPrivilegesById(id, privileges);
    }

    @CheckReturnValue
    @Nonnull
    public RestAction<List<CommandPrivilege>> updateCommandPrivilegesById(long id, @Nonnull Collection<? extends CommandPrivilege> privileges) {
        return this.guild.updateCommandPrivilegesById(id, privileges);
    }

    @CheckReturnValue
    @Nonnull
    public RestAction<List<CommandPrivilege>> updateCommandPrivilegesById(@Nonnull String id, CommandPrivilege ... privileges) {
        return this.guild.updateCommandPrivilegesById(id, privileges);
    }

    @CheckReturnValue
    @Nonnull
    public RestAction<List<CommandPrivilege>> updateCommandPrivilegesById(long id, CommandPrivilege ... privileges) {
        return this.guild.updateCommandPrivilegesById(id, privileges);
    }

    @CheckReturnValue
    @Nonnull
    public RestAction<Map<String, List<CommandPrivilege>>> updateCommandPrivileges(@Nonnull Map<String, ? extends Collection<CommandPrivilege>> privileges) {
        return this.guild.updateCommandPrivileges(privileges);
    }

    @NotNull
    public RestAction<EnumSet<Region>> retrieveRegions() {
        return this.guild.retrieveRegions();
    }

    @Nonnull
    public RestAction<EnumSet<Region>> retrieveRegions(boolean includeDeprecated) {
        return this.guild.retrieveRegions(includeDeprecated);
    }

    @CheckReturnValue
    @Nonnull
    public MemberAction addMember(@Nonnull String accessToken, @Nonnull String userId) {
        return this.guild.addMember(accessToken, userId);
    }

    @CheckReturnValue
    @Nonnull
    public MemberAction addMember(@Nonnull String accessToken, @Nonnull User user) {
        return this.guild.addMember(accessToken, user);
    }

    @CheckReturnValue
    @Nonnull
    public MemberAction addMember(@Nonnull String accessToken, @Nonnull YUser user) {
        return this.guild.addMember(accessToken, user.user());
    }

    @CheckReturnValue
    @Nonnull
    public MemberAction addMember(@Nonnull String accessToken, long userId) {
        return this.guild.addMember(accessToken, userId);
    }

    public boolean isLoaded() {
        return false;
    }

    public void pruneMemberCache() {
        this.guild.pruneMemberCache();
    }

    public boolean unloadMember(long userId) {
        return this.guild.unloadMember(userId);
    }

    public int getMemberCount() {
        return this.guild.getMemberCount();
    }

    @Nonnull
    public String getName() {
        return this.guild.getName();
    }

    @javax.annotation.Nullable
    public String getIconId() {
        return this.guild.getIconId();
    }

    @javax.annotation.Nullable
    public String getIconUrl() {
        return this.guild.getIconUrl();
    }

    @Nonnull
    public Set<String> getFeatures() {
        return this.guild.getFeatures();
    }

    @Nonnull
    @Contract(value=" -> new")
    public YMember getBot() {
        return new YMember(this.guild.getSelfMember());
    }

    @Nonnull
    @Contract(value="_ -> new")
    public YMember getMember(@Nonnull YUser user) {
        return new YMember(this.guild.getMember(user.user()));
    }

    @javax.annotation.Nullable
    String getSplashId() {
        return this.guild.getSplashId();
    }

    @javax.annotation.Nullable
    public String getSplashUrl() {
        return this.guild.getSplashUrl();
    }

    @javax.annotation.Nullable
    public String getVanityCode() {
        return this.guild.getVanityCode();
    }

    @Nonnull
    public Guild.Timeout getAfkTimeout() {
        return this.guild.getAfkTimeout();
    }

    public boolean isMember(@Nonnull User user) {
        return this.guild.isMember(user);
    }

    @Nonnull
    public Member getSelfMember() {
        return this.guild.getSelfMember();
    }

    @Nonnull
    public Guild.NSFWLevel getNSFWLevel() {
        return this.guild.getNSFWLevel();
    }

    @Nonnull
    public YMember getMember(@Nonnull User user) {
        return new YMember(this.guild.getMember(user));
    }

    @Nonnull
    public MemberCacheView getMemberCache() {
        return this.guild.getMemberCache();
    }

    @Contract(value="_ -> new")
    @NotNull
    public YMember getMemberById(long id) {
        return new YMember(this.guild.getMemberById(id));
    }

    @Contract(value="_ -> new")
    @NotNull
    public YMember getMemberById(@NotNull String id) {
        return new YMember(this.guild.getMemberById(id));
    }

    @Contract(value="_ -> new")
    @NotNull
    public YMember getMemberByTag(@NotNull String tag) {
        return new YMember(this.guild.getMemberByTag(tag));
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public YMember getMemberByTag(@NotNull String tag, @NotNull String discriminator) {
        return new YMember(this.guild.getMemberByTag(tag, discriminator));
    }

    public List<YMember> getMembersByEffectiveName(@NotNull String name, boolean ignoreCase) {
        return this.guild.getMembersByEffectiveName(name, ignoreCase).stream().map(YMember::new).toList();
    }

    public List<YMember> getMembersByName(@NotNull String name, boolean ignoreCase) {
        return this.guild.getMembersByName(name, ignoreCase).stream().map(YMember::new).toList();
    }

    public List<YMember> getMembersByNickname(String nickname, boolean ignoreCase) {
        return this.guild.getMembersByNickname(nickname, ignoreCase).stream().map(YMember::new).toList();
    }

    public List<YMember> getMembersWithRoles(Role ... roles) {
        return this.guild.getMembersWithRoles(roles).stream().map(YMember::new).toList();
    }

    @NotNull
    public List<Member> getMembersWithRoles(@NotNull Collection<Role> roles) {
        return this.guild.getMembersWithRoles(roles);
    }

    public List<YMember> getMembers() {
        return this.guild.getMembers().stream().map(YMember::new).toList();
    }

    @javax.annotation.Nullable
    public String getVanityUrl() {
        return this.guild.getVanityUrl();
    }

    @CheckReturnValue
    @Nonnull
    public RestAction<VanityInvite> retrieveVanityInvite() {
        return this.guild.retrieveVanityInvite();
    }

    @javax.annotation.Nullable
    public String getDescription() {
        return this.guild.getDescription();
    }

    @Nonnull
    public Locale getLocale() {
        return this.guild.getLocale();
    }

    @javax.annotation.Nullable
    public String getBannerId() {
        return this.guild.getBannerId();
    }

    @Nullable
    public String getBannerUrl() {
        return this.guild.getBannerUrl();
    }

    @Nonnull
    public Guild.BoostTier getBoostTier() {
        return this.guild.getBoostTier();
    }

    public int getBoostCount() {
        return this.guild.getBoostCount();
    }

    @Nonnull
    public AuditableRestAction<Void> changeUserNickname(@Nonnull Member member, String nickname) {
        return this.guild.modifyNickname(member, nickname);
    }

    @Nonnull
    public AuditableRestAction<Void> changeUserNickname(@Nonnull YMember member, String nickname) {
        return this.guild.modifyNickname(member.member(), nickname);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> unBan(@Nonnull User user, String reason) {
        return this.guild.unban(user).reason(reason);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> unBan(@Nonnull User user) {
        return this.guild.unban(user);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> unBan(@Nonnull String userId) {
        return this.guild.unban(userId);
    }

    @Nonnull
    public AuditableRestAction<Void> unBan(@Nonnull Long userId) {
        return this.guild.unban(User.fromId(userId));
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> unBan(@Nonnull YUser user, String reason) {
        return this.guild.unban(user.user()).reason(reason);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> unBan(@Nonnull YUser user) {
        return this.guild.unban(user.user());
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> ban(@Nonnull YMember member) {
        return this.guild.ban(member.member(), 0);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> ban(@Nonnull YMember member, String reason) {
        return this.guild.ban(member.member(), 0, reason);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> ban(@Nonnull YMember member, int days, String reason) {
        return this.guild.ban(member.member(), days, reason);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> ban(@Nonnull Member member) {
        return this.guild.ban(member, 0);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> ban(@Nonnull Member member, String reason) {
        return this.guild.ban(member, 0, reason);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> ban(@Nonnull Member member, int days, String reason) {
        return this.guild.ban(member, days, reason);
    }

    @NotNull
    public AuditableRestAction<Void> ban(@NotNull Member member, int delDays) {
        return this.guild.ban(member, delDays);
    }

    @NotNull
    public AuditableRestAction<Void> ban(@NotNull User user, int delDays) {
        return this.guild.ban(user, delDays);
    }

    @NotNull
    public AuditableRestAction<Void> ban(@NotNull String userId, int delDays) {
        return this.guild.ban(userId, delDays);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> ban(@Nonnull User user) {
        return this.guild.ban(user, 0);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> ban(@Nonnull User user, String reason) {
        return this.guild.ban(user, 0, reason);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> ban(@Nonnull User user, int days, String reason) {
        return this.guild.ban(user, days, reason);
    }

    @Nonnull
    public AuditableRestAction<Void> ban(@Nonnull String userId, int delDays, @javax.annotation.Nullable String reason) {
        return this.guild.ban(userId, delDays, reason);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> ban(@Nonnull YUser user) {
        return this.guild.ban(user.user(), 0);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> ban(@Nonnull YUser user, String reason) {
        return this.guild.ban(user.user(), 0, reason);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> ban(@Nonnull YUser user, int days, String reason) {
        return this.guild.ban(user.user(), days, reason);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> kick(@Nonnull YMember member) {
        return this.guild.kick(member.member(), null);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> kick(@Nonnull YMember member, String reason) {
        return this.guild.kick(member.member(), reason);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> kick(@Nonnull Member user) {
        return this.guild.kick(user, null);
    }

    @NotNull
    public AuditableRestAction<Void> kick(@NotNull String userId) {
        return this.guild.kick(userId);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> kick(@Nonnull Member member, String reason) {
        return this.guild.kick(member, reason);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> kick(@Nonnull String userId, String reason) {
        return this.guild.kick(userId, reason);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> mute(@Nonnull Member member, Boolean mute, String reason) {
        return this.guild.mute(member, mute).reason(reason);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> mute(@Nonnull YMember member, Boolean mute, String reason) {
        return this.guild.mute(member.member(), mute).reason(reason);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> addRoleToMember(@Nonnull Member member, @Nonnull Role role) {
        return this.guild.addRoleToMember(member, role);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> addRoleToMember(@Nonnull YMember member, @Nonnull Role role) {
        return this.guild.addRoleToMember(member.member(), role);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> addRoleToMember(long userId, @Nonnull Role role) {
        return this.guild.addRoleToMember(userId, role);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> addRoleToMember(@Nonnull String userId, @Nonnull Role role) {
        return this.guild.addRoleToMember(userId, role);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> removeRoleFromMember(@Nonnull Member member, @Nonnull Role role) {
        return this.guild.removeRoleFromMember(member, role);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> removeRoleFromMember(@Nonnull YMember member, @Nonnull Role role) {
        return this.guild.removeRoleFromMember(member.member(), role);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> removeRoleFromMember(@Nonnull String userId, @Nonnull Role role) {
        return this.guild.removeRoleFromMember(userId, role);
    }

    @Nonnull
    public AuditableRestAction<Void> modifyMemberRoles(@Nonnull Member member, @javax.annotation.Nullable Collection<Role> rolesToAdd, @javax.annotation.Nullable Collection<Role> rolesToRemove) {
        return this.guild.modifyMemberRoles(member, rolesToAdd, rolesToRemove);
    }

    @NotNull
    public AuditableRestAction<Void> modifyMemberRoles(@NotNull Member member, Role ... roles) {
        return this.guild.modifyMemberRoles(member, roles);
    }

    @Nonnull
    public AuditableRestAction<Void> modifyMemberRoles(@Nonnull Member member, @Nonnull Collection<Role> roles) {
        return this.guild.modifyMemberRoles(member, roles);
    }

    @Nonnull
    public AuditableRestAction<Void> transferOwnership(@Nonnull Member newOwner) {
        return this.guild.transferOwnership(newOwner);
    }

    @Nonnull
    public AuditableRestAction<Void> transferOwnership(@Nonnull YMember newOwner) {
        return this.guild.transferOwnership(newOwner.member());
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> removeRoleFromMember(long userId, @Nonnull Role role) {
        return this.guild.removeRoleFromMember(userId, role);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Integer> prune(@Nonnull Integer days, Role ... roles) {
        return this.guild.prune((int)days, roles);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Integer> prune(int days, boolean wait, Role ... roles) {
        return this.guild.prune(days, wait, roles);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> timeoutFor(@Nonnull YMember member, long amount, @Nonnull TimeUnit unit) {
        return this.guild.timeoutFor(member.member(), amount, unit);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> timeoutFor(@Nonnull YMember member, @Nonnull Duration duration) {
        return this.guild.timeoutFor(member.member(), duration);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> timeoutFor(@Nonnull YMember member, @Nonnull TemporalAccessor temporal) {
        return this.guild.timeoutUntil(member.member(), temporal);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> timeoutFor(@Nonnull Member member, long amount, @Nonnull TimeUnit unit) {
        return this.guild.timeoutFor(member, amount, unit);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> timeoutFor(@Nonnull Member member, @Nonnull Duration duration) {
        return this.guild.timeoutFor(member, duration);
    }

    @NotNull
    public AuditableRestAction<Void> timeoutUntil(@NotNull Member member, @NotNull TemporalAccessor temporal) {
        return this.guild.timeoutUntil(member, temporal);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> timeoutFor(@Nonnull Member member, @Nonnull TemporalAccessor temporal) {
        return this.guild.timeoutUntil(member, temporal);
    }

    @CheckReturnValue
    @NotNull
    public AuditableRestAction<Void> timeoutForById(long userId, long amount, @Nonnull TimeUnit unit) {
        return this.guild.timeoutForById(userId, amount, unit);
    }

    @CheckReturnValue
    @NotNull
    public AuditableRestAction<Void> timeoutForById(@Nonnull String userId, long amount, @Nonnull TimeUnit unit) {
        return this.guild.timeoutForById(userId, amount, unit);
    }

    @CheckReturnValue
    @NotNull
    public AuditableRestAction<Void> timeoutForById(long userId, @Nonnull Duration duration) {
        return this.guild.timeoutForById(userId, duration);
    }

    @CheckReturnValue
    @NotNull
    public AuditableRestAction<Void> timeoutForById(@Nonnull String userId, @Nonnull Duration duration) {
        return this.guild.timeoutForById(userId, duration);
    }

    @CheckReturnValue
    @NotNull
    public AuditableRestAction<Void> timeoutUntilById(long userId, @Nonnull TemporalAccessor temporal) {
        return this.guild.timeoutUntilById(userId, temporal);
    }

    @CheckReturnValue
    @NotNull
    public AuditableRestAction<Void> timeoutUntilById(@Nonnull String userId, @Nonnull TemporalAccessor temporal) {
        return this.guild.timeoutUntilById(userId, temporal);
    }

    @NotNull
    public AuditableRestAction<Void> removeTimeout(@NotNull Member member) {
        return this.guild.removeTimeout(member);
    }

    @NotNull
    public AuditableRestAction<Void> removeTimeout(@Nonnull YMember member) {
        return this.guild.removeTimeout(member.member());
    }

    @NotNull
    public AuditableRestAction<Void> removeTimeoutById(long userId) {
        return this.guild.removeTimeoutById(userId);
    }

    @NotNull
    public AuditableRestAction<Void> removeTimeoutById(@Nonnull String userId) {
        return this.guild.removeTimeoutById(userId);
    }

    @Nullable
    public <T extends Channel> T getChannelById(@NotNull Class<T> type, @NotNull String id) {
        return this.guild.getChannelById(type, id);
    }

    @Nullable
    public <T extends Channel> T getChannelById(@NotNull Class<T> type, long id) {
        return this.guild.getChannelById(type, id);
    }

    @javax.annotation.Nullable
    public GuildChannel getGuildChannelById(@Nonnull String id) {
        return this.guild.getGuildChannelById(id);
    }

    @javax.annotation.Nullable
    public GuildChannel getGuildChannelById(long id) {
        return this.guild.getGuildChannelById(id);
    }

    @javax.annotation.Nullable
    public GuildChannel getGuildChannelById(@Nonnull ChannelType type, @Nonnull String id) {
        return this.getGuildChannelById(type, MiscUtil.parseSnowflake(id));
    }

    @javax.annotation.Nullable
    public GuildChannel getGuildChannelById(@Nonnull ChannelType type, long id) {
        return this.guild.getGuildChannelById(type, id);
    }

    @Nonnull
    public SortedSnowflakeCacheView<StageChannel> getStageChannelCache() {
        return this.guild.getStageChannelCache();
    }

    @NotNull
    public List<StageChannel> getStageChannelsByName(@NotNull String name, boolean ignoreCase) {
        return this.guild.getStageChannelsByName(name, ignoreCase);
    }

    @Nullable
    public StageChannel getStageChannelById(@NotNull String id) {
        return this.guild.getStageChannelById(id);
    }

    @Nullable
    public StageChannel getStageChannelById(long id) {
        return this.guild.getStageChannelById(id);
    }

    @NotNull
    public List<StageChannel> getStageChannels() {
        return this.guild.getStageChannels();
    }

    @Nonnull
    public SortedSnowflakeCacheView<ThreadChannel> getThreadChannelCache() {
        return this.guild.getThreadChannelCache();
    }

    @NotNull
    public List<ThreadChannel> getThreadChannelsByName(@NotNull String name, boolean ignoreCase) {
        return this.guild.getThreadChannelsByName(name, ignoreCase);
    }

    @Nullable
    public ThreadChannel getThreadChannelById(@NotNull String id) {
        return this.guild.getThreadChannelById(id);
    }

    @Nullable
    public ThreadChannel getThreadChannelById(long id) {
        return this.guild.getThreadChannelById(id);
    }

    @NotNull
    public List<ThreadChannel> getThreadChannels() {
        return this.guild.getThreadChannels();
    }

    @Nullable
    public Category getCategoryById(@NotNull String id) {
        return this.guild.getCategoryById(id);
    }

    @Nullable
    public Category getCategoryById(long id) {
        return this.guild.getCategoryById(id);
    }

    @NotNull
    public List<Category> getCategories() {
        return this.guild.getCategories();
    }

    @NotNull
    public List<Category> getCategoriesByName(@NotNull String name, boolean ignoreCase) {
        return this.guild.getCategoriesByName(name, ignoreCase);
    }

    @Nonnull
    public SortedSnowflakeCacheView<Category> getCategoryCache() {
        return this.guild.getCategoryCache();
    }

    @Nonnull
    public SortedSnowflakeCacheView<TextChannel> getTextChannelCache() {
        return this.guild.getTextChannelCache();
    }

    @Nullable
    public NewsChannel getNewsChannelById(@NotNull String id) {
        return this.guild.getNewsChannelById(id);
    }

    @Nullable
    public NewsChannel getNewsChannelById(long id) {
        return this.guild.getNewsChannelById(id);
    }

    @NotNull
    public List<NewsChannel> getNewsChannels() {
        return this.guild.getNewsChannels();
    }

    @NotNull
    public List<NewsChannel> getNewsChannelsByName(@NotNull String name, boolean ignoreCase) {
        return this.guild.getNewsChannelsByName(name, ignoreCase);
    }

    @Nonnull
    public SortedSnowflakeCacheView<NewsChannel> getNewsChannelCache() {
        return this.guild.getNewsChannelCache();
    }

    @Nullable
    public VoiceChannel getVoiceChannelById(@NotNull String id) {
        return this.guild.getVoiceChannelById(id);
    }

    @Nullable
    public VoiceChannel getVoiceChannelById(long id) {
        return this.guild.getVoiceChannelById(id);
    }

    @NotNull
    public List<VoiceChannel> getVoiceChannels() {
        return this.guild.getVoiceChannels();
    }

    @NotNull
    public List<VoiceChannel> getVoiceChannelsByName(@NotNull String name, boolean ignoreCase) {
        return this.guild.getVoiceChannelsByName(name, ignoreCase);
    }

    @Nonnull
    public SortedSnowflakeCacheView<VoiceChannel> getVoiceChannelCache() {
        return this.guild.getVoiceChannelCache();
    }

    @NotNull
    public List<GuildChannel> getChannels() {
        return this.guild.getChannels();
    }

    @Nonnull
    public List<GuildChannel> getChannels(boolean includeHidden) {
        return this.guild.getChannels(includeHidden);
    }

    @Nullable
    public Role getRoleById(@NotNull String id) {
        return this.guild.getRoleById(id);
    }

    @Nullable
    public Role getRoleById(long id) {
        return this.guild.getRoleById(id);
    }

    @NotNull
    public List<Role> getRoles() {
        return this.guild.getRoles();
    }

    @NotNull
    public List<Role> getRolesByName(@NotNull String name, boolean ignoreCase) {
        return this.guild.getRolesByName(name, ignoreCase);
    }

    @Nullable
    public Role getRoleByBot(long userId) {
        return this.guild.getRoleByBot(userId);
    }

    @Nullable
    public Role getRoleByBot(@NotNull String userId) {
        return this.guild.getRoleByBot(userId);
    }

    @Nullable
    public Role getRoleByBot(@NotNull User user) {
        return this.guild.getRoleByBot(user);
    }

    @Nullable
    public Role getBotRole() {
        return this.guild.getBotRole();
    }

    @Nullable
    public Role getBoostRole() {
        return this.guild.getBoostRole();
    }

    @Nonnull
    public SortedSnowflakeCacheView<Role> getRoleCache() {
        return this.guild.getRoleCache();
    }

    @Nullable
    public Emote getEmoteById(@NotNull String id) {
        return this.guild.getEmoteById(id);
    }

    @Nullable
    public Emote getEmoteById(long id) {
        return this.guild.getEmoteById(id);
    }

    @NotNull
    public List<Emote> getEmotes() {
        return this.guild.getEmotes();
    }

    @NotNull
    public List<Emote> getEmotesByName(@NotNull String name, boolean ignoreCase) {
        return this.guild.getEmotesByName(name, ignoreCase);
    }

    @Nonnull
    public SnowflakeCacheView<Emote> getEmoteCache() {
        return this.guild.getEmoteCache();
    }

    @Nonnull
    public RestAction<List<ListedEmote>> retrieveEmotes() {
        return this.guild.retrieveEmotes();
    }

    @Nonnull
    public RestAction<ListedEmote> retrieveEmoteById(@Nonnull String id) {
        return this.guild.retrieveEmoteById(id);
    }

    @NotNull
    public RestAction<ListedEmote> retrieveEmoteById(long id) {
        return this.guild.retrieveEmoteById(id);
    }

    @NotNull
    public RestAction<ListedEmote> retrieveEmote(@NotNull Emote emote) {
        return this.guild.retrieveEmote(emote);
    }

    @Nonnull
    public RestAction<List<Guild.Ban>> retrieveBanList() {
        return this.guild.retrieveBanList();
    }

    @NotNull
    public RestAction<Guild.Ban> retrieveBanById(long userId) {
        return this.guild.retrieveBanById(userId);
    }

    @Nonnull
    public RestAction<Guild.Ban> retrieveBanById(@Nonnull String userId) {
        return this.guild.retrieveBanById(userId);
    }

    @NotNull
    public RestAction<Guild.Ban> retrieveBan(@NotNull User bannedUser) {
        return this.guild.retrieveBan(bannedUser);
    }

    @NotNull
    public RestAction<Guild.Ban> retrieveBan(@NotNull YUser bannedUser) {
        return this.guild.retrieveBan(bannedUser.user());
    }

    @Nonnull
    public RestAction<Integer> retrievePrunableMemberCount(int days) {
        return this.guild.retrievePrunableMemberCount(days);
    }

    @Nonnull
    public Role getPublicRole() {
        return this.guild.getPublicRole();
    }

    @javax.annotation.Nullable
    public BaseGuildMessageChannel getDefaultChannel() {
        return this.guild.getDefaultChannel();
    }

    @Nonnull
    public GuildManager getManager() {
        return this.guild.getManager();
    }

    public boolean isBoostProgressBarEnabled() {
        return this.guild.isBoostProgressBarEnabled();
    }

    @Nonnull
    public AuditLogPaginationAction retrieveAuditLogs() {
        return this.guild.retrieveAuditLogs();
    }

    @Nonnull
    public RestAction<Void> leave() {
        return this.guild.leave();
    }

    @Nonnull
    public RestAction<Void> delete() {
        return this.guild.delete();
    }

    @Nonnull
    public RestAction<Void> delete(@javax.annotation.Nullable String mfaCode) {
        return this.guild.delete(mfaCode);
    }

    @Nonnull
    public AudioManager getAudioManager() {
        return this.guild.getAudioManager();
    }

    @Nonnull
    public Task<Void> requestToSpeak() {
        return this.guild.requestToSpeak();
    }

    @Nonnull
    public Task<Void> cancelRequestToSpeak() {
        return this.guild.cancelRequestToSpeak();
    }

    @Nonnull
    public JDA getJDA() {
        return this.guild.getJDA();
    }

    @Nonnull
    public RestAction<List<Invite>> retrieveInvites() {
        return this.guild.retrieveInvites();
    }

    @Nonnull
    public RestAction<List<Template>> retrieveTemplates() {
        return this.guild.retrieveTemplates();
    }

    @Nonnull
    public RestAction<Template> createTemplate(@Nonnull String name, @javax.annotation.Nullable String description) {
        return this.guild.createTemplate(name, description);
    }

    @Nonnull
    public RestAction<List<Webhook>> retrieveWebhooks() {
        return this.guild.retrieveWebhooks();
    }

    @Nonnull
    public List<GuildVoiceState> getVoiceStates() {
        return this.guild.getVoiceStates();
    }

    @Nonnull
    public Guild.VerificationLevel getVerificationLevel() {
        return this.guild.getVerificationLevel();
    }

    @Nonnull
    public Guild.NotificationLevel getDefaultNotificationLevel() {
        return this.guild.getDefaultNotificationLevel();
    }

    @Nonnull
    public Guild.MFALevel getRequiredMFALevel() {
        return this.guild.getRequiredMFALevel();
    }

    @Nonnull
    public Guild.ExplicitContentLevel getExplicitContentLevel() {
        return this.guild.getExplicitContentLevel();
    }

    @NotNull
    public Task<List<Member>> loadMembers() {
        return this.guild.loadMembers();
    }

    @NotNull
    public Task<List<Member>> findMembers(@NotNull Predicate<? super Member> filter) {
        return this.guild.findMembers(filter);
    }

    @NotNull
    public Task<List<Member>> findMembersWithRoles(@NotNull Collection<Role> roles) {
        return this.guild.findMembersWithRoles(roles);
    }

    @NotNull
    public Task<List<Member>> findMembersWithRoles(Role ... roles) {
        return this.guild.findMembersWithRoles(roles);
    }

    @Nonnull
    public Task<Void> loadMembers(@Nonnull Consumer<Member> callback) {
        return this.guild.loadMembers(callback);
    }

    @NotNull
    public RestAction<Member> retrieveMember(@NotNull User user) {
        return this.guild.retrieveMember(user);
    }

    @NotNull
    public RestAction<Member> retrieveMember(@NotNull YUser user) {
        return this.guild.retrieveMember(user.user());
    }

    @NotNull
    public RestAction<Member> retrieveMemberById(@NotNull String id) {
        return this.guild.retrieveMemberById(id);
    }

    @NotNull
    public RestAction<Member> retrieveMemberById(long id) {
        return this.guild.retrieveMemberById(id);
    }

    @NotNull
    public RestAction<Member> retrieveOwner() {
        return this.guild.retrieveOwner();
    }

    @NotNull
    public RestAction<Member> retrieveMember(@NotNull User user, boolean update) {
        return this.guild.retrieveMember(user, update);
    }

    @NotNull
    public RestAction<Member> retrieveMemberById(@NotNull String id, boolean update) {
        return this.guild.retrieveMemberById(id, update);
    }

    @Nonnull
    public RestAction<Member> retrieveMemberById(long id, boolean update) {
        return this.guild.retrieveMemberById(id, update);
    }

    @NotNull
    public RestAction<Member> retrieveOwner(boolean update) {
        return this.guild.retrieveOwner(update);
    }

    @NotNull
    public Task<List<Member>> retrieveMembers(@NotNull Collection<User> users) {
        return this.guild.retrieveMembers(users);
    }

    @NotNull
    public Task<List<Member>> retrieveMembersByIds(@NotNull Collection<Long> ids) {
        return this.guild.retrieveMembersByIds(ids);
    }

    @NotNull
    public Task<List<Member>> retrieveMembersByIds(String ... ids) {
        return this.guild.retrieveMembersByIds(ids);
    }

    @NotNull
    public Task<List<Member>> retrieveMembersByIds(long ... ids) {
        return this.guild.retrieveMembersByIds(ids);
    }

    @NotNull
    public Task<List<Member>> retrieveMembers(boolean includePresence, @NotNull Collection<User> users) {
        return this.guild.retrieveMembers(includePresence, users);
    }

    @NotNull
    public Task<List<Member>> retrieveMembersByIds(boolean includePresence, @NotNull Collection<Long> ids) {
        return this.guild.retrieveMembersByIds(includePresence, ids);
    }

    @NotNull
    public Task<List<Member>> retrieveMembersByIds(boolean includePresence, String ... ids) {
        return this.guild.retrieveMembersByIds(includePresence, ids);
    }

    @Nonnull
    public Task<List<Member>> retrieveMembersByIds(boolean includePresence, long ... ids) {
        return this.guild.retrieveMembersByIds(includePresence, ids);
    }

    @Nonnull
    public Task<List<Member>> retrieveMembersByPrefix(@Nonnull String prefix, int limit) {
        return this.guild.retrieveMembersByPrefix(prefix, limit);
    }

    @Nonnull
    public RestAction<List<ThreadChannel>> retrieveActiveThreads() {
        return this.guild.retrieveActiveThreads();
    }

    @Nonnull
    public RestAction<Void> moveVoiceMember(@Nonnull Member member, @javax.annotation.Nullable AudioChannel audioChannel) {
        return this.guild.moveVoiceMember(member, audioChannel);
    }

    @NotNull
    public RestAction<Void> kickVoiceMember(@NotNull Member member) {
        return this.guild.kickVoiceMember(member);
    }

    @Nonnull
    public AuditableRestAction<Void> modifyNickname(@Nonnull Member member, @javax.annotation.Nullable String nickname) {
        return this.guild.modifyNickname(member, nickname);
    }

    @NotNull
    public AuditableRestAction<Integer> prune(int days, Role ... roles) {
        return this.guild.prune(days, roles);
    }

    @CheckReturnValue
    @Nonnull
    public RoleOrderAction modifyRolePositions(boolean useAscendingOrder) {
        return this.guild.modifyRolePositions(useAscendingOrder);
    }

    @CheckReturnValue
    @Nonnull
    AuditableRestAction<Void> mute(@Nonnull Member member, boolean mute) {
        return this.guild.mute(member, mute);
    }

    @CheckReturnValue
    @Nonnull
    AuditableRestAction<Void> mute(@Nonnull YMember member, boolean mute) {
        return this.guild.mute(member.member(), mute);
    }

    @CheckReturnValue
    @Nonnull
    AuditableRestAction<Void> deafen(@Nonnull Member member, boolean deafen) {
        return this.guild.deafen(member, deafen);
    }

    @CheckReturnValue
    @Nonnull
    AuditableRestAction<Void> deafen(@Nonnull YMember member, boolean deafen) {
        return this.guild.deafen(member.member(), deafen);
    }

    @Nonnull
    public List<Member> getBoosters() {
        return this.guild.getBoosters();
    }

    public int getMaxBitrate() {
        return this.guild.getMaxBitrate();
    }

    public long getMaxFileSize() {
        return this.guild.getMaxFileSize();
    }

    public int getMaxEmotes() {
        return this.guild.getMaxEmotes();
    }

    public int getMaxMembers() {
        return this.guild.getMaxMembers();
    }

    public int getMaxPresences() {
        return this.guild.getMaxPresences();
    }

    @Nonnull
    public RestAction<Guild.MetaData> retrieveMetaData() {
        return this.guild.retrieveMetaData();
    }

    @javax.annotation.Nullable
    public VoiceChannel getAfkChannel() {
        return this.guild.getAfkChannel();
    }

    @javax.annotation.Nullable
    public TextChannel getSystemChannel() {
        return this.guild.getSystemChannel();
    }

    @javax.annotation.Nullable
    public TextChannel getRulesChannel() {
        return this.guild.getRulesChannel();
    }

    @javax.annotation.Nullable
    public TextChannel getCommunityUpdatesChannel() {
        return this.guild.getCommunityUpdatesChannel();
    }

    public boolean isMember(@Nonnull YUser user) {
        return this.guild.isMember(user.user());
    }

    @Nonnull
    public ChannelAction<TextChannel> createTextChannel(@Nonnull String name) {
        return this.guild.createTextChannel(name);
    }

    @Nonnull
    public ChannelAction<TextChannel> createTextChannel(@Nonnull String name, @Nonnull Category parent) {
        return this.guild.createTextChannel(name, parent);
    }

    @NotNull
    public ChannelAction<NewsChannel> createNewsChannel(@NotNull String name) {
        return this.guild.createNewsChannel(name);
    }

    @Nonnull
    public ChannelAction<NewsChannel> createNewsChannel(@Nonnull String name, @javax.annotation.Nullable Category parent) {
        return this.guild.createNewsChannel(name, parent);
    }

    @NotNull
    public ChannelAction<VoiceChannel> createVoiceChannel(@NotNull String name) {
        return this.guild.createVoiceChannel(name);
    }

    @Nonnull
    public ChannelAction<VoiceChannel> createVoiceChannel(@Nonnull String name, @javax.annotation.Nullable Category parent) {
        return this.guild.createVoiceChannel(name, parent);
    }

    @NotNull
    public ChannelAction<StageChannel> createStageChannel(@NotNull String name) {
        return this.guild.createStageChannel(name);
    }

    @Nonnull
    public ChannelAction<StageChannel> createStageChannel(@Nonnull String name, @javax.annotation.Nullable Category parent) {
        return this.guild.createStageChannel(name, parent);
    }

    @Nonnull
    public ChannelAction<Category> createCategory(@Nonnull String name) {
        return this.guild.createCategory(name);
    }

    @NotNull
    public <T extends ICopyableChannel> ChannelAction<T> createCopyOfChannel(@NotNull T channel) {
        return this.guild.createCopyOfChannel(channel);
    }

    @Nonnull
    public RoleAction createRole() {
        return this.guild.createRole();
    }

    @NotNull
    public RoleAction createCopyOfRole(@NotNull Role role) {
        return this.guild.createCopyOfRole(role);
    }

    @Nonnull
    public AuditableRestAction<Emote> createEmote(@Nonnull String name, @Nonnull Icon icon, Role ... roles) {
        return this.guild.createEmote(name, icon, roles);
    }

    @Nonnull
    public ChannelOrderAction modifyCategoryPositions() {
        return this.guild.modifyCategoryPositions();
    }

    @Nonnull
    public ChannelOrderAction modifyTextChannelPositions() {
        return this.guild.modifyTextChannelPositions();
    }

    @Nonnull
    public ChannelOrderAction modifyVoiceChannelPositions() {
        return this.guild.modifyVoiceChannelPositions();
    }

    @Nonnull
    public CategoryOrderAction modifyTextChannelPositions(@Nonnull Category category) {
        return this.guild.modifyTextChannelPositions(category);
    }

    @Nonnull
    public CategoryOrderAction modifyVoiceChannelPositions(@Nonnull Category category) {
        return this.guild.modifyVoiceChannelPositions(category);
    }

    @NotNull
    public RoleOrderAction modifyRolePositions() {
        return this.guild.modifyRolePositions();
    }

    @javax.annotation.Nullable
    public TextChannel getTextChannelById(@NotNull String id) {
        return this.guild.getTextChannelById(id);
    }

    @javax.annotation.Nullable
    public TextChannel getTextChannelById(long id) {
        return this.guild.getTextChannelById(id);
    }

    @NotNull
    public List<TextChannel> getTextChannels() {
        return this.guild.getTextChannels();
    }

    @Nonnull
    public List<TextChannel> getTextChannelsByName(@Nonnull String name, boolean ignoreCase) {
        return this.guild.getTextChannelsByName(name, ignoreCase);
    }

    @Nonnull
    @Contract(value=" -> new")
    public YMember getOwner() {
        return new YMember(this.guild.getOwner());
    }

    @Nonnull
    public String getOwnerId() {
        return this.guild.getOwnerId();
    }

    public long getOwnerIdLong() {
        return this.guild.getOwnerIdLong();
    }

    public boolean checkReasonLength(@Nonnull String reason, @Nonnull YSlashCommandInteractionEvent event) {
        if (reason.length() > REASON_MAX_LENGTH) {
            event.replyQueuedEphemeral("You have gone over the reason character limit which is " + REASON_MAX_LENGTH + " .");
            return false;
        }
        return true;
    }

    @NotNull
    public OffsetDateTime getTimeCreated() {
        return this.guild.getTimeCreated();
    }
}

