/*
 * Decompiled with CFR 0.152.
 */
package io.github.yusufsdiscordbot.yusufsdiscordcore.bot.core;

import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.core.YGuild;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.core.YUser;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.core.util.Verify;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.interaction.YReplyCallback;
import java.awt.Color;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.dv8tion.jda.annotations.Incubating;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.BaseGuildMessageChannel;
import net.dv8tion.jda.api.entities.ClientType;
import net.dv8tion.jda.api.entities.Emote;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.GuildVoiceState;
import net.dv8tion.jda.api.entities.IPermissionContainer;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.interactions.callbacks.IReplyCallback;
import net.dv8tion.jda.api.managers.AudioManager;
import net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record YMember(Member member) {
    private static final int MAX_TIME_OUT_LENGTH = 28;

    @Nonnull
    @Contract(value=" -> new")
    public YUser getUser() {
        return new YUser(this.member.getUser());
    }

    public boolean canInteract(@Nonnull Role role) {
        return this.member.canInteract(role);
    }

    @Nonnull
    public YGuild getGuild() {
        return new YGuild(this.member.getGuild());
    }

    @NotNull
    public JDA getJDA() {
        return this.member.getJDA();
    }

    @Nonnull
    public OffsetDateTime getTimeJoined() {
        return this.member.getTimeJoined();
    }

    public boolean hasTimeJoined() {
        return this.member.hasTimeJoined();
    }

    @javax.annotation.Nullable
    public OffsetDateTime getTimeBoosted() {
        return this.member.getTimeBoosted();
    }

    public boolean isBoosting() {
        return false;
    }

    @javax.annotation.Nullable
    public GuildVoiceState getVoiceState() {
        return this.member.getVoiceState();
    }

    @Nonnull
    public List<Activity> getActivities() {
        return this.member.getActivities();
    }

    @Nonnull
    public OnlineStatus getOnlineStatus() {
        return this.member.getOnlineStatus();
    }

    @Nonnull
    public OnlineStatus getOnlineStatus(@Nonnull ClientType type) {
        return this.member.getOnlineStatus(type);
    }

    @Nonnull
    public Set<ClientType> getActiveClients() {
        return this.member.getActiveClients();
    }

    @javax.annotation.Nullable
    public String getNickname() {
        return this.member.getNickname();
    }

    @Nullable
    public String getAvatarId() {
        return this.member.getAvatarId();
    }

    @javax.annotation.Nullable
    public String getAvatarUrl() {
        return this.member.getAvatarUrl();
    }

    @Nonnull
    public String getEffectiveAvatarUrl() {
        return this.member.getEffectiveAvatarUrl();
    }

    @Nonnull
    public List<Role> getRoles() {
        return this.member.getRoles();
    }

    @javax.annotation.Nullable
    public Color getColor() {
        return this.member.getColor();
    }

    public int getColorRaw() {
        return this.member.getColorRaw();
    }

    public boolean canInteract(@Nonnull Member member) {
        return member.canInteract(member);
    }

    public boolean canInteract(@Nonnull YMember member) {
        return member.canInteract(member.member());
    }

    public boolean canInteract(@Nonnull Emote emote) {
        return this.member.canInteract(emote);
    }

    public boolean isOwner() {
        return this.member.isOwner();
    }

    @Incubating
    public boolean isPending() {
        return this.member.isPending();
    }

    @javax.annotation.Nullable
    public BaseGuildMessageChannel getDefaultChannel() {
        return this.member.getDefaultChannel();
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> ban(int delDays) {
        return this.member.ban(delDays);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> ban(int delDays, @javax.annotation.Nullable String reason) {
        return this.member.ban(delDays, reason);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> kick() {
        return this.member.kick();
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> kick(String reason) {
        return this.member.kick(reason);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> mute(boolean mute) {
        return this.member.mute(mute);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> deafen(boolean deafen) {
        return this.member.deafen(deafen);
    }

    @CheckReturnValue
    @Nonnull
    public AuditableRestAction<Void> modifyNickname(@javax.annotation.Nullable String nickname) {
        return this.member.modifyNickname(nickname);
    }

    @Nonnull
    public String getName() {
        return this.member.getEffectiveName();
    }

    public Member getAuthor() {
        return this.member;
    }

    @Nonnull
    public String getMemberId() {
        return this.member.getId();
    }

    @Nonnull
    public Long getMemberIdLong() {
        return this.member.getIdLong();
    }

    @Nonnull
    public Set<Permission> getPermissions() {
        return this.member.getPermissions();
    }

    @Nonnull
    public Set<Permission> getPermissions(@Nonnull GuildChannel channel) {
        return this.member.getPermissions(channel);
    }

    @Nonnull
    public Set<Permission> getPermissions(@Nonnull IPermissionContainer channel) {
        return this.member.getPermissions(channel);
    }

    @Nonnull
    public Set<Permission> getPermissionsExplicit() {
        return this.member.getPermissionsExplicit();
    }

    @Nonnull
    public Set<Permission> getPermissionsExplicit(@Nonnull GuildChannel channel) {
        return this.member.getPermissionsExplicit(channel);
    }

    @Nonnull
    public Set<Permission> getPermissionsExplicit(@Nonnull IPermissionContainer channel) {
        return this.member.getPermissionsExplicit(channel);
    }

    public boolean hasPermission(Permission ... permissions) {
        return this.member.hasPermission(permissions);
    }

    public boolean hasPermission(@Nonnull Collection<Permission> permissions) {
        return this.member.hasPermission(permissions);
    }

    public boolean hasPermission(@Nonnull GuildChannel channel, Permission ... permissions) {
        return this.member.hasPermission(channel, permissions);
    }

    public boolean hasPermission(@Nonnull GuildChannel channel, @Nonnull Collection<Permission> permissions) {
        return this.member.hasPermission(channel, permissions);
    }

    public boolean hasPermission(@Nonnull IPermissionContainer channel, Permission ... permissions) {
        return this.member.hasPermission((GuildChannel)channel, permissions);
    }

    public boolean hasPermission(@Nonnull IPermissionContainer channel, @Nonnull Collection<Permission> permissions) {
        return this.member.hasPermission((GuildChannel)channel, permissions);
    }

    public boolean hasAccess(@Nonnull GuildChannel channel) {
        return this.member.hasAccess(channel);
    }

    public boolean canSync(@Nonnull IPermissionContainer targetChannel, @Nonnull IPermissionContainer syncSource) {
        return this.member.canSync(targetChannel, syncSource);
    }

    public boolean canSync(@Nonnull IPermissionContainer channel) {
        return this.member.canSync(channel);
    }

    public boolean hasAccess(@Nonnull IPermissionContainer channel) {
        return this.member.hasAccess(channel);
    }

    public boolean hasPermission(@Nonnull Permission permission) {
        return this.member.hasPermission(permission);
    }

    @javax.annotation.Nullable
    public OffsetDateTime getTimeOutEnd() {
        return this.member.getTimeOutEnd();
    }

    public boolean isTimedOut() {
        return this.member.isTimedOut();
    }

    @Nonnull
    @CheckReturnValue
    public AuditableRestAction<Void> timeoutFor(long amount, @Nonnull TimeUnit unit) {
        return this.member.timeoutFor(amount, unit);
    }

    @Nonnull
    @CheckReturnValue
    public AuditableRestAction<Void> timeoutFor(@Nonnull Duration duration) {
        return this.member.timeoutFor(duration);
    }

    @Nonnull
    @CheckReturnValue
    public AuditableRestAction<Void> timeoutUntil(@javax.annotation.Nullable TemporalAccessor temporal) {
        return this.member.timeoutUntil(temporal);
    }

    @Nonnull
    @CheckReturnValue
    public AuditableRestAction<Void> removeTimeout() {
        return this.getGuild().removeTimeout(this.member());
    }

    @Nonnull
    public String getAsMention() {
        return this.member.getAsMention();
    }

    public long getIdLong() {
        return this.member.getIdLong();
    }

    public boolean isDeafened() {
        return Objects.requireNonNull(this.member.getVoiceState()).isDeafened();
    }

    @NotNull
    public OffsetDateTime getTimeCreated() {
        return this.member.getTimeCreated();
    }

    @NotNull
    public AudioManager getAudioManager() {
        return this.member.getGuild().getAudioManager();
    }

    public boolean isInVc() {
        return Objects.requireNonNull(this.member.getVoiceState()).inAudioChannel();
    }

    public void joinVc(@NotNull YReplyCallback callback) {
        Verify.isInVc(this, callback);
        this.getAudioManager().openAudioConnection(Objects.requireNonNull(this.getVoiceState()).getChannel());
    }

    public void leaveVc(@NotNull YReplyCallback callback) {
        Verify.isInVc(this, callback);
        this.getAudioManager().closeAudioConnection();
    }

    public void joinVc(@NotNull IReplyCallback callback) {
        Verify.isInVc(this.member, callback);
        this.getAudioManager().openAudioConnection(Objects.requireNonNull(this.getVoiceState()).getChannel());
    }

    public void leaveVc(@NotNull IReplyCallback callback) {
        Verify.isInVc(this.member, callback);
        this.getAudioManager().closeAudioConnection();
    }

    public void joinVc(@NotNull YMember member, @NotNull YReplyCallback callback) {
        Verify.isInVc(member, callback);
        this.getAudioManager().openAudioConnection(Objects.requireNonNull(this.getVoiceState()).getChannel());
    }

    public void leaveVc(@NotNull YMember member, @NotNull YReplyCallback callback) {
        Verify.isInVc(member, callback);
        this.getAudioManager().closeAudioConnection();
    }

    public void joinVc(@NotNull Member member, @NotNull IReplyCallback callback) {
        Verify.isInVc(member, callback);
        this.getAudioManager().openAudioConnection(Objects.requireNonNull(this.getVoiceState()).getChannel());
    }

    public void leaveVc(@NotNull Member member, @NotNull IReplyCallback callback) {
        Verify.isInVc(member, callback);
        this.getAudioManager().closeAudioConnection();
    }

    public void deafen(@NotNull YReplyCallback callback) {
        Verify.isInVc(this, callback);
        this.getAudioManager().setSelfDeafened(true);
    }

    public void deafen(@NotNull IReplyCallback callback) {
        Verify.isInVc(this.member, callback);
        this.getAudioManager().setSelfDeafened(true);
    }

    public void deafen(@NotNull YMember member, @NotNull YReplyCallback callback) {
        Verify.isInVc(member, callback);
        this.getAudioManager().setSelfDeafened(true);
    }

    public void deafen(@NotNull Member member, @NotNull IReplyCallback callback) {
        Verify.isInVc(member, callback);
        this.getAudioManager().setSelfDeafened(true);
    }

    public void mute(@NotNull YReplyCallback callback) {
        Verify.isInVc(this, callback);
        this.getAudioManager().setSelfMuted(true);
    }

    public void mute(@NotNull IReplyCallback callback) {
        Verify.isInVc(this.member, callback);
        this.getAudioManager().setSelfMuted(true);
    }

    public void mute(@NotNull YMember member, @NotNull YReplyCallback callback) {
        Verify.isInVc(member, callback);
        this.getAudioManager().setSelfMuted(true);
    }

    public void mute(@NotNull Member member, @NotNull IReplyCallback callback) {
        Verify.isInVc(member, callback);
        this.getAudioManager().setSelfMuted(true);
    }
}

