/*
 * Decompiled with CFR 0.152.
 */
package io.github.yusufsdiscordbot.yusufsdiscordcore.bot.interaction;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.interactions.InteractionHook;
import net.dv8tion.jda.api.interactions.callbacks.IReplyCallback;
import net.dv8tion.jda.api.requests.restaction.interactions.ReplyCallbackAction;
import net.dv8tion.jda.api.utils.AttachmentOption;
import org.jetbrains.annotations.NotNull;

public class YReplyCallback {
    private final IReplyCallback callback;

    public YReplyCallback(IReplyCallback callback) {
        this.callback = callback;
    }

    public IReplyCallback getCallback() {
        return this.callback;
    }

    @CheckReturnValue
    @NotNull
    public ReplyCallbackAction deferReply() {
        return this.callback.deferReply();
    }

    @CheckReturnValue
    @NotNull
    public ReplyCallbackAction deferReply(boolean ephemeral) {
        return this.callback.deferReply(ephemeral);
    }

    @CheckReturnValue
    @NotNull
    public ReplyCallbackAction reply(@NotNull Message message) {
        return this.callback.reply(message);
    }

    @CheckReturnValue
    @NotNull
    public ReplyCallbackAction reply(@NotNull String content) {
        return this.callback.reply(content);
    }

    @CheckReturnValue
    @NotNull
    public ReplyCallbackAction replyEmbeds(@NotNull Collection<? extends MessageEmbed> embeds) {
        return this.callback.replyEmbeds(embeds);
    }

    @CheckReturnValue
    @NotNull
    public ReplyCallbackAction replyEmbeds(@NotNull MessageEmbed embed, MessageEmbed ... embeds) {
        return this.callback.replyEmbeds(embed, embeds);
    }

    @CheckReturnValue
    @NotNull
    public ReplyCallbackAction replyFormat(@NotNull String format, Object ... args) {
        return this.callback.replyFormat(format, args);
    }

    @CheckReturnValue
    @NotNull
    public ReplyCallbackAction replyFile(@NotNull InputStream data, @NotNull String name, AttachmentOption ... options) {
        return this.callback.replyFile(data, name, options);
    }

    @CheckReturnValue
    @NotNull
    public ReplyCallbackAction replyFile(@NotNull File file, AttachmentOption ... options) {
        return this.callback.replyFile(file, options);
    }

    @CheckReturnValue
    @NotNull
    public ReplyCallbackAction replyFile(@NotNull File file, @NotNull String name, AttachmentOption ... options) {
        return this.callback.replyFile(file, name, options);
    }

    @CheckReturnValue
    @NotNull
    public ReplyCallbackAction replyFile(byte @NotNull [] data, @NotNull String name, AttachmentOption ... options) {
        return this.callback.replyFile(data, name, options);
    }

    public void replyQueuedMessage(@Nonnull String message) {
        this.callback.reply(message).queue();
    }

    public void replyQueuedEphemeral(@Nonnull String message) {
        this.callback.reply(message).setEphemeral(true).queue();
    }

    public void replyQueuedEmbed(@Nonnull MessageEmbed messageEmbed) {
        this.callback.replyEmbeds(messageEmbed, new MessageEmbed[0]).queue();
    }

    public void replyQueuedEphemeralEmbed(@Nonnull MessageEmbed messageEmbed) {
        this.callback.replyEmbeds(messageEmbed, new MessageEmbed[0]).setEphemeral(true).queue();
    }

    @NotNull
    public InteractionHook getHook() {
        return this.callback.getHook();
    }
}

