/*
 * Decompiled with CFR 0.152.
 */
package io.github.yusufsdiscordbot.yusufsdiscordcore.bot.interaction.events;

import io.github.yusufsdiscordbot.annotations.Author;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.handlers.extensions.SlashCommand;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.interaction.YCommandInteraction;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.interaction.YSlashCommandInteraction;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.music.PlayerHandler;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.music.backend.AudioPlayerSendHandler;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.music.backend.Player;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.music.backend.TrackScheduler;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.internal.utils.Checks;
import org.jetbrains.annotations.NotNull;

@Author(firstName="Yusuf", lastName="Arfan Ismail", githubUserName="RealYusufIsmail")
public class YSlashCommandInteractionEvent
extends YCommandInteraction {
    private final SlashCommand command;
    private final SlashCommandInteractionEvent event;
    private static final String GUILD = "guild";

    public YSlashCommandInteractionEvent(SlashCommand command, SlashCommandInteractionEvent event) {
        super(event, event);
        this.command = command;
        this.event = event;
    }

    @Nonnull
    public YSlashCommandInteraction getInteraction() {
        return new YSlashCommandInteraction(this.getCallback(), this.getCommandInteractionPayload(), this.event.getInteraction());
    }

    @Override
    @Nonnull
    public MessageChannel getChannel() {
        return this.event.getChannel();
    }

    @Nonnull
    @NotNull
    public Player getPlayer() {
        Checks.notNull(this.getGuild(), GUILD);
        return PlayerHandler.getInstance().getMusicManager(this.getGuild()).getPlayer();
    }

    @Nonnull
    @NotNull
    public TrackScheduler getScheduler() {
        Checks.notNull(this.getGuild(), GUILD);
        return PlayerHandler.getInstance().getMusicManager(this.getGuild()).getScheduler();
    }

    @Nonnull
    @NotNull
    public AudioPlayerSendHandler getSchedulerHandler() {
        Checks.notNull(this.getGuild(), GUILD);
        return PlayerHandler.getInstance().getMusicManager(this.getGuild()).getSendHandler();
    }

    public void playUrl(@NotNull String urlOrName) {
        Checks.notNull(this.getTextChannel(), "Text Channel");
        PlayerHandler.getInstance().loadAndPlay(this.getTextChannel(), urlOrName);
    }

    public void playName(@NotNull String urlOrName) {
        Checks.notNull(this.getTextChannel(), "Text Channel");
        PlayerHandler.getInstance().loadAndPlay(this.getTextChannel(), "ytsearch:" + urlOrName);
    }
}

