/*
 * Decompiled with CFR 0.152.
 */
package io.github.yusufsdiscordbot.yusufsdiscordcore.bot.music.backend;

import com.sedmelluq.discord.lavaplayer.player.AudioConfiguration;
import com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.remote.RemoteNodeRegistry;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.io.MessageInput;
import com.sedmelluq.discord.lavaplayer.tools.io.MessageOutput;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.DecodedTrackHolder;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.music.backend.Player;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;

public class PlayerManager {
    private final AudioPlayerManager manager;

    public AudioPlayerManager getManager() {
        return this.manager;
    }

    public PlayerManager(AudioPlayerManager manager) {
        this.manager = manager;
    }

    public void shutdown() {
        this.manager.shutdown();
    }

    public void useRemoteNodes(String ... nodeAddresses) {
        this.manager.useRemoteNodes(nodeAddresses);
    }

    public void enableGcMonitoring() {
        this.manager.enableGcMonitoring();
    }

    public void registerSourceManager(AudioSourceManager sourceManager) {
        this.manager.registerSourceManager(sourceManager);
    }

    public <T extends AudioSourceManager> T source(Class<T> klass) {
        return this.manager.source(klass);
    }

    public Future<Void> loadItem(String identifier, AudioLoadResultHandler resultHandler) {
        return this.loadItem(new AudioReference(identifier, null), resultHandler);
    }

    public Future<Void> loadItem(AudioReference reference, AudioLoadResultHandler resultHandler) {
        return this.manager.loadItem(reference, resultHandler);
    }

    public Future<Void> loadItemOrdered(Object orderingKey, String identifier, AudioLoadResultHandler resultHandler) {
        return this.loadItemOrdered(orderingKey, new AudioReference(identifier, null), resultHandler);
    }

    public Future<Void> loadItemOrdered(Object orderingKey, AudioReference reference, AudioLoadResultHandler resultHandler) {
        return this.manager.loadItemOrdered(orderingKey, reference, resultHandler);
    }

    public void encodeTrack(MessageOutput stream, AudioTrack track) throws IOException {
        this.manager.encodeTrack(stream, track);
    }

    public DecodedTrackHolder decodeTrack(MessageInput stream) throws IOException {
        return this.manager.decodeTrack(stream);
    }

    public AudioConfiguration getConfiguration() {
        return this.manager.getConfiguration();
    }

    public boolean isUsingSeekGhosting() {
        return this.manager.isUsingSeekGhosting();
    }

    public void setUseSeekGhosting(boolean useSeekGhosting) {
        this.manager.setUseSeekGhosting(useSeekGhosting);
    }

    public int getFrameBufferDuration() {
        return this.manager.getFrameBufferDuration();
    }

    public void setFrameBufferDuration(int frameBufferDuration) {
        this.manager.setFrameBufferDuration(frameBufferDuration);
    }

    public void setTrackStuckThreshold(long trackStuckThreshold) {
        this.manager.setTrackStuckThreshold(trackStuckThreshold);
    }

    public void setPlayerCleanupThreshold(long cleanupThreshold) {
        this.manager.setPlayerCleanupThreshold(cleanupThreshold);
    }

    public void setItemLoaderThreadPoolSize(int poolSize) {
        this.manager.setItemLoaderThreadPoolSize(poolSize);
    }

    @NotNull
    public Player createPlayer() {
        return new Player(this.manager.createPlayer());
    }

    public RemoteNodeRegistry getRemoteNodeRegistry() {
        return this.manager.getRemoteNodeRegistry();
    }

    public void setHttpRequestConfigurator(UnaryOperator<RequestConfig> configurator) {
        this.manager.setHttpRequestConfigurator(configurator);
    }

    public void setHttpBuilderConfigurator(Consumer<HttpClientBuilder> configurator) {
        this.manager.setHttpBuilderConfigurator(configurator);
    }
}

