/*
 * Decompiled with CFR 0.152.
 */
package io.github.yusufsdiscordbot.yusufsdiscordcore.bot.music.backend;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventAdapter;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.music.backend.Player;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jetbrains.annotations.NotNull;

public class TrackScheduler
extends AudioEventAdapter {
    private final Player player;
    @NotNull
    private final BlockingQueue<AudioTrack> blockingQueue;
    private static final boolean LOOP = false;

    public TrackScheduler(Player player) {
        this.player = player;
        this.blockingQueue = new LinkedBlockingQueue<AudioTrack>();
    }

    public void queue(@NotNull AudioTrack track) {
        if (!this.player.startTrack(track, true)) {
            this.blockingQueue.offer(track);
        } else {
            this.blockingQueue.remove(track);
        }
    }

    public void nextTrack() {
        this.player.startTrack((AudioTrack)this.blockingQueue.poll(), false);
    }

    @Override
    public void onTrackEnd(@NotNull AudioPlayer player, @NotNull AudioTrack track, @NotNull AudioTrackEndReason endReason) {
        if (endReason.mayStartNext) {
            this.nextTrack();
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    public BlockingQueue<AudioTrack> getBlockingQueue() {
        return this.blockingQueue;
    }

    public boolean setLoop(boolean setLoop) {
        return false == setLoop;
    }

    public boolean getLoop() {
        return false;
    }

    public boolean isEmpty() {
        return this.blockingQueue.isEmpty();
    }
}

