/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.IPermissionHolder;
import net.dv8tion.jda.api.entities.PermissionOverride;
import net.dv8tion.jda.api.managers.channel.attribute.IPermissionContainerManager;
import net.dv8tion.jda.api.requests.restaction.PermissionOverrideAction;
import net.dv8tion.jda.internal.utils.Checks;

public interface IPermissionContainer
extends GuildChannel {
    @Nonnull
    public IPermissionContainerManager<?, ?> getManager();

    @Nullable
    public PermissionOverride getPermissionOverride(@Nonnull IPermissionHolder var1);

    @Nonnull
    public List<PermissionOverride> getPermissionOverrides();

    @Nonnull
    default public List<PermissionOverride> getMemberPermissionOverrides() {
        return Collections.unmodifiableList(this.getPermissionOverrides().stream().filter(PermissionOverride::isMemberOverride).collect(Collectors.toList()));
    }

    @Nonnull
    default public List<PermissionOverride> getRolePermissionOverrides() {
        return Collections.unmodifiableList(this.getPermissionOverrides().stream().filter(PermissionOverride::isRoleOverride).collect(Collectors.toList()));
    }

    @Nonnull
    @CheckReturnValue
    default public PermissionOverrideAction createPermissionOverride(@Nonnull IPermissionHolder permissionHolder) {
        Checks.notNull(permissionHolder, "PermissionHolder");
        if (this.getPermissionOverride(permissionHolder) != null) {
            throw new IllegalStateException("Provided member already has a PermissionOverride in this channel!");
        }
        return this.putPermissionOverride(permissionHolder);
    }

    @Nonnull
    @CheckReturnValue
    public PermissionOverrideAction putPermissionOverride(@Nonnull IPermissionHolder var1);

    @Nonnull
    @CheckReturnValue
    default public PermissionOverrideAction upsertPermissionOverride(@Nonnull IPermissionHolder permissionHolder) {
        PermissionOverride override = this.getPermissionOverride(permissionHolder);
        if (override != null) {
            return override.getManager();
        }
        return this.putPermissionOverride(permissionHolder);
    }
}

