/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.interactions.callbacks;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.interactions.callbacks.IDeferrableCallback;
import net.dv8tion.jda.api.requests.restaction.interactions.ReplyCallbackAction;
import net.dv8tion.jda.api.utils.AttachmentOption;
import net.dv8tion.jda.internal.requests.restaction.interactions.ReplyCallbackActionImpl;
import net.dv8tion.jda.internal.utils.Checks;

public interface IReplyCallback
extends IDeferrableCallback {
    @Nonnull
    @CheckReturnValue
    public ReplyCallbackAction deferReply();

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction deferReply(boolean ephemeral) {
        return this.deferReply().setEphemeral(ephemeral);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction reply(@Nonnull Message message) {
        Checks.notNull(message, "Message");
        ReplyCallbackActionImpl action = (ReplyCallbackActionImpl)this.deferReply();
        return action.applyMessage(message);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction reply(@Nonnull String content) {
        Checks.notNull(content, "Content");
        return this.deferReply().setContent(content);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyEmbeds(@Nonnull Collection<? extends MessageEmbed> embeds) {
        return this.deferReply().addEmbeds(embeds);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyEmbeds(@Nonnull MessageEmbed embed, MessageEmbed ... embeds) {
        Checks.notNull(embed, "MessageEmbed");
        Checks.noneNull(embeds, "MessageEmbed");
        return this.deferReply().addEmbeds(embed).addEmbeds(embeds);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyFormat(@Nonnull String format, Object ... args) {
        Checks.notNull(format, "Format String");
        return this.reply(String.format(format, args));
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyFile(@Nonnull InputStream data, @Nonnull String name, AttachmentOption ... options) {
        return this.deferReply().addFile(data, name, options);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyFile(@Nonnull File file, AttachmentOption ... options) {
        return this.deferReply().addFile(file, options);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyFile(@Nonnull File file, @Nonnull String name, AttachmentOption ... options) {
        return this.deferReply().addFile(file, name, options);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyFile(@Nonnull byte[] data, @Nonnull String name, AttachmentOption ... options) {
        return this.deferReply().addFile(data, name, options);
    }
}

