/*
 * Decompiled with CFR 0.152.
 */
package io.github.yusufsdiscordbot.yusufsdiscordcore.bot.handlers;

import io.github.yusufsdiscordbot.annotations.Authors;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.exception.DuplicateNameException;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.handlers.CommandType;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.handlers.extensions.MessageCommand;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.handlers.extensions.SlashCommand;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.handlers.extensions.UserCommand;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.interaction.events.YSlashCommandInteractionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.commands.SlashCommandInteraction;
import net.dv8tion.jda.api.interactions.commands.build.CommandData;
import net.dv8tion.jda.api.requests.restaction.CommandListUpdateAction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Authors(namesOfTheAuthors={"Yusuf Arfan Ismail", "Serkwi Bruno Ndzi"}, namesOfTheAuthorsGithub={"RealYusufIsmail", "nDZIB"})
public abstract class CoreSlashCommandHandler
extends ListenerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(CoreSlashCommandHandler.class);
    private final Map<String, SlashCommand> slashCommand = new HashMap<String, SlashCommand>();
    private final Map<String, UserCommand> userCommand = new HashMap<String, UserCommand>();
    private final Map<String, MessageCommand> messageCommand = new HashMap<String, MessageCommand>();
    private static final String COMMAND_ERROR = "The command {} is not registered";
    @NotNull
    private final CommandListUpdateAction globalCommandsData;
    @NotNull
    private final CommandListUpdateAction guildCommandsData;
    @NotNull
    private final JDA jda;

    protected CoreSlashCommandHandler(@NotNull JDA jda, @NotNull Guild guild) {
        this.globalCommandsData = jda.updateCommands();
        this.guildCommandsData = guild.updateCommands();
        this.jda = jda;
    }

    protected abstract long botOwnerId();

    private void addSlashCommand(@NotNull SlashCommand command) {
        this.jda.addEventListener(new Object[]{command});
        this.slashCommand.put(command.getName(), command);
        if (command.checkIfIsGuildOnly()) {
            this.guildCommandsData.addCommands(new CommandData[]{command.getSlashCommandData()});
        } else if (!command.checkIfIsGuildOnly()) {
            this.globalCommandsData.addCommands(new CommandData[]{command.getSlashCommandData()});
        } else {
            logger.error(COMMAND_ERROR, (Object)command.getName());
        }
    }

    private void addUserCommand(@NotNull UserCommand command) {
        this.jda.addEventListener(new Object[]{command});
        if (command.checkIfIsGuildOnly()) {
            this.guildCommandsData.addCommands(new CommandData[]{command.getCommandData()});
        } else if (!command.checkIfIsGuildOnly()) {
            this.globalCommandsData.addCommands(new CommandData[]{command.getCommandData()});
        } else {
            logger.error(COMMAND_ERROR, (Object)command.getName());
        }
    }

    private void addMessageCommand(@NotNull MessageCommand command) {
        this.jda.addEventListener(new Object[]{command});
        if (command.checkIfIsGuildOnly()) {
            this.guildCommandsData.addCommands(new CommandData[]{command.getCommandData()});
        } else if (!command.checkIfIsGuildOnly()) {
            this.globalCommandsData.addCommands(new CommandData[]{command.getCommandData()});
        } else {
            logger.error(COMMAND_ERROR, (Object)command.getName());
        }
    }

    public void queueAndRegisterCommands(@NotNull Collection<SlashCommand> commands, @NotNull Collection<UserCommand> userCommands, @NotNull Collection<MessageCommand> messageCommands) {
        commands.forEach(this::addSlashCommand);
        userCommands.forEach(this::addUserCommand);
        messageCommands.forEach(this::addMessageCommand);
        this.onFinishedRegistration();
    }

    public void queueAndRegisterUserCommands(@NotNull Collection<UserCommand> userCommands) {
        userCommands.forEach(this::addUserCommand);
        this.onFinishedRegistration();
    }

    public void queueAndRegisterSlashCommands(@NotNull Collection<SlashCommand> slashCommands) {
        slashCommands.forEach(this::addSlashCommand);
        this.onFinishedRegistration();
    }

    public void queueAndRegisterMessageContextCommands(@NotNull Collection<MessageCommand> messageCommand) {
        messageCommand.forEach(this::addMessageCommand);
        this.onFinishedRegistration();
    }

    private void onFinishedRegistration() {
        this.globalCommandsData.queue();
        this.guildCommandsData.queue();
    }

    private void runSlashCommandEvent(@NotNull SlashCommandInteractionEvent slashCommandEvent) throws DuplicateNameException {
        if (this.checkIfCommandNameIsNullOrRepeated(slashCommandEvent) || this.isCommandOwnerOnly(slashCommandEvent, this.botOwnerId())) {
            this.onSlashCommandEvent(slashCommandEvent);
        }
    }

    private boolean checkIfCommandNameIsNullOrRepeated(@NotNull SlashCommandInteractionEvent slashCommandEvent) throws DuplicateNameException {
        boolean cmdName = this.slashCommand.containsKey(slashCommandEvent.getName());
        if (cmdName) {
            return true;
        }
        throw new DuplicateNameException((SlashCommandInteraction)slashCommandEvent);
    }

    private boolean isCommandOwnerOnly(@NotNull SlashCommandInteractionEvent slashCommandEvent, long botOwnerId) {
        SlashCommand onSlashCommand = this.slashCommand.get(slashCommandEvent.getName());
        if (onSlashCommand.getCommandType() == CommandType.OWNER_ONLY && slashCommandEvent.getMember().getIdLong() == botOwnerId) {
            return true;
        }
        slashCommandEvent.reply("This command is only available for the bot owner").setEphemeral(true).queue();
        logger.error("You are not the owner of the bot so you can not run this command '{}'", (Object)slashCommandEvent.getCommandPath());
        return false;
    }

    private void onSlashCommandEvent(@NotNull SlashCommandInteractionEvent slashCommandEvent) {
        SlashCommand onSlashCommand = this.slashCommand.get(slashCommandEvent.getName());
        onSlashCommand.onSlashCommand(new YSlashCommandInteractionEvent(onSlashCommand, slashCommandEvent));
    }

    public void onSlashCommandInteraction(@NotNull SlashCommandInteractionEvent slashCommandEvent) {
        try {
            this.runSlashCommandEvent(slashCommandEvent);
        }
        catch (DuplicateNameException e) {
            logger.error("'{}'", (Object)e.getMessage());
        }
    }

    @NotNull
    public List<SlashCommand> getSlashCommands() {
        return new ArrayList<SlashCommand>(this.slashCommand.values());
    }

    @NotNull
    public List<UserCommand> getUserCommands() {
        return new ArrayList<UserCommand>(this.userCommand.values());
    }

    @NotNull
    public List<MessageCommand> getMessageCommands() {
        return new ArrayList<MessageCommand>(this.messageCommand.values());
    }
}

