/*
 * Decompiled with CFR 0.152.
 */
package io.github.yusufsdiscordbot.yusufsdiscordcore.bot.music;

import com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.core.YGuild;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.music.backend.MusicManager;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.music.backend.PlayerManager;
import io.github.yusufsdiscordbot.yusufsdiscordcore.bot.music.backend.YAudioSourceManagers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dv8tion.jda.api.audio.AudioSendHandler;
import net.dv8tion.jda.api.entities.TextChannel;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerHandler {
    private static final Logger logger = LoggerFactory.getLogger(PlayerHandler.class);
    private static PlayerHandler instance;
    @NotNull
    private final Map<Long, MusicManager> musicManagers = new HashMap<Long, MusicManager>();
    @NotNull
    private final PlayerManager audioPlayerManager = new PlayerManager((AudioPlayerManager)new DefaultAudioPlayerManager());

    public PlayerHandler() {
        YAudioSourceManagers.registerRemoteSources(this.audioPlayerManager);
        YAudioSourceManagers.registerLocalSource(this.audioPlayerManager);
    }

    public static PlayerHandler getInstance() {
        if (instance == null) {
            instance = new PlayerHandler();
        }
        return instance;
    }

    public MusicManager getMusicManager(@NotNull YGuild guild) {
        return this.musicManagers.computeIfAbsent(guild.getGuildIdLong(), guildId -> {
            MusicManager guildMusicManager = new MusicManager(this.audioPlayerManager);
            guild.getAudioManager().setSendingHandler((AudioSendHandler)guildMusicManager.getSendHandler());
            return guildMusicManager;
        });
    }

    public void loadAndPlay(final @NotNull TextChannel channel, String trackUrl) {
        final MusicManager musicManager = this.getMusicManager(new YGuild(channel.getGuild()));
        this.audioPlayerManager.loadItemOrdered((Object)musicManager, trackUrl, new AudioLoadResultHandler(){

            public void trackLoaded(@NotNull AudioTrack track) {
                musicManager.scheduler.queue(track);
                channel.sendMessage((CharSequence)"Adding to queue: `").append((CharSequence)track.getInfo().title).append((CharSequence)"` by `").append((CharSequence)track.getInfo().author).append('`').queue();
            }

            public void playlistLoaded(@NotNull AudioPlaylist playlist) {
                List tracks = playlist.getTracks();
                channel.sendMessage((CharSequence)"Adding to queue: `").append((CharSequence)String.valueOf(tracks.size())).append((CharSequence)"` tracks from playlist `").append((CharSequence)playlist.getName()).append('`').queue();
                for (AudioTrack track : tracks) {
                    musicManager.scheduler.queue(track);
                }
            }

            public void noMatches() {
                channel.sendMessage((CharSequence)"No matches has been found").queue();
                logger.info("No matches have been found.");
            }

            public void loadFailed(FriendlyException exception) {
                channel.sendMessage((CharSequence)"The bot could not load the music. Please type /support for help.").queue();
                logger.error("The bot has failed while trying to load the music.");
            }
        });
    }
}

