/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.rollingtextview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.yy.mobile.rollingtextview.CharOrderManager;
import com.yy.mobile.rollingtextview.R;
import com.yy.mobile.rollingtextview.TextManager;
import com.yy.mobile.rollingtextview.strategy.CharOrderStrategy;
import com.yy.mobile.rollingtextview.strategy.Strategy;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0019\n\u0002\b\r\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0016\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IJ\u0019\u0010J\u001a\u00020G2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020M0L\u00a2\u0006\u0002\u0010NJ\u000e\u0010J\u001a\u00020G2\u0006\u0010K\u001a\u000201J\u0014\u0010J\u001a\u00020G2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020M0OJ\b\u0010P\u001a\u00020DH\u0002J\b\u0010Q\u001a\u00020\u0007H\u0002J\b\u0010R\u001a\u00020\u0007H\u0002J\b\u0010S\u001a\u00020\u0007H\u0016J\u0006\u0010T\u001a\u000201J\u0006\u0010U\u001a\u00020VJ\u0010\u0010W\u001a\u00020G2\u0006\u0010X\u001a\u00020YH\u0014J\u0018\u0010Z\u001a\u00020G2\u0006\u0010[\u001a\u00020\u00072\u0006\u0010\\\u001a\u00020\u0007H\u0014J(\u0010]\u001a\u00020G2\u0006\u0010^\u001a\u00020\u00072\u0006\u0010_\u001a\u00020\u00072\u0006\u0010`\u001a\u00020\u00072\u0006\u0010a\u001a\u00020\u0007H\u0014J\b\u0010b\u001a\u00020GH\u0002J\u0010\u0010c\u001a\u00020G2\u0006\u0010X\u001a\u00020YH\u0002J\u000e\u0010d\u001a\u00020G2\u0006\u0010H\u001a\u00020IJ\u000e\u0010e\u001a\u00020G2\u0006\u0010f\u001a\u000201J\u0016\u0010e\u001a\u00020G2\u0006\u0010f\u001a\u0002012\u0006\u0010g\u001a\u00020DJ\u000e\u0010h\u001a\u00020G2\u0006\u0010i\u001a\u00020VJ\u0016\u0010h\u001a\u00020G2\u0006\u0010j\u001a\u00020\u00072\u0006\u0010k\u001a\u00020VR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010-\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010(\"\u0004\b/\u0010*R\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00103\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010(\"\u0004\b5\u0010*R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010<\u001a\u0004\u0018\u00010;2\b\u0010\u001b\u001a\u0004\u0018\u00010;8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u000e\u0010A\u001a\u00020BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020DX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020DX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006l"}, d2={"Lcom/yy/mobile/rollingtextview/RollingTextView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "animationDuration", "", "getAnimationDuration", "()J", "setAnimationDuration", "(J)V", "animationInterpolator", "Landroid/view/animation/Interpolator;", "getAnimationInterpolator", "()Landroid/view/animation/Interpolator;", "setAnimationInterpolator", "(Landroid/view/animation/Interpolator;)V", "animator", "Landroid/animation/ValueAnimator;", "kotlin.jvm.PlatformType", "charOrderManager", "Lcom/yy/mobile/rollingtextview/CharOrderManager;", "value", "Lcom/yy/mobile/rollingtextview/strategy/CharOrderStrategy;", "charStrategy", "getCharStrategy", "()Lcom/yy/mobile/rollingtextview/strategy/CharOrderStrategy;", "setCharStrategy", "(Lcom/yy/mobile/rollingtextview/strategy/CharOrderStrategy;)V", "currentText", "", "getCurrentText", "()[C", "gravity", "getGravity", "()I", "setGravity", "(I)V", "lastMeasuredDesiredHeight", "lastMeasuredDesiredWidth", "letterSpacingExtra", "getLetterSpacingExtra", "setLetterSpacingExtra", "targetText", "", "color", "textColor", "getTextColor", "setTextColor", "textManager", "Lcom/yy/mobile/rollingtextview/TextManager;", "textPaint", "Landroid/graphics/Paint;", "textStyle", "Landroid/graphics/Typeface;", "typeface", "getTypeface", "()Landroid/graphics/Typeface;", "setTypeface", "(Landroid/graphics/Typeface;)V", "viewBounds", "Landroid/graphics/Rect;", "viewHeightLargerThanTextHeight", "", "viewWidthLargerThanTextWidth", "addAnimatorListener", "", "listener", "Landroid/animation/Animator$AnimatorListener;", "addCharOrder", "orderList", "", "", "([Ljava/lang/Character;)V", "", "checkForReLayout", "computeDesiredHeight", "computeDesiredWidth", "getBaseline", "getText", "getTextSize", "", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onSizeChanged", "width", "height", "oldw", "oldh", "onTextPaintMeasurementChanged", "realignAndClipCanvasForGravity", "removeAnimatorListener", "setText", "text", "animate", "setTextSize", "textSize", "unit", "size", "RollingText.RollingText"})
public class RollingTextView
extends View {
    private int lastMeasuredDesiredWidth;
    private int lastMeasuredDesiredHeight;
    @NotNull
    private final Paint textPaint;
    @NotNull
    private final CharOrderManager charOrderManager;
    @NotNull
    private final TextManager textManager;
    private ValueAnimator animator;
    @NotNull
    private final Rect viewBounds;
    private int textStyle;
    @NotNull
    private CharSequence targetText;
    private long animationDuration;
    private boolean viewWidthLargerThanTextWidth;
    private boolean viewHeightLargerThanTextHeight;
    private int gravity;
    @NotNull
    private Interpolator animationInterpolator;
    private int textColor;

    @JvmOverloads
    public RollingTextView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.textPaint = new Paint();
        this.charOrderManager = new CharOrderManager();
        this.textManager = new TextManager(this.textPaint, this.charOrderManager);
        float[] fArray = new float[]{1.0f};
        this.animator = ValueAnimator.ofFloat((float[])fArray);
        this.viewBounds = new Rect();
        this.targetText = "";
        this.animationDuration = 750L;
        this.gravity = 0x800005;
        Ref.IntRef shadowColor = new Ref.IntRef();
        Ref.FloatRef shadowDx = new Ref.FloatRef();
        Ref.FloatRef shadowDy = new Ref.FloatRef();
        Ref.FloatRef shadowRadius = new Ref.FloatRef();
        Ref.ObjectRef text = new Ref.ObjectRef();
        text.element = "";
        Ref.FloatRef textSize = new Ref.FloatRef();
        textSize.element = TypedValue.applyDimension((int)2, (float)12.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RollingTextView, defStyleAttr, defStyleRes);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026tr, defStyleRes\n        )");
        TypedArray arr = typedArray;
        int textAppearanceResId = arr.getResourceId(R.styleable.RollingTextView_android_textAppearance, -1);
        if (textAppearanceResId != -1) {
            TypedArray typedArray2 = context.obtainStyledAttributes(textAppearanceResId, R.styleable.RollingTextView);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray2, (String)"context.obtainStyledAttr\u2026ingTextView\n            )");
            TypedArray textAppearanceArr = typedArray2;
            RollingTextView._init_$applyTypedArray(this, shadowColor, shadowDx, shadowDy, shadowRadius, (Ref.ObjectRef<String>)text, textSize, textAppearanceArr);
            textAppearanceArr.recycle();
        }
        RollingTextView._init_$applyTypedArray(this, shadowColor, shadowDx, shadowDy, shadowRadius, (Ref.ObjectRef<String>)text, textSize, arr);
        this.animationDuration = arr.getInt(R.styleable.RollingTextView_duration, (int)this.animationDuration);
        this.textPaint.setAntiAlias(true);
        if (shadowColor.element != 0) {
            this.textPaint.setShadowLayer(shadowRadius.element, shadowDx.element, shadowDy.element, shadowColor.element);
        }
        if (this.textStyle != 0) {
            this.setTypeface(this.textPaint.getTypeface());
        }
        this.setTextSize(0, textSize.element);
        this.setText((CharSequence)text.element, false);
        arr.recycle();
        this.animator.addUpdateListener(arg_0 -> RollingTextView._init_$lambda-0(this, arg_0));
        this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(@Nullable Animator animation) {
                textManager.onAnimationEnd();
            }
        });
        this.animationInterpolator = (Interpolator)new LinearInterpolator();
        this.textColor = -16777216;
    }

    public /* synthetic */ RollingTextView(Context context, AttributeSet attributeSet, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            attributeSet = null;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        this(context, attributeSet, n, n2);
    }

    public final long getAnimationDuration() {
        return this.animationDuration;
    }

    public final void setAnimationDuration(long l) {
        this.animationDuration = l;
    }

    public final int getGravity() {
        return this.gravity;
    }

    public final void setGravity(int n) {
        this.gravity = n;
    }

    @Nullable
    public final Typeface getTypeface() {
        return this.textPaint.getTypeface();
    }

    public final void setTypeface(@Nullable Typeface value) {
        Typeface typeface;
        int n = this.textStyle;
        switch (n) {
            case 3: {
                typeface = Typeface.create((Typeface)value, (int)3);
                break;
            }
            case 1: {
                typeface = Typeface.create((Typeface)value, (int)1);
                break;
            }
            case 2: {
                typeface = Typeface.create((Typeface)value, (int)2);
                break;
            }
            default: {
                typeface = value;
            }
        }
        this.textPaint.setTypeface(typeface);
        this.onTextPaintMeasurementChanged();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        canvas.save();
        this.realignAndClipCanvasForGravity(canvas);
        canvas.translate(0.0f, this.textManager.getTextBaseline());
        this.textManager.draw(canvas);
        canvas.restore();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.lastMeasuredDesiredWidth = this.computeDesiredWidth();
        this.lastMeasuredDesiredHeight = this.computeDesiredHeight();
        int desiredWidth = View.resolveSize((int)this.lastMeasuredDesiredWidth, (int)widthMeasureSpec);
        int desiredHeight = View.resolveSize((int)this.lastMeasuredDesiredHeight, (int)heightMeasureSpec);
        this.setMeasuredDimension(desiredWidth, desiredHeight);
    }

    protected void onSizeChanged(int width, int height, int oldw, int oldh) {
        super.onSizeChanged(width, height, oldw, oldh);
        this.viewBounds.set(this.getPaddingLeft(), this.getPaddingTop(), width - this.getPaddingRight(), height - this.getPaddingBottom());
        this.viewWidthLargerThanTextWidth = this.viewBounds.width() > this.computeDesiredWidth();
        this.viewHeightLargerThanTextHeight = this.viewBounds.height() > this.computeDesiredHeight();
    }

    private final boolean checkForReLayout() {
        boolean heightChanged;
        boolean widthChanged = this.lastMeasuredDesiredWidth != this.computeDesiredWidth();
        boolean bl = heightChanged = this.lastMeasuredDesiredHeight != this.computeDesiredHeight();
        if (widthChanged || heightChanged) {
            this.requestLayout();
            return true;
        }
        return false;
    }

    private final int computeDesiredWidth() {
        return (int)this.textManager.getCurrentTextWidth() + this.getPaddingLeft() + this.getPaddingRight();
    }

    private final int computeDesiredHeight() {
        return (int)this.textManager.getTextHeight() + this.getPaddingTop() + this.getPaddingBottom();
    }

    private final void realignAndClipCanvasForGravity(Canvas canvas) {
        float currentWidth = this.textManager.getCurrentTextWidth();
        float currentHeight = this.textManager.getTextHeight();
        int availableWidth = this.viewBounds.width();
        int availableHeight = this.viewBounds.height();
        float translationX = this.viewBounds.left;
        float translationY = this.viewBounds.top;
        if (this.viewWidthLargerThanTextWidth) {
            if ((this.gravity & 1) == 1) {
                translationX = (float)this.viewBounds.left + ((float)availableWidth - currentWidth) / 2.0f;
            }
            if ((this.gravity & 0x800005) == 0x800005) {
                translationX = (float)this.viewBounds.left + ((float)availableWidth - currentWidth);
            }
        }
        if (this.viewHeightLargerThanTextHeight) {
            if ((this.gravity & 0x10) == 16) {
                translationY = (float)this.viewBounds.top + ((float)availableHeight - currentHeight) / 2.0f;
            }
            if ((this.gravity & 0x50) == 80) {
                translationY = (float)this.viewBounds.top + ((float)availableHeight - currentHeight);
            }
        }
        canvas.translate(translationX, translationY);
        canvas.clipRect(0.0f, 0.0f, currentWidth, currentHeight);
    }

    private final void onTextPaintMeasurementChanged() {
        this.textManager.updateFontMetrics();
        this.checkForReLayout();
        this.invalidate();
    }

    @NotNull
    public final Interpolator getAnimationInterpolator() {
        return this.animationInterpolator;
    }

    public final void setAnimationInterpolator(@NotNull Interpolator interpolator) {
        Intrinsics.checkNotNullParameter((Object)interpolator, (String)"<set-?>");
        this.animationInterpolator = interpolator;
    }

    public final void setText(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.setText(text, !TextUtils.isEmpty((CharSequence)this.targetText));
    }

    @NotNull
    public final CharSequence getText() {
        return this.targetText;
    }

    public final void setText(@NotNull CharSequence text, boolean animate) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.targetText = text;
        if (animate) {
            this.textManager.setText(text);
            ValueAnimator valueAnimator = this.animator;
            boolean bl = false;
            boolean bl2 = false;
            ValueAnimator $this$setText_u24lambda_u2d2 = valueAnimator;
            boolean bl3 = false;
            if ($this$setText_u24lambda_u2d2.isRunning()) {
                $this$setText_u24lambda_u2d2.cancel();
            }
            $this$setText_u24lambda_u2d2.setDuration(this.getAnimationDuration());
            $this$setText_u24lambda_u2d2.setInterpolator((TimeInterpolator)this.getAnimationInterpolator());
            this.post(() -> RollingTextView.setText$lambda-2$lambda-1($this$setText_u24lambda_u2d2));
        } else {
            CharOrderStrategy originalStrategy = this.getCharStrategy();
            this.setCharStrategy(Strategy.NoAnimation());
            this.textManager.setText(text);
            this.setCharStrategy(originalStrategy);
            this.textManager.onAnimationEnd();
            this.checkForReLayout();
            this.invalidate();
        }
    }

    @NotNull
    public final char[] getCurrentText() {
        return this.textManager.getCurrentText();
    }

    public final void setTextSize(float textSize) {
        this.setTextSize(2, textSize);
    }

    public final float getTextSize() {
        return this.textPaint.getTextSize();
    }

    public final void setTextSize(int unit, float size) {
        Resources resources;
        Resources resources2;
        Context context = this.getContext();
        Resources resources3 = resources2 = context == null ? null : context.getResources();
        if (resources2 == null) {
            context = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getSystem()");
            resources = context;
        } else {
            resources = resources2;
        }
        Resources r = resources;
        this.textPaint.setTextSize(TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)r.getDisplayMetrics()));
        this.onTextPaintMeasurementChanged();
    }

    public final int getTextColor() {
        return this.textColor;
    }

    public final void setTextColor(int color) {
        if (this.textColor != color) {
            this.textColor = color;
            this.textPaint.setColor(color);
            this.invalidate();
        }
    }

    public final int getLetterSpacingExtra() {
        return this.textManager.getLetterSpacingExtra();
    }

    public final void setLetterSpacingExtra(int value) {
        this.textManager.setLetterSpacingExtra(value);
    }

    public int getBaseline() {
        Paint.FontMetrics fontMetrics = this.textPaint.getFontMetrics();
        return (int)(this.textManager.getTextHeight() / (float)2 + ((fontMetrics.descent - fontMetrics.ascent) / (float)2 - fontMetrics.descent));
    }

    @NotNull
    public final CharOrderStrategy getCharStrategy() {
        return this.charOrderManager.getCharStrategy();
    }

    public final void setCharStrategy(@NotNull CharOrderStrategy value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.charOrderManager.setCharStrategy(value);
    }

    public final void addAnimatorListener(@NotNull Animator.AnimatorListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.animator.addListener(listener);
    }

    public final void removeAnimatorListener(@NotNull Animator.AnimatorListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.animator.removeListener(listener);
    }

    public final void addCharOrder(@NotNull CharSequence orderList) {
        Intrinsics.checkNotNullParameter((Object)orderList, (String)"orderList");
        this.charOrderManager.addCharOrder(StringsKt.asIterable((CharSequence)orderList));
    }

    public final void addCharOrder(@NotNull Iterable<Character> orderList) {
        Intrinsics.checkNotNullParameter(orderList, (String)"orderList");
        this.charOrderManager.addCharOrder(orderList);
    }

    public final void addCharOrder(@NotNull Character[] orderList) {
        Intrinsics.checkNotNullParameter((Object)orderList, (String)"orderList");
        this.charOrderManager.addCharOrder(ArraysKt.asIterable((Object[])orderList));
    }

    @JvmOverloads
    public RollingTextView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, defStyleAttr, 0, 8, null);
    }

    @JvmOverloads
    public RollingTextView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 0, 12, null);
    }

    @JvmOverloads
    public RollingTextView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 0, 14, null);
    }

    private static final void _init_$applyTypedArray(RollingTextView this$0, Ref.IntRef shadowColor, Ref.FloatRef shadowDx, Ref.FloatRef shadowDy, Ref.FloatRef shadowRadius, Ref.ObjectRef<String> text, Ref.FloatRef textSize, TypedArray arr) {
        this$0.gravity = arr.getInt(R.styleable.RollingTextView_android_gravity, this$0.gravity);
        shadowColor.element = arr.getColor(R.styleable.RollingTextView_android_shadowColor, shadowColor.element);
        shadowDx.element = arr.getFloat(R.styleable.RollingTextView_android_shadowDx, shadowDx.element);
        shadowDy.element = arr.getFloat(R.styleable.RollingTextView_android_shadowDy, shadowDy.element);
        shadowRadius.element = arr.getFloat(R.styleable.RollingTextView_android_shadowRadius, shadowRadius.element);
        String string = arr.getString(R.styleable.RollingTextView_android_text);
        text.element = string == null ? "" : string;
        this$0.setTextColor(arr.getColor(R.styleable.RollingTextView_android_textColor, this$0.textColor));
        textSize.element = arr.getDimension(R.styleable.RollingTextView_android_textSize, textSize.element);
        this$0.textStyle = arr.getInt(R.styleable.RollingTextView_android_textStyle, this$0.textStyle);
    }

    private static final void _init_$lambda-0(RollingTextView this$0, ValueAnimator it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.textManager.updateAnimation(it.getAnimatedFraction());
        this$0.checkForReLayout();
        this$0.invalidate();
    }

    private static final void setText$lambda-2$lambda-1(ValueAnimator $this_with) {
        $this_with.start();
    }
}

