/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.rollingtextview;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.yy.mobile.rollingtextview.PreviousProgress;
import com.yy.mobile.rollingtextview.TextManager;
import com.yy.mobile.rollingtextview.strategy.Direction;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u0006\u0010/\u001a\u00020,J\u0006\u00100\u001a\u00020,J\u001e\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020\"2\u0006\u00105\u001a\u00020\"R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010#\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0017R\u0011\u0010)\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/yy/mobile/rollingtextview/TextColumn;", "", "manager", "Lcom/yy/mobile/rollingtextview/TextManager;", "column", "", "textPaint", "Landroid/graphics/Paint;", "changeCharList", "", "", "direction", "Lcom/yy/mobile/rollingtextview/strategy/Direction;", "(Lcom/yy/mobile/rollingtextview/TextManager;ILandroid/graphics/Paint;Ljava/util/List;Lcom/yy/mobile/rollingtextview/strategy/Direction;)V", "animateStartWidth", "", "getChangeCharList", "()Ljava/util/List;", "setChangeCharList", "(Ljava/util/List;)V", "<set-?>", "currentChar", "getCurrentChar", "()C", "currentWidth", "getCurrentWidth", "()F", "setCurrentWidth", "(F)V", "getDirection", "()Lcom/yy/mobile/rollingtextview/strategy/Direction;", "setDirection", "(Lcom/yy/mobile/rollingtextview/strategy/Direction;)V", "edgeDelta", "", "index", "getIndex", "()I", "previousEdgeDelta", "sourceChar", "getSourceChar", "targetChar", "getTargetChar", "draw", "", "canvas", "Landroid/graphics/Canvas;", "measure", "onAnimationEnd", "onAnimationUpdate", "Lcom/yy/mobile/rollingtextview/PreviousProgress;", "currentIndex", "offsetPercentage", "progress", "RollingText.RollingText"})
public final class TextColumn {
    @NotNull
    private final TextManager manager;
    private final int column;
    @NotNull
    private final Paint textPaint;
    @NotNull
    private List<Character> changeCharList;
    @NotNull
    private Direction direction;
    private float currentWidth;
    private float animateStartWidth;
    private char currentChar;
    private double previousEdgeDelta;
    private double edgeDelta;
    private int index;

    public TextColumn(@NotNull TextManager manager, int column, @NotNull Paint textPaint, @NotNull List<Character> changeCharList, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)textPaint, (String)"textPaint");
        Intrinsics.checkNotNullParameter(changeCharList, (String)"changeCharList");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.manager = manager;
        this.column = column;
        this.textPaint = textPaint;
        this.changeCharList = changeCharList;
        this.direction = direction;
        this.currentChar = this.changeCharList.size() < 2 ? this.getTargetChar() : this.getSourceChar();
        this.measure();
    }

    @NotNull
    public final List<Character> getChangeCharList() {
        return this.changeCharList;
    }

    public final void setChangeCharList(@NotNull List<Character> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.changeCharList = list;
    }

    @NotNull
    public final Direction getDirection() {
        return this.direction;
    }

    public final void setDirection(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"<set-?>");
        this.direction = direction;
    }

    public final float getCurrentWidth() {
        return this.currentWidth;
    }

    public final void setCurrentWidth(float f) {
        this.currentWidth = f;
    }

    public final char getCurrentChar() {
        return this.currentChar;
    }

    public final char getSourceChar() {
        return this.changeCharList.size() < 2 ? (char)'\u0000' : ((Character)CollectionsKt.first(this.changeCharList)).charValue();
    }

    public final char getTargetChar() {
        return this.changeCharList.isEmpty() ? (char)'\u0000' : ((Character)CollectionsKt.last(this.changeCharList)).charValue();
    }

    public final int getIndex() {
        return this.index;
    }

    public final void measure() {
        this.animateStartWidth = this.currentWidth = this.manager.charWidth(this.currentChar, this.textPaint);
    }

    @NotNull
    public final PreviousProgress onAnimationUpdate(int currentIndex, double offsetPercentage, double progress) {
        float f;
        if (this.index != currentIndex) {
            this.animateStartWidth = this.currentWidth;
        }
        this.index = currentIndex;
        this.currentChar = this.changeCharList.get(currentIndex).charValue();
        double additionalDelta = this.previousEdgeDelta * (1.0 - progress);
        double d = this.edgeDelta = this.direction.getOrientation() == 0 ? offsetPercentage * (double)this.currentWidth * (double)this.direction.getValue() + additionalDelta : offsetPercentage * (double)this.manager.getTextHeight() * (double)this.direction.getValue() + additionalDelta;
        if (offsetPercentage <= 0.5) {
            f = this.manager.charWidth(this.currentChar, this.textPaint);
        } else {
            int n = currentIndex + 1;
            int n2 = CollectionsKt.getLastIndex(this.changeCharList);
            boolean bl = false;
            char nextChar = this.changeCharList.get(Math.min(n, n2)).charValue();
            f = this.manager.charWidth(nextChar, this.textPaint);
        }
        float targetWidth = f;
        this.currentWidth = offsetPercentage <= 0.0 ? targetWidth : (float)((double)(targetWidth - this.animateStartWidth) * offsetPercentage + (double)this.animateStartWidth);
        return new PreviousProgress(this.index, offsetPercentage, progress, this.currentChar, this.currentWidth);
    }

    public final void onAnimationEnd() {
        this.currentChar = this.getTargetChar();
        this.edgeDelta = 0.0;
        this.previousEdgeDelta = 0.0;
    }

    public final void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.direction.getOrientation() == 0) {
            TextColumn.draw$drawText$default(this, canvas, this.index + 1, (float)this.edgeDelta - this.currentWidth * (float)this.direction.getValue(), 0.0f, 16, null);
            TextColumn.draw$drawText$default(this, canvas, this.index, (float)this.edgeDelta, 0.0f, 16, null);
            TextColumn.draw$drawText$default(this, canvas, this.index - 1, (float)this.edgeDelta + this.currentWidth * (float)this.direction.getValue(), 0.0f, 16, null);
        } else {
            TextColumn.draw$drawText$default(this, canvas, this.index + 1, 0.0f, (float)this.edgeDelta - this.manager.getTextHeight() * (float)this.direction.getValue(), 8, null);
            TextColumn.draw$drawText$default(this, canvas, this.index, 0.0f, (float)this.edgeDelta, 8, null);
            TextColumn.draw$drawText$default(this, canvas, this.index - 1, 0.0f, (float)this.edgeDelta + this.manager.getTextHeight() * (float)this.direction.getValue(), 8, null);
        }
    }

    private static final char[] draw$drawText$charAt(TextColumn this$0, int idx) {
        int n = 0;
        char[] cArray = new char[1];
        while (n < 1) {
            int n2 = n++;
            cArray[n2] = this$0.changeCharList.get(idx).charValue();
        }
        return cArray;
    }

    private static final void draw$drawText(TextColumn this$0, Canvas $canvas, int idx, float horizontalOffset, float verticalOffset) {
        if (idx >= 0 && idx < this$0.changeCharList.size() && this$0.changeCharList.get(idx).charValue() != '\u0000') {
            $canvas.drawText(TextColumn.draw$drawText$charAt(this$0, idx), 0, 1, horizontalOffset, verticalOffset, this$0.textPaint);
        }
    }

    static /* synthetic */ void draw$drawText$default(TextColumn textColumn, Canvas canvas, int n, float f, float f2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            f = 0.0f;
        }
        if ((n2 & 0x10) != 0) {
            f2 = 0.0f;
        }
        TextColumn.draw$drawText(textColumn, canvas, n, f, f2);
    }
}

