/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.rollingtextview;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.yy.mobile.rollingtextview.CharOrderManager;
import com.yy.mobile.rollingtextview.NextProgress;
import com.yy.mobile.rollingtextview.PreviousProgress;
import com.yy.mobile.rollingtextview.TextColumn;
import com.yy.mobile.rollingtextview.strategy.Direction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0005\b\u0000\u0018\u0000 /2\u00020\u0001:\u0001/B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020%J\u000e\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020+J\u000e\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020\u000fJ\u0006\u0010.\u001a\u00020%R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0011R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010 \u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/yy/mobile/rollingtextview/TextManager;", "", "textPaint", "Landroid/graphics/Paint;", "charOrderManager", "Lcom/yy/mobile/rollingtextview/CharOrderManager;", "(Landroid/graphics/Paint;Lcom/yy/mobile/rollingtextview/CharOrderManager;)V", "charListColumns", "", "", "currentText", "", "getCurrentText", "()[C", "currentTextWidth", "", "getCurrentTextWidth", "()F", "letterSpacingExtra", "", "getLetterSpacingExtra", "()I", "setLetterSpacingExtra", "(I)V", "map", "", "<set-?>", "textBaseline", "getTextBaseline", "textColumns", "", "Lcom/yy/mobile/rollingtextview/TextColumn;", "textHeight", "getTextHeight", "charWidth", "c", "draw", "", "canvas", "Landroid/graphics/Canvas;", "onAnimationEnd", "setText", "targetText", "", "updateAnimation", "progress", "updateFontMetrics", "Companion", "RollingText.RollingText"})
public final class TextManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Paint textPaint;
    @NotNull
    private final CharOrderManager charOrderManager;
    @NotNull
    private final Map<Character, Float> map;
    @NotNull
    private final List<TextColumn> textColumns;
    @NotNull
    private List<? extends List<Character>> charListColumns;
    private int letterSpacingExtra;
    private float textHeight;
    private float textBaseline;
    public static final char EMPTY = '\u0000';

    public TextManager(@NotNull Paint textPaint, @NotNull CharOrderManager charOrderManager) {
        Intrinsics.checkNotNullParameter((Object)textPaint, (String)"textPaint");
        Intrinsics.checkNotNullParameter((Object)charOrderManager, (String)"charOrderManager");
        this.textPaint = textPaint;
        this.charOrderManager = charOrderManager;
        this.map = new LinkedHashMap(36);
        boolean bl = false;
        this.textColumns = new ArrayList();
        List list = Collections.emptyList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList()");
        this.charListColumns = list;
        this.updateFontMetrics();
    }

    public final int getLetterSpacingExtra() {
        return this.letterSpacingExtra;
    }

    public final void setLetterSpacingExtra(int n) {
        this.letterSpacingExtra = n;
    }

    public final float charWidth(char c, @NotNull Paint textPaint) {
        float f;
        Intrinsics.checkNotNullParameter((Object)textPaint, (String)"textPaint");
        if (c == '\u0000') {
            f = 0.0f;
        } else {
            Float f2 = this.map.get(Character.valueOf(c));
            if (f2 == null) {
                float f3 = textPaint.measureText(String.valueOf(c));
                boolean bl = false;
                boolean bl2 = false;
                float it = f3;
                boolean bl3 = false;
                Map<Character, Float> map = this.map;
                Character c2 = Character.valueOf(c);
                Float f4 = Float.valueOf(it);
                boolean bl4 = false;
                map.put(c2, f4);
                f = f3;
            } else {
                f = f2.floatValue();
            }
        }
        return f;
    }

    public final void updateFontMetrics() {
        this.map.clear();
        Paint.FontMetrics fontMetrics = this.textPaint.getFontMetrics();
        boolean bl = false;
        boolean bl2 = false;
        Paint.FontMetrics $this$updateFontMetrics_u24lambda_u2d1 = fontMetrics;
        boolean bl3 = false;
        this.textHeight = $this$updateFontMetrics_u24lambda_u2d1.bottom - $this$updateFontMetrics_u24lambda_u2d1.top;
        this.textBaseline = -$this$updateFontMetrics_u24lambda_u2d1.top;
        Iterable $this$forEach$iv = this.textColumns;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextColumn it = (TextColumn)element$iv;
            boolean bl4 = false;
            it.measure();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateAnimation(float progress) {
        PreviousProgress initialize = new PreviousProgress(0, 0.0, progress, '\u0000', 0.0f, 24, null);
        List<TextColumn> $this$foldRightIndexed$iv = this.textColumns;
        boolean $i$f$foldRightIndexed = false;
        PreviousProgress accumulator$iv = initialize;
        if (!$this$foldRightIndexed$iv.isEmpty()) {
            ListIterator<TextColumn> iterator$iv = $this$foldRightIndexed$iv.listIterator($this$foldRightIndexed$iv.size());
            while (iterator$iv.hasPrevious()) {
                PreviousProgress previous;
                void column;
                void previousProgress;
                int index$iv = iterator$iv.previousIndex();
                PreviousProgress previousProgress2 = accumulator$iv;
                TextColumn textColumn = iterator$iv.previous();
                int index = index$iv;
                boolean bl = false;
                NextProgress nextProgress = this.charOrderManager.getProgress((PreviousProgress)previousProgress, index, this.charListColumns, column.getIndex());
                accumulator$iv = previous = column.onAnimationUpdate(nextProgress.getCurrentIndex(), nextProgress.getOffsetPercentage(), nextProgress.getProgress());
            }
        }
    }

    public final void onAnimationEnd() {
        Iterable $this$forEach$iv = this.textColumns;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextColumn it = (TextColumn)element$iv;
            boolean bl = false;
            it.onAnimationEnd();
        }
        this.charOrderManager.afterCharOrder();
    }

    public final void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Iterable $this$forEach$iv = this.textColumns;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextColumn it = (TextColumn)element$iv;
            boolean bl = false;
            it.draw(canvas);
            canvas.translate(it.getCurrentWidth() + (float)this.getLetterSpacingExtra(), 0.0f);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final float getCurrentTextWidth() {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        int n = 0;
        int n2 = this.textColumns.size() - 1;
        boolean bl = false;
        int space = this.letterSpacingExtra * Math.max(n, n2);
        Iterable $this$map$iv = this.textColumns;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextColumn textColumn = (TextColumn)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Float f = Float.valueOf(it.getCurrentWidth());
            collection.add(f);
        }
        $this$map$iv = (List)destination$iv$iv;
        float initial$iv = 0.0f;
        boolean $i$f$fold = false;
        float accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void next;
            float item$iv$iv = ((Number)element$iv).floatValue();
            float total = accumulator$iv;
            boolean bl3 = false;
            accumulator$iv = total + next;
        }
        float textWidth = accumulator$iv;
        return textWidth + (float)space;
    }

    /*
     * WARNING - void declaration
     */
    public final void setText(@NotNull CharSequence targetText) {
        Collection<List<Character>> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)targetText, (String)"targetText");
        char[] cArray = this.getCurrentText();
        int n = 0;
        String sourceText = new String(cArray);
        n = sourceText.length();
        int n2 = targetText.length();
        boolean bl = false;
        int maxLen = Math.max(n, n2);
        this.charOrderManager.beforeCharOrder(sourceText, targetText);
        this.textColumns.clear();
        n = 0;
        if (n < maxLen) {
            do {
                int idx = n++;
                Pair<List<Character>, Direction> pair = this.charOrderManager.findCharOrder(sourceText, targetText, idx);
                List list = (List)pair.component1();
                Direction direction = (Direction)((Object)pair.component2());
                this.textColumns.add(new TextColumn(this, idx, this.textPaint, list, direction));
            } while (n < maxLen);
        }
        Iterable iterable = this.textColumns;
        TextManager textManager = this;
        boolean $i$f$map = false;
        void var6_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextColumn textColumn = (TextColumn)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            List<Character> list = it.getChangeCharList();
            collection.add(list);
        }
        collection = (List)destination$iv$iv;
        textManager.charListColumns = collection;
    }

    @NotNull
    public final char[] getCurrentText() {
        int n = 0;
        int n2 = this.textColumns.size();
        char[] cArray = new char[n2];
        while (n < n2) {
            int n3 = n++;
            cArray[n3] = this.textColumns.get(n3).getCurrentChar();
        }
        return cArray;
    }

    public final float getTextHeight() {
        return this.textHeight;
    }

    public final float getTextBaseline() {
        return this.textBaseline;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/mobile/rollingtextview/TextManager$Companion;", "", "()V", "EMPTY", "", "RollingText.RollingText"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

