/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.rollingtextview.strategy;

import com.yy.mobile.rollingtextview.strategy.Direction;
import com.yy.mobile.rollingtextview.strategy.NormalAnimationStrategy;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JJ\u0010\u0007\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00120\tj\u0002`\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lcom/yy/mobile/rollingtextview/strategy/AlignAnimationStrategy;", "Lcom/yy/mobile/rollingtextview/strategy/NormalAnimationStrategy;", "alignment", "Lcom/yy/mobile/rollingtextview/strategy/AlignAnimationStrategy$TextAlignment;", "(Lcom/yy/mobile/rollingtextview/strategy/AlignAnimationStrategy$TextAlignment;)V", "getAlignment", "()Lcom/yy/mobile/rollingtextview/strategy/AlignAnimationStrategy$TextAlignment;", "findCharOrder", "Lkotlin/Pair;", "", "", "Lcom/yy/mobile/rollingtextview/strategy/Direction;", "sourceText", "", "targetText", "index", "", "charPool", "", "Lcom/yy/mobile/rollingtextview/strategy/CharPool;", "getTextRange", "Lkotlin/ranges/IntRange;", "text", "maxLen", "TextAlignment", "RollingText.RollingText"})
public class AlignAnimationStrategy
extends NormalAnimationStrategy {
    @NotNull
    private final TextAlignment alignment;

    public AlignAnimationStrategy(@NotNull TextAlignment alignment) {
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        this.alignment = alignment;
    }

    @NotNull
    public final TextAlignment getAlignment() {
        return this.alignment;
    }

    @Override
    @NotNull
    public Pair<List<Character>, Direction> findCharOrder(@NotNull CharSequence sourceText, @NotNull CharSequence targetText, int index, @NotNull List<? extends Collection<Character>> charPool) {
        Intrinsics.checkNotNullParameter((Object)sourceText, (String)"sourceText");
        Intrinsics.checkNotNullParameter((Object)targetText, (String)"targetText");
        Intrinsics.checkNotNullParameter(charPool, (String)"charPool");
        int n = sourceText.length();
        int n2 = targetText.length();
        boolean bl = false;
        int maxLen = Math.max(n, n2);
        char srcChar = '\u0000';
        char tgtChar = '\u0000';
        IntRange srcRange = this.getTextRange(sourceText, maxLen);
        IntRange tgtRange = this.getTextRange(targetText, maxLen);
        int n3 = srcRange.getFirst();
        boolean bl2 = index <= srcRange.getLast() ? n3 <= index : false;
        if (bl2) {
            srcChar = sourceText.charAt(index - srcRange.getFirst());
        }
        n3 = tgtRange.getFirst();
        boolean bl3 = index <= tgtRange.getLast() ? n3 <= index : false;
        if (bl3) {
            tgtChar = targetText.charAt(index - tgtRange.getFirst());
        }
        return this.findCharOrder(srcChar, tgtChar, index, charPool);
    }

    private final IntRange getTextRange(CharSequence text, int maxLen) {
        int n;
        TextAlignment textAlignment = this.alignment;
        int n2 = WhenMappings.$EnumSwitchMapping$0[textAlignment.ordinal()];
        switch (n2) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = MathKt.roundToInt((float)((float)(maxLen - text.length()) / 2.0f));
                break;
            }
            case 3: {
                n = maxLen - text.length();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int from = n;
        int to = from + text.length();
        return RangesKt.until((int)from, (int)to);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/yy/mobile/rollingtextview/strategy/AlignAnimationStrategy$TextAlignment;", "", "(Ljava/lang/String;I)V", "Left", "Right", "Center", "RollingText.RollingText"})
    public static final class TextAlignment
    extends Enum<TextAlignment> {
        public static final /* enum */ TextAlignment Left = new TextAlignment();
        public static final /* enum */ TextAlignment Right = new TextAlignment();
        public static final /* enum */ TextAlignment Center = new TextAlignment();
        private static final /* synthetic */ TextAlignment[] $VALUES;

        public static TextAlignment[] values() {
            return (TextAlignment[])$VALUES.clone();
        }

        public static TextAlignment valueOf(String value) {
            return Enum.valueOf(TextAlignment.class, value);
        }

        static {
            $VALUES = textAlignmentArray = new TextAlignment[]{TextAlignment.Left, TextAlignment.Right, TextAlignment.Center};
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TextAlignment.values().length];
            nArray[TextAlignment.Left.ordinal()] = 1;
            nArray[TextAlignment.Center.ordinal()] = 2;
            nArray[TextAlignment.Right.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

