/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.rollingtextview.strategy;

import com.yy.mobile.rollingtextview.NextProgress;
import com.yy.mobile.rollingtextview.PreviousProgress;
import com.yy.mobile.rollingtextview.strategy.Direction;
import com.yy.mobile.rollingtextview.strategy.SimpleCharOrderStrategy;
import com.yy.mobile.rollingtextview.util.CircularList;
import com.yy.mobile.rollingtextview.util.ExtraList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u001e\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010$\u001a\u00020%H\u0016J0\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0016\u0010*\u001a\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006j\u0002`+H\u0016JE\u0010,\u001a\b\u0012\u0004\u0012\u00020\b0\u00062\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/2\b\u00101\u001a\u0004\u0018\u00010\b2\b\u00102\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u00103J0\u00104\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0004\u0012\u00020/052\f\u00106\u001a\b\u0012\u0004\u0012\u00020\b0\u00062\u0006\u00107\u001a\u00020/H\u0016J\b\u00108\u001a\u00020\u0003H\u0016JJ\u00109\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0004\u0012\u00020\u0003052\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u00107\u001a\u00020/2\u0016\u0010*\u001a\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006j\u0002`+H\u0016J4\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020/2\u0012\u0010?\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00060\u00062\u0006\u0010@\u001a\u00020/H\u0016R(\u0010\u0005\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0018\u00010\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0012\"\u0004\b\u001d\u0010\u0014R\u001a\u0010\u001e\u001a\u00020\u001fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006A"}, d2={"Lcom/yy/mobile/rollingtextview/strategy/CarryBitStrategy;", "Lcom/yy/mobile/rollingtextview/strategy/SimpleCharOrderStrategy;", "direction", "Lcom/yy/mobile/rollingtextview/strategy/Direction;", "(Lcom/yy/mobile/rollingtextview/strategy/Direction;)V", "charOrderList", "", "", "", "getCharOrderList", "()Ljava/util/List;", "setCharOrderList", "(Ljava/util/List;)V", "getDirection", "()Lcom/yy/mobile/rollingtextview/strategy/Direction;", "sourceCumulative", "", "getSourceCumulative", "()[I", "setSourceCumulative", "([I)V", "sourceIndex", "getSourceIndex", "setSourceIndex", "targetCumulative", "getTargetCumulative", "setTargetCumulative", "targetIndex", "getTargetIndex", "setTargetIndex", "toBigger", "", "getToBigger", "()Z", "setToBigger", "(Z)V", "afterCompute", "", "beforeCompute", "sourceText", "", "targetText", "charPool", "Lcom/yy/mobile/rollingtextview/strategy/CharPool;", "circularList", "rawList", "size", "", "firstIndex", "first", "last", "(Ljava/util/List;IILjava/lang/Character;Ljava/lang/Character;)Ljava/util/List;", "determineCharOrder", "Lkotlin/Pair;", "orderList", "index", "determineDirection", "findCharOrder", "nextProgress", "Lcom/yy/mobile/rollingtextview/NextProgress;", "previousProgress", "Lcom/yy/mobile/rollingtextview/PreviousProgress;", "columnIndex", "columns", "charIndex", "RollingText.RollingText"})
public class CarryBitStrategy
extends SimpleCharOrderStrategy {
    @NotNull
    private final Direction direction;
    @Nullable
    private int[] sourceIndex;
    @Nullable
    private int[] targetIndex;
    @Nullable
    private int[] sourceCumulative;
    @Nullable
    private int[] targetCumulative;
    @Nullable
    private List<? extends Collection<Character>> charOrderList;
    private boolean toBigger;

    public CarryBitStrategy(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.direction = direction;
        this.toBigger = true;
    }

    @NotNull
    public final Direction getDirection() {
        return this.direction;
    }

    @Nullable
    protected final int[] getSourceIndex() {
        return this.sourceIndex;
    }

    protected final void setSourceIndex(@Nullable int[] nArray) {
        this.sourceIndex = nArray;
    }

    @Nullable
    protected final int[] getTargetIndex() {
        return this.targetIndex;
    }

    protected final void setTargetIndex(@Nullable int[] nArray) {
        this.targetIndex = nArray;
    }

    @Nullable
    protected final int[] getSourceCumulative() {
        return this.sourceCumulative;
    }

    protected final void setSourceCumulative(@Nullable int[] nArray) {
        this.sourceCumulative = nArray;
    }

    @Nullable
    protected final int[] getTargetCumulative() {
        return this.targetCumulative;
    }

    protected final void setTargetCumulative(@Nullable int[] nArray) {
        this.targetCumulative = nArray;
    }

    @Nullable
    protected final List<Collection<Character>> getCharOrderList() {
        return this.charOrderList;
    }

    protected final void setCharOrderList(@Nullable List<? extends Collection<Character>> list) {
        this.charOrderList = list;
    }

    protected final boolean getToBigger() {
        return this.toBigger;
    }

    protected final void setToBigger(boolean bl) {
        this.toBigger = bl;
    }

    @Override
    public void beforeCompute(@NotNull CharSequence sourceText, @NotNull CharSequence targetText, @NotNull List<? extends Collection<Character>> charPool) {
        boolean bl;
        int n;
        Intrinsics.checkNotNullParameter((Object)sourceText, (String)"sourceText");
        Intrinsics.checkNotNullParameter((Object)targetText, (String)"targetText");
        Intrinsics.checkNotNullParameter(charPool, (String)"charPool");
        if (sourceText.length() >= 10 || targetText.length() >= 10) {
            throw new IllegalStateException("your text is too long, it may overflow the integer calculation. please use other animation strategy.");
        }
        int n2 = sourceText.length();
        int n3 = targetText.length();
        boolean bl2 = false;
        int maxLen = Math.max(n2, n3);
        int[] srcArray = new int[maxLen];
        int[] tgtArray = new int[maxLen];
        int[] carryArray = new int[maxLen];
        boolean bl3 = false;
        List charOrderList = new ArrayList();
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)maxLen);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object v0;
            char tgtChar;
            char srcChar;
            block7: {
                int element$iv;
                int index = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl4 = false;
                srcChar = '\u0000';
                tgtChar = '\u0000';
                int sIdx = index - maxLen + sourceText.length();
                int tIdx = index - maxLen + targetText.length();
                if (sIdx >= 0) {
                    srcChar = sourceText.charAt(sIdx);
                }
                if (tIdx >= 0) {
                    tgtChar = targetText.charAt(tIdx);
                }
                Iterable iterable = charPool;
                n = 0;
                Iterable iterable2 = iterable;
                bl = false;
                for (Object t : iterable2) {
                    Collection it = (Collection)t;
                    boolean bl5 = false;
                    if (!(it.contains(Character.valueOf(srcChar)) && it.contains(Character.valueOf(tgtChar)))) continue;
                    v0 = t;
                    break block7;
                }
                v0 = null;
            }
            Collection collection = v0;
            if (collection == null) {
                throw new IllegalStateException("the char " + srcChar + " or " + tgtChar + " cannot be found in the charPool,please addCharOrder() before use");
            }
            Collection iterable = collection;
            charOrderList.add(iterable);
            int n4 = CollectionsKt.indexOf((Iterable)iterable, (Object)Character.valueOf(srcChar)) - 1;
            int n5 = -1;
            n = 0;
            srcArray[index] = Math.max(n4, n5);
            n4 = CollectionsKt.indexOf((Iterable)iterable, (Object)Character.valueOf(tgtChar)) - 1;
            n5 = -1;
            n = 0;
            tgtArray[index] = Math.max(n4, n5);
            carryArray[index] = iterable.size() - 1;
        }
        int[] sourceCumulative = new int[maxLen];
        int[] targetCumulative = new int[maxLen];
        int srcTotal = 0;
        int tgtTotal = 0;
        int carry = 0;
        Iterable $this$forEach$iv2 = (Iterable)RangesKt.until((int)0, (int)maxLen);
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv2.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int idx = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl6 = false;
            n = srcArray[idx];
            int n6 = 0;
            bl = false;
            srcTotal = Math.max(n, n6) + carry * srcTotal;
            n = tgtArray[idx];
            n6 = 0;
            bl = false;
            tgtTotal = Math.max(n, n6) + carry * tgtTotal;
            carry = carryArray[idx];
            sourceCumulative[idx] = srcTotal;
            targetCumulative[idx] = tgtTotal;
        }
        this.sourceIndex = srcArray;
        this.targetIndex = tgtArray;
        this.sourceCumulative = sourceCumulative;
        this.targetCumulative = targetCumulative;
        this.charOrderList = charOrderList;
        this.toBigger = srcTotal < tgtTotal;
    }

    @Override
    public void afterCompute() {
        this.sourceCumulative = null;
        this.targetCumulative = null;
        this.charOrderList = null;
        this.sourceIndex = null;
        this.targetIndex = null;
    }

    @Override
    @NotNull
    public NextProgress nextProgress(@NotNull PreviousProgress previousProgress, int columnIndex, @NotNull List<? extends List<Character>> columns, int charIndex) {
        Intrinsics.checkNotNullParameter((Object)previousProgress, (String)"previousProgress");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        if (columnIndex == columns.size() - 1) {
            return super.nextProgress(previousProgress, columnIndex, columns, charIndex);
        }
        int[] srcIndex = this.sourceIndex;
        List<? extends Collection<Character>> charOrders = this.charOrderList;
        if (srcIndex != null && charOrders != null) {
            int nextStartIndex;
            int n = srcIndex[columnIndex + 1];
            int n2 = 0;
            boolean bl = false;
            int preStartIndex = Math.max(n, n2);
            int preCarry = charOrders.get(columnIndex + 1).size() - 1;
            int preCurrentIndex = previousProgress.getCurrentIndex();
            int n3 = nextStartIndex = this.toBigger ? (preCurrentIndex + preStartIndex) / preCarry : (preCurrentIndex - preStartIndex - 1 + preCarry) / preCarry;
            boolean upgrade = this.toBigger ? (preCurrentIndex + preStartIndex + 1) % preCarry == 0 : (preCurrentIndex - preStartIndex) % preCarry == 0;
            return upgrade ? new NextProgress(nextStartIndex, previousProgress.getOffsetPercentage(), previousProgress.getProgress()) : new NextProgress(nextStartIndex, 0.0, previousProgress.getProgress());
        }
        return super.nextProgress(previousProgress, columnIndex, columns, charIndex);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Pair<List<Character>, Direction> findCharOrder(@NotNull CharSequence sourceText, @NotNull CharSequence targetText, int index, @NotNull List<? extends Collection<Character>> charPool) {
        Intrinsics.checkNotNullParameter((Object)sourceText, (String)"sourceText");
        Intrinsics.checkNotNullParameter((Object)targetText, (String)"targetText");
        Intrinsics.checkNotNullParameter(charPool, (String)"charPool");
        int[] srcIndex = this.sourceIndex;
        int[] tgtIndex = this.targetIndex;
        int[] srcCumulate = this.sourceCumulative;
        int[] tgtCumulate = this.targetCumulative;
        List<? extends Collection<Character>> charOrders = this.charOrderList;
        if (srcCumulate != null && tgtCumulate != null && charOrders != null && srcIndex != null && tgtIndex != null) {
            void $this$filterIndexedTo$iv$iv22;
            Iterable $this$filterIndexed$iv = charOrders.get(index);
            int $i$f$filterIndexed = 0;
            Iterable iterable = $this$filterIndexed$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIndexedTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv22;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                void element$iv$iv;
                int n = index$iv$iv$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl2 = false;
                char c = ((Character)element$iv$iv).charValue();
                int i = index$iv$iv;
                boolean bl3 = false;
                if (!(i > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List orderList = (List)destination$iv$iv;
            $i$f$filterIndexed = srcCumulate[index] - tgtCumulate[index];
            boolean $this$filterIndexedTo$iv$iv22 = false;
            int size = Math.abs($i$f$filterIndexed) + 1;
            Character first = null;
            Character last = null;
            if (srcIndex[index] == -1) {
                first = Character.valueOf('\u0000');
            }
            if (tgtIndex[index] == -1) {
                last = Character.valueOf('\u0000');
            }
            Pair<List<Character>, Integer> pair = this.determineCharOrder(orderList, RangesKt.coerceAtLeast((int)srcIndex[index], (int)0));
            List list = (List)pair.component1();
            int firstIndex = ((Number)pair.component2()).intValue();
            return TuplesKt.to(this.circularList(list, size, firstIndex, first, last), (Object)((Object)this.determineDirection()));
        }
        throw new IllegalStateException("CarryBitStrategy is in a illegal state, check it's lifecycle");
    }

    @NotNull
    public List<Character> circularList(@NotNull List<Character> rawList, int size, int firstIndex, @Nullable Character first, @Nullable Character last) {
        Intrinsics.checkNotNullParameter(rawList, (String)"rawList");
        CircularList<Character> circularList = new CircularList<Character>(rawList, size, firstIndex);
        return new ExtraList<Character>((List)circularList, first, last);
    }

    @NotNull
    public Pair<List<Character>, Integer> determineCharOrder(@NotNull List<Character> orderList, int index) {
        Intrinsics.checkNotNullParameter(orderList, (String)"orderList");
        return this.toBigger ? TuplesKt.to(orderList, (Object)index) : TuplesKt.to((Object)CollectionsKt.asReversed(orderList), (Object)(orderList.size() - 1 - index));
    }

    @NotNull
    public Direction determineDirection() {
        return this.direction;
    }
}

