/*
 * Decompiled with CFR 0.152.
 */
package com.pitaya.mobile.uinspector;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.provider.Settings;
import android.view.View;
import androidx.annotation.AnyThread;
import androidx.annotation.MainThread;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import com.pitaya.mobile.uinspector.UInspector;
import com.pitaya.mobile.uinspector.lifecycle.UInspectorLifecycle;
import com.pitaya.mobile.uinspector.notification.UInspectorNotificationService;
import com.pitaya.mobile.uinspector.plugins.UInspectorPlugins;
import com.pitaya.mobile.uinspector.plugins.UInspectorPluginsImpl;
import com.pitaya.mobile.uinspector.state.UInspectorLifecycleState;
import com.pitaya.mobile.uinspector.state.UInspectorState;
import com.pitaya.mobile.uinspector.ui.panel.fullscreen.UInspectorDialogFragment;
import com.pitaya.mobile.uinspector.ui.panel.fullscreen.UInspectorLegacyDialogFragment;
import com.pitaya.mobile.uinspector.ui.panel.fullscreen.UInspectorPanel;
import com.pitaya.mobile.uinspector.ui.panel.fullscreen.UInspectorWindow;
import com.pitaya.mobile.uinspector.util.UtilsKt;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0015\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0001\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0001\u00a2\u0006\u0002\b\u0019J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\b\u0010\u001d\u001a\u00020\u0013H\u0007J\b\u0010\u001e\u001a\u00020\u0013H\u0007J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u000fH\u0007J\u0015\u0010 \u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b!J\b\u0010\"\u001a\u00020\u0013H\u0007J\r\u0010#\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b$J\r\u0010%\u001a\u00020\u0013H\u0001\u00a2\u0006\u0002\b&R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0080.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/pitaya/mobile/uinspector/UInspector;", "", "()V", "<set-?>", "Landroid/app/Application;", "application", "getApplication$UInspector_Uinspector_api", "()Landroid/app/Application;", "currentState", "Lcom/pitaya/mobile/uinspector/state/UInspectorState;", "init", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lifecycle", "Lcom/pitaya/mobile/uinspector/lifecycle/UInspectorLifecycle;", "pendingInspectView", "Landroid/view/View;", "plugins", "Lcom/pitaya/mobile/uinspector/plugins/UInspectorPlugins;", "changePanelState", "", "running", "", "changeStateInner", "changeStateInner$UInspector_Uinspector_api", "changeStateTemporary", "changeStateTemporary$UInspector_Uinspector_api", "create", "context", "Landroid/content/Context;", "destroy", "start", "inspectView", "startService", "startService$UInspector_Uinspector_api", "stop", "stopService", "stopService$UInspector_Uinspector_api", "syncState", "syncState$UInspector_Uinspector_api", "UInspector.Uinspector-api"})
@SuppressLint(value={"StaticFieldLeak"})
public final class UInspector {
    @NotNull
    public static final UInspector INSTANCE = new UInspector();
    @JvmField
    @NotNull
    public static final UInspectorState currentState = new UInspectorState();
    @JvmField
    @NotNull
    public static final UInspectorPlugins plugins = new UInspectorPluginsImpl((Function1<? super UInspectorPlugins, Unit>)((Function1)plugins.1.INSTANCE));
    private static Application application;
    @NotNull
    private static final AtomicBoolean init;
    @NotNull
    private static final UInspectorLifecycle lifecycle;
    @Nullable
    private static View pendingInspectView;

    private UInspector() {
    }

    @JvmStatic
    @MainThread
    public static final void create(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (init.compareAndSet(false, true)) {
            Context context2 = context.getApplicationContext();
            if (context2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.Application");
            }
            application = (Application)context2;
            lifecycle.register(INSTANCE.getApplication$UInspector_Uinspector_api());
            INSTANCE.stop();
        }
    }

    @JvmStatic
    @MainThread
    public static final void destroy() {
        if (init.compareAndSet(true, false)) {
            INSTANCE.changeStateInner$UInspector_Uinspector_api(false);
            lifecycle.unRegister(INSTANCE.getApplication$UInspector_Uinspector_api());
            INSTANCE.getApplication$UInspector_Uinspector_api().stopService(new Intent((Context)INSTANCE.getApplication$UInspector_Uinspector_api(), UInspectorNotificationService.class));
        }
    }

    @JvmStatic
    @AnyThread
    public static final void start() {
        INSTANCE.startService$UInspector_Uinspector_api(true);
    }

    @JvmStatic
    @AnyThread
    public static final void start(@NotNull View inspectView) {
        Intrinsics.checkNotNullParameter((Object)inspectView, (String)"inspectView");
        pendingInspectView = inspectView;
        INSTANCE.start();
    }

    @JvmStatic
    @AnyThread
    public static final void stop() {
        INSTANCE.startService$UInspector_Uinspector_api(false);
    }

    @NotNull
    public final Application getApplication$UInspector_Uinspector_api() {
        Application application = UInspector.application;
        if (application != null) {
            return application;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"application");
        return null;
    }

    public final void startService$UInspector_Uinspector_api(boolean running) {
        if (!init.get()) {
            throw new IllegalStateException("UInspector has not been init");
        }
        ContextCompat.startForegroundService((Context)((Context)this.getApplication$UInspector_Uinspector_api()), (Intent)new Intent((Context)this.getApplication$UInspector_Uinspector_api(), UInspectorNotificationService.class).putExtra("pending_start", running));
    }

    public final void stopService$UInspector_Uinspector_api() {
        if (!init.get()) {
            throw new IllegalStateException("UInspector has not been init");
        }
        this.getApplication$UInspector_Uinspector_api().stopService(new Intent((Context)this.getApplication$UInspector_Uinspector_api(), UInspectorNotificationService.class));
    }

    @MainThread
    public final void syncState$UInspector_Uinspector_api() {
        this.changeStateInner$UInspector_Uinspector_api(currentState.isRunning());
    }

    @MainThread
    public final void changeStateInner$UInspector_Uinspector_api(boolean running) {
        this.changePanelState(running);
        currentState.setRunning$UInspector_Uinspector_api(running);
        UtilsKt.log(Intrinsics.stringPlus((String)"change state to ", (Object)(running ? "RUNNING" : "IDLE")));
    }

    @MainThread
    public final void changeStateTemporary$UInspector_Uinspector_api(boolean running) {
        this.changePanelState(running);
        UtilsKt.log(Intrinsics.stringPlus((String)"change state TEMPORARY to ", (Object)(running ? "RUNNING" : "IDLE")));
    }

    private final void changePanelState(boolean running) {
        UInspectorLifecycleState currentLifecycle = currentState.getWithLifecycle();
        if (currentLifecycle != null) {
            Activity activity = currentLifecycle.getActivity();
            currentLifecycle.clear$UInspector_Uinspector_api();
            if (running) {
                currentLifecycle.registerFragmentLifecycle$UInspector_Uinspector_api();
                UInspectorPanel mask = Build.VERSION.SDK_INT >= 23 && Settings.canDrawOverlays((Context)((Context)activity)) ? (UInspectorPanel)new UInspectorWindow() : (activity instanceof FragmentActivity ? (UInspectorPanel)new UInspectorDialogFragment() : (UInspectorPanel)new UInspectorLegacyDialogFragment());
                currentLifecycle.setPanel$UInspector_Uinspector_api(mask);
                mask.show(activity);
                View view = pendingInspectView;
                if (view != null) {
                    View view2 = view;
                    boolean bl = false;
                    boolean bl2 = false;
                    View it = view2;
                    boolean bl3 = false;
                    mask.updateTargetView(it);
                }
                pendingInspectView = null;
            }
        }
    }

    static {
        init = new AtomicBoolean(false);
        lifecycle = new UInspectorLifecycle();
    }
}

