/*
 * Decompiled with CFR 0.152.
 */
package com.pitaya.mobile.uinspector.lifecycle;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.lifecycle.ProcessLifecycleOwner;
import com.pitaya.mobile.uinspector.UInspector;
import com.pitaya.mobile.uinspector.lifecycle.UInspectorLifecycle;
import com.pitaya.mobile.uinspector.state.UInspectorLifecycleState;
import com.pitaya.mobile.uinspector.util.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0002\u0004\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0003J\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\"\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/pitaya/mobile/uinspector/lifecycle/UInspectorLifecycle;", "", "()V", "activityLifecycle", "com/pitaya/mobile/uinspector/lifecycle/UInspectorLifecycle$activityLifecycle$1", "Lcom/pitaya/mobile/uinspector/lifecycle/UInspectorLifecycle$activityLifecycle$1;", "appLifecycle", "com/pitaya/mobile/uinspector/lifecycle/UInspectorLifecycle$appLifecycle$1", "Lcom/pitaya/mobile/uinspector/lifecycle/UInspectorLifecycle$appLifecycle$1;", "<set-?>", "Landroid/app/Activity;", "currentActivity", "getCurrentActivity", "()Landroid/app/Activity;", "onActivityChanged", "", "newActivity", "register", "application", "Landroid/app/Application;", "unRegister", "UInspector.Uinspector-api"})
public final class UInspectorLifecycle {
    @Nullable
    private Activity currentActivity;
    @NotNull
    private final appLifecycle.1 appLifecycle = new LifecycleObserver(){

        @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
        public final void onForeground() {
            boolean running = UInspector.currentState.isRunning();
            UtilsKt.log(Intrinsics.stringPlus((String)"onForeground: restart service, isRunning = ", (Object)running));
            UInspector.INSTANCE.startService$UInspector_Uinspector_api(running);
        }

        @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
        public final void onBackground() {
            UtilsKt.log("onBackground: stop service");
            UInspector.INSTANCE.changeStateTemporary$UInspector_Uinspector_api(false);
            UInspector.INSTANCE.stopService$UInspector_Uinspector_api();
        }
    };
    @NotNull
    private final activityLifecycle.1 activityLifecycle = new Application.ActivityLifecycleCallbacks(this){
        final /* synthetic */ UInspectorLifecycle this$0;
        {
            this.this$0 = $receiver;
        }

        public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            UInspectorLifecycle.access$onActivityChanged(this.this$0, activity);
        }

        public void onActivityResumed(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            UInspectorLifecycle.access$onActivityChanged(this.this$0, activity);
        }

        public void onActivityDestroyed(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            if (this.this$0.getCurrentActivity() == activity) {
                UInspectorLifecycle.access$onActivityChanged(this.this$0, null);
            }
        }

        public void onActivityStarted(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        }

        public void onActivityPaused(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        }

        public void onActivityStopped(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        }

        public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        }
    };

    @Nullable
    public final Activity getCurrentActivity() {
        return this.currentActivity;
    }

    public final void register(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        ProcessLifecycleOwner.get().getLifecycle().addObserver((LifecycleObserver)this.appLifecycle);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifecycle);
    }

    public final void unRegister(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifecycle);
        ProcessLifecycleOwner.get().getLifecycle().removeObserver((LifecycleObserver)this.appLifecycle);
    }

    @MainThread
    private final void onActivityChanged(Activity newActivity) {
        Activity lastActivity;
        this.currentActivity = newActivity;
        UInspectorLifecycleState uInspectorLifecycleState = UInspector.currentState.getWithLifecycle();
        Activity activity = lastActivity = uInspectorLifecycleState == null ? null : uInspectorLifecycleState.getActivity();
        if (lastActivity != newActivity) {
            if (lastActivity != null) {
                uInspectorLifecycleState = UInspector.currentState.getWithLifecycle();
                if (uInspectorLifecycleState != null) {
                    uInspectorLifecycleState.clear$UInspector_Uinspector_api();
                }
                UInspector.currentState.setWithLifecycle(null);
            }
            if (newActivity != null) {
                UInspector.currentState.setWithLifecycle(new UInspectorLifecycleState(newActivity));
                UInspector.INSTANCE.syncState$UInspector_Uinspector_api();
            }
        }
    }

    public static final /* synthetic */ void access$onActivityChanged(UInspectorLifecycle $this, Activity newActivity) {
        $this.onActivityChanged(newActivity);
    }
}

