/*
 * Decompiled with CFR 0.152.
 */
package com.pitaya.mobile.uinspector.util;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import android.text.style.BackgroundColorSpan;
import androidx.annotation.AnyRes;
import androidx.annotation.ColorInt;
import androidx.annotation.IdRes;
import com.pitaya.mobile.uinspector.R;
import com.pitaya.mobile.uinspector.UInspector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u0010\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u0006\u001a\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u000e\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u0006\u001a\u000e\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u0006\u001a\u0018\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020%2\b\b\u0001\u0010&\u001a\u00020\u0006\u001a\u0018\u0010'\u001a\u00020\u00012\u0006\u0010$\u001a\u00020%2\b\b\u0001\u0010&\u001a\u00020\u0006\u001a\u000e\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\u0006\u001a\u000e\u0010*\u001a\u0004\u0018\u00010\u0019*\u0004\u0018\u00010\u0019\"\u0017\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\"\u0015\u0010\u000b\u001a\u00020\u0006*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0015\u0010\u000b\u001a\u00020\u000e*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000f\"\u0015\u0010\u0010\u001a\u00020\u0006*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\r\"\u0015\u0010\u0010\u001a\u00020\u000e*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\"\u0015\u0010\u0012\u001a\u00020\u0006*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\r\"\u0015\u0010\u0012\u001a\u00020\u000e*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000f\"\u0017\u0010\u0014\u001a\u00020\u0001*\u0004\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0004\"\u0015\u0010\u0016\u001a\u00020\u0001*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\b\"\u0015\u0010\u0016\u001a\u00020\u0001*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\n\u00a8\u0006+"}, d2={"canonicalName", "", "", "getCanonicalName", "(Ljava/lang/Object;)Ljava/lang/String;", "dpStr", "", "getDpStr", "(I)Ljava/lang/String;", "", "(Ljava/lang/Number;)Ljava/lang/String;", "dpToPx", "getDpToPx", "(I)I", "", "(Ljava/lang/Number;)F", "pxToDp", "getPxToDp", "pxToSp", "getPxToSp", "simpleName", "getSimpleName", "spStr", "getSpStr", "colorToString", "", "color", "Landroid/content/res/ColorStateList;", "drawableToString", "drawable", "Landroid/graphics/drawable/Drawable;", "gravityToString", "gravity", "hexToString", "hex", "idToString", "context", "Landroid/content/Context;", "id", "resToString", "visibilityToString", "visibility", "quote", "UInspector.Uinspector-api"})
public final class ToStringKt {
    public static final int getDpToPx(int $this$dpToPx) {
        return (int)((float)$this$dpToPx * Resources.getSystem().getDisplayMetrics().density);
    }

    public static final float getDpToPx(@NotNull Number $this$dpToPx) {
        Intrinsics.checkNotNullParameter((Object)$this$dpToPx, (String)"<this>");
        return $this$dpToPx.floatValue() * Resources.getSystem().getDisplayMetrics().density;
    }

    public static final int getPxToDp(int $this$pxToDp) {
        return (int)((float)$this$pxToDp / Resources.getSystem().getDisplayMetrics().density);
    }

    public static final float getPxToDp(@NotNull Number $this$pxToDp) {
        Intrinsics.checkNotNullParameter((Object)$this$pxToDp, (String)"<this>");
        return $this$pxToDp.floatValue() / Resources.getSystem().getDisplayMetrics().density;
    }

    @NotNull
    public static final String getDpStr(int $this$dpStr) {
        return UInspector.INSTANCE.getApplication$UInspector_Uinspector_api().getResources().getBoolean(R.bool.uinspector_dimension_dp) ? ToStringKt.getPxToDp($this$dpStr) + "dp" : $this$dpStr + "px";
    }

    @NotNull
    public static final String getDpStr(@NotNull Number $this$dpStr) {
        Intrinsics.checkNotNullParameter((Object)$this$dpStr, (String)"<this>");
        return UInspector.INSTANCE.getApplication$UInspector_Uinspector_api().getResources().getBoolean(R.bool.uinspector_dimension_dp) ? MathKt.roundToInt((float)ToStringKt.getPxToDp($this$dpStr)) + "dp" : $this$dpStr.intValue() + "px";
    }

    public static final int getPxToSp(int $this$pxToSp) {
        return (int)((float)$this$pxToSp / Resources.getSystem().getDisplayMetrics().scaledDensity);
    }

    public static final float getPxToSp(@NotNull Number $this$pxToSp) {
        Intrinsics.checkNotNullParameter((Object)$this$pxToSp, (String)"<this>");
        return $this$pxToSp.floatValue() / Resources.getSystem().getDisplayMetrics().scaledDensity;
    }

    @NotNull
    public static final String getSpStr(int $this$spStr) {
        return UInspector.INSTANCE.getApplication$UInspector_Uinspector_api().getResources().getBoolean(R.bool.uinspector_dimension_sp) ? ToStringKt.getPxToSp($this$spStr) + "sp" : $this$spStr + "px";
    }

    @NotNull
    public static final String getSpStr(@NotNull Number $this$spStr) {
        Intrinsics.checkNotNullParameter((Object)$this$spStr, (String)"<this>");
        return UInspector.INSTANCE.getApplication$UInspector_Uinspector_api().getResources().getBoolean(R.bool.uinspector_dimension_sp) ? MathKt.roundToInt((float)ToStringKt.getPxToSp($this$spStr)) + "sp" : $this$spStr.intValue() + "px";
    }

    @NotNull
    public static final CharSequence colorToString(@NotNull ColorStateList color2) {
        Intrinsics.checkNotNullParameter((Object)color2, (String)"color");
        return ToStringKt.colorToString(color2.getDefaultColor());
    }

    @NotNull
    public static final CharSequence colorToString(@ColorInt int color2) {
        SpannableStringBuilder str = new SpannableStringBuilder((CharSequence)ToStringKt.hexToString(color2)).append((CharSequence)" ");
        int start = str.length();
        str.append((CharSequence)"    ");
        int end = str.length();
        str.setSpan((Object)new BackgroundColorSpan(color2), start, end, 33);
        Intrinsics.checkNotNullExpressionValue((Object)str, (String)"str");
        return (CharSequence)str;
    }

    @NotNull
    public static final String hexToString(int hex) {
        String string2 = Integer.toHexString(hex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toHexString(hex)");
        boolean bl = false;
        String string3 = string2.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
        return Intrinsics.stringPlus((String)"0x", (Object)string3);
    }

    @NotNull
    public static final CharSequence drawableToString(@NotNull Drawable drawable2) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        Drawable drawable3 = drawable2;
        if (drawable3 instanceof ColorDrawable) {
            charSequence = ToStringKt.colorToString(((ColorDrawable)drawable2).getColor());
        } else {
            String string2 = drawable2.getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"drawable::class.java.simpleName");
            charSequence = string2;
        }
        return charSequence;
    }

    @NotNull
    public static final String resToString(@NotNull Context context, @AnyRes int id2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            string2 = '@' + context.getResources().getResourceTypeName(id2) + '/' + context.getResources().getResourceEntryName(id2);
        }
        catch (Resources.NotFoundException e) {
            string2 = ToStringKt.hexToString(id2);
        }
        return string2;
    }

    @NotNull
    public static final String idToString(@NotNull Context context, @IdRes int id2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            string2 = Intrinsics.stringPlus((String)"@+id/", (Object)context.getResources().getResourceEntryName(id2));
        }
        catch (Resources.NotFoundException e) {
            string2 = ToStringKt.hexToString(id2);
        }
        return string2;
    }

    @NotNull
    public static final String visibilityToString(int visibility) {
        String string2;
        int n = visibility;
        switch (n) {
            case 0: {
                string2 = "VISIBLE";
                break;
            }
            case 4: {
                string2 = "INVISIBLE";
                break;
            }
            case 8: {
                string2 = "GONE";
                break;
            }
            default: {
                throw new IllegalArgumentException("What's " + visibility + '?');
            }
        }
        return string2;
    }

    @NotNull
    public static final String gravityToString(int gravity) {
        StringBuilder result = new StringBuilder();
        if ((gravity & 0x77) == 119) {
            result.append("FILL").append(' ');
        } else {
            if ((gravity & 0x70) == 112) {
                result.append("FILL_VERTICAL").append(' ');
            } else {
                if ((gravity & 0x30) == 48) {
                    result.append("TOP").append(' ');
                }
                if ((gravity & 0x50) == 80) {
                    result.append("BOTTOM").append(' ');
                }
            }
            if ((gravity & 7) == 7) {
                result.append("FILL_HORIZONTAL").append(' ');
            } else {
                if ((gravity & 0x800003) == 0x800003) {
                    result.append("START").append(' ');
                } else if ((gravity & 3) == 3) {
                    result.append("LEFT").append(' ');
                }
                if ((gravity & 0x800005) == 0x800005) {
                    result.append("END").append(' ');
                } else if ((gravity & 5) == 5) {
                    result.append("RIGHT").append(' ');
                }
            }
        }
        if ((gravity & 0x11) == 17) {
            result.append("CENTER").append(' ');
        } else {
            if ((gravity & 0x10) == 16) {
                result.append("CENTER_VERTICAL").append(' ');
            }
            if ((gravity & 1) == 1) {
                result.append("CENTER_HORIZONTAL").append(' ');
            }
        }
        CharSequence charSequence = result;
        boolean bl = false;
        if (charSequence.length() == 0) {
            result.append("NO GRAVITY").append(' ');
        }
        if ((gravity & 0x10000000) == 0x10000000) {
            result.append("DISPLAY_CLIP_VERTICAL").append(' ');
        }
        if ((gravity & 0x1000000) == 0x1000000) {
            result.append("DISPLAY_CLIP_HORIZONTAL").append(' ');
        }
        result.deleteCharAt(result.length() - 1);
        charSequence = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"result.toString()");
        return charSequence;
    }

    @Nullable
    public static final CharSequence quote(@Nullable CharSequence $this$quote) {
        return $this$quote != null ? (CharSequence)("" + '\"' + $this$quote + '\"') : $this$quote;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getCanonicalName(@Nullable Object $this$canonicalName) {
        String string2;
        if ($this$canonicalName == null) {
            string2 = "null";
        } else {
            void var2_1;
            String cn = $this$canonicalName.getClass().getCanonicalName();
            CharSequence charSequence = cn;
            boolean bl = false;
            boolean bl2 = false;
            void var1_5 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? $this$canonicalName.getClass().getName() : var2_1;
            Intrinsics.checkNotNullExpressionValue((Object)var1_5, (String)"{\n            val cn = t\u2026n\n            }\n        }");
            string2 = var1_5;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getSimpleName(@Nullable Object $this$simpleName) {
        String string2;
        if ($this$simpleName == null) {
            string2 = "null";
        } else {
            void var2_1;
            String cn = $this$simpleName.getClass().getSimpleName();
            CharSequence charSequence = cn;
            boolean bl = false;
            boolean bl2 = false;
            void var1_5 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? $this$simpleName.getClass().getName() : var2_1;
            Intrinsics.checkNotNullExpressionValue((Object)var1_5, (String)"<get-simpleName>");
            string2 = var1_5;
        }
        return string2;
    }
}

