/*
 * Decompiled with CFR 0.152.
 */
package com.pitaya.mobile.uinspector.hierarchy;

import android.annotation.SuppressLint;
import android.os.Build;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.pitaya.mobile.uinspector.hierarchy.AndroidHitTest;
import com.pitaya.mobile.uinspector.hierarchy.AndroidView;
import com.pitaya.mobile.uinspector.hierarchy.HitTest;
import com.pitaya.mobile.uinspector.hierarchy.Layer;
import com.pitaya.mobile.uinspector.hierarchy.LayerFactoryPlugin;
import com.pitaya.mobile.uinspector.util.ViewUtilsKt;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\tH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\u0010"}, d2={"Lcom/pitaya/mobile/uinspector/hierarchy/AndroidHitTest;", "Lcom/pitaya/mobile/uinspector/hierarchy/HitTest;", "()V", "findFirstTouchTarget", "Landroid/view/View;", "view", "touchEvent", "Landroid/view/MotionEvent;", "findNextTarget", "Lcom/pitaya/mobile/uinspector/hierarchy/Layer;", "event", "current", "findTouchTargetByEvent", "parent", "Landroid/view/ViewGroup;", "Companion", "UInspector.Uinspector-api"})
@SuppressLint(value={"PrivateApi", "DiscouragedPrivateApi"})
public class AndroidHitTest
implements HitTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<Field> firstTouchTarget$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)Companion.firstTouchTarget.2.INSTANCE);
    @NotNull
    private static final Lazy<Field> touchTargetChild$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)Companion.touchTargetChild.2.INSTANCE);
    private static boolean getChildDrawingOrderNotFound;

    @Override
    @Nullable
    public Layer findNextTarget(@NotNull MotionEvent event, @NotNull Layer current) {
        View view;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        if (current instanceof AndroidView && (view = this.findFirstTouchTarget(((AndroidView)current).getView(), event)) != null) {
            return LayerFactoryPlugin.Companion.create(view);
        }
        return null;
    }

    @Nullable
    protected View findFirstTouchTarget(@Nullable View view, @NotNull MotionEvent touchEvent) {
        Intrinsics.checkNotNullParameter((Object)touchEvent, (String)"touchEvent");
        if (view instanceof ViewGroup) {
            View view2;
            try {
                Object object;
                Object touchTarget = Companion.getFirstTouchTarget().get(view);
                view2 = touchTarget != null ? ((object = Companion.getTouchTargetChild().get(touchTarget)) instanceof View ? (View)object : null) : this.findTouchTargetByEvent((ViewGroup)view, touchEvent);
            }
            catch (Throwable e) {
                Log.e((String)"UInspector", (String)e.toString());
                view2 = this.findTouchTargetByEvent((ViewGroup)view, touchEvent);
            }
            return view2;
        }
        return null;
    }

    @Nullable
    protected View findTouchTargetByEvent(@NotNull ViewGroup parent, @NotNull MotionEvent touchEvent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)touchEvent, (String)"touchEvent");
        if (parent.getChildCount() <= 0) {
            return null;
        }
        ArrayList<View> dispatchTouchOrder = new ArrayList<View>(parent.getChildCount());
        int n = 0;
        int n2 = parent.getChildCount();
        if (n < n2) {
            do {
                int drawIndex = n++;
                int childIndex = Companion.getChildDrawingOrder(parent, drawIndex);
                View child = parent.getChildAt(childIndex);
                int insertIndex = drawIndex;
                if (Build.VERSION.SDK_INT >= 21) {
                    float currentZ = child.getZ();
                    while (insertIndex > 0 && ((View)dispatchTouchOrder.get(insertIndex - 1)).getZ() > currentZ) {
                        int n3 = insertIndex;
                        insertIndex = n3 + -1;
                    }
                }
                dispatchTouchOrder.add(insertIndex, child);
            } while (n < n2);
        }
        for (View child : CollectionsKt.asReversedMutable((List)dispatchTouchOrder)) {
            if (child.getVisibility() == 8 || !ViewUtilsKt.isOnView(touchEvent, child)) continue;
            return child;
        }
        return null;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0004R\u001b\u0010\u0003\u001a\u00020\u00048DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\u00048DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\b\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/pitaya/mobile/uinspector/hierarchy/AndroidHitTest$Companion;", "", "()V", "firstTouchTarget", "Ljava/lang/reflect/Field;", "getFirstTouchTarget", "()Ljava/lang/reflect/Field;", "firstTouchTarget$delegate", "Lkotlin/Lazy;", "getChildDrawingOrderNotFound", "", "getGetChildDrawingOrderNotFound", "()Z", "setGetChildDrawingOrderNotFound", "(Z)V", "touchTargetChild", "getTouchTargetChild", "touchTargetChild$delegate", "getChildDrawingOrder", "", "parent", "Landroid/view/ViewGroup;", "idx", "UInspector.Uinspector-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Field getFirstTouchTarget() {
            Lazy lazy = firstTouchTarget$delegate;
            Object var3_2 = null;
            boolean bl = false;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-firstTouchTarget>(...)");
            return (Field)object;
        }

        @NotNull
        protected final Field getTouchTargetChild() {
            Lazy lazy = touchTargetChild$delegate;
            Object var3_2 = null;
            boolean bl = false;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-touchTargetChild>(...)");
            return (Field)object;
        }

        protected final boolean getGetChildDrawingOrderNotFound() {
            return getChildDrawingOrderNotFound;
        }

        protected final void setGetChildDrawingOrderNotFound(boolean bl) {
            getChildDrawingOrderNotFound = bl;
        }

        protected final int getChildDrawingOrder(@NotNull ViewGroup parent, int idx) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            if (!this.getGetChildDrawingOrderNotFound() && Build.VERSION.SDK_INT >= 29) {
                try {
                    int childIndex = parent.getChildDrawingOrder(idx);
                    boolean bl = 0 <= childIndex ? childIndex < parent.getChildCount() : false;
                    if (bl) {
                        return childIndex;
                    }
                }
                catch (Throwable e) {
                    this.setGetChildDrawingOrderNotFound(true);
                }
            }
            return idx;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

