/*
 * Decompiled with CFR 0.152.
 */
package com.pitaya.mobile.uinspector.hierarchy;

import android.annotation.SuppressLint;
import android.os.Build;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.pitaya.mobile.uinspector.hierarchy.AndroidView;
import com.pitaya.mobile.uinspector.hierarchy.HitTest;
import com.pitaya.mobile.uinspector.hierarchy.Layer;
import com.pitaya.mobile.uinspector.hierarchy.LayerFactoryPlugin;
import com.pitaya.mobile.uinspector.util.ViewUtilsKt;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u001c\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\u0007H\u0014J\u001a\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0007H\u0014\u00a8\u0006\u0011"}, d2={"Lcom/pitaya/mobile/uinspector/hierarchy/AndroidHitTest;", "Lcom/pitaya/mobile/uinspector/hierarchy/HitTest;", "<init>", "()V", "findNextTarget", "Lcom/pitaya/mobile/uinspector/hierarchy/Layer;", "event", "Landroid/view/MotionEvent;", "current", "findFirstTouchTarget", "Landroid/view/View;", "view", "touchEvent", "findTouchTargetByEvent", "parent", "Landroid/view/ViewGroup;", "Companion", "UInspector.Uinspector-api"})
@SuppressLint(value={"PrivateApi", "DiscouragedPrivateApi"})
public class AndroidHitTest
implements HitTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<Field> firstTouchTarget$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, AndroidHitTest::firstTouchTarget_delegate$lambda$0);
    @NotNull
    private static final Lazy<Field> touchTargetChild$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, AndroidHitTest::touchTargetChild_delegate$lambda$1);
    private static boolean getChildDrawingOrderNotFound;

    @Override
    @Nullable
    public Layer findNextTarget(@NotNull MotionEvent event, @NotNull Layer current) {
        View view;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        if (current instanceof AndroidView && (view = this.findFirstTouchTarget(((AndroidView)current).getView(), event)) != null) {
            return LayerFactoryPlugin.Companion.create(view);
        }
        return null;
    }

    @Nullable
    protected View findFirstTouchTarget(@Nullable View view, @NotNull MotionEvent touchEvent) {
        Intrinsics.checkNotNullParameter((Object)touchEvent, (String)"touchEvent");
        if (view instanceof ViewGroup) {
            View view2;
            try {
                Object object;
                Object touchTarget = Companion.getFirstTouchTarget().get(view);
                view2 = touchTarget != null ? ((object = Companion.getTouchTargetChild().get(touchTarget)) instanceof View ? (View)object : null) : this.findTouchTargetByEvent((ViewGroup)view, touchEvent);
            }
            catch (Throwable e) {
                Log.e((String)"UInspector", (String)e.toString());
                view2 = this.findTouchTargetByEvent((ViewGroup)view, touchEvent);
            }
            return view2;
        }
        return null;
    }

    @Nullable
    protected View findTouchTargetByEvent(@NotNull ViewGroup parent, @NotNull MotionEvent touchEvent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)touchEvent, (String)"touchEvent");
        if (parent.getChildCount() <= 0) {
            return null;
        }
        ArrayList<View> dispatchTouchOrder = new ArrayList<View>(parent.getChildCount());
        int n = parent.getChildCount();
        for (int drawIndex = 0; drawIndex < n; ++drawIndex) {
            int insertIndex;
            int childIndex = Companion.getChildDrawingOrder(parent, drawIndex);
            View child = parent.getChildAt(childIndex);
            if (Build.VERSION.SDK_INT >= 21) {
                float currentZ = child.getZ();
                for (insertIndex = drawIndex; insertIndex > 0 && ((View)dispatchTouchOrder.get(insertIndex - 1)).getZ() > currentZ; --insertIndex) {
                }
            }
            dispatchTouchOrder.add(insertIndex, child);
        }
        for (View child : CollectionsKt.asReversedMutable((List)dispatchTouchOrder)) {
            if (child.getVisibility() == 8 || !ViewUtilsKt.isOnView(touchEvent, child)) continue;
            return child;
        }
        return null;
    }

    private static final Field firstTouchTarget_delegate$lambda$0() {
        Field f = ViewGroup.class.getDeclaredField("mFirstTouchTarget");
        f.setAccessible(true);
        return f;
    }

    private static final Field touchTargetChild_delegate$lambda$1() {
        Class<?> cls = Class.forName("android.view.ViewGroup$TouchTarget");
        Field f = cls.getDeclaredField("child");
        f.setAccessible(true);
        return f;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0004R\u001b\u0010\u0004\u001a\u00020\u00058DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u00058DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\t\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\r\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/pitaya/mobile/uinspector/hierarchy/AndroidHitTest$Companion;", "", "<init>", "()V", "firstTouchTarget", "Ljava/lang/reflect/Field;", "getFirstTouchTarget", "()Ljava/lang/reflect/Field;", "firstTouchTarget$delegate", "Lkotlin/Lazy;", "touchTargetChild", "getTouchTargetChild", "touchTargetChild$delegate", "getChildDrawingOrderNotFound", "", "getGetChildDrawingOrderNotFound", "()Z", "setGetChildDrawingOrderNotFound", "(Z)V", "getChildDrawingOrder", "", "parent", "Landroid/view/ViewGroup;", "idx", "UInspector.Uinspector-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Field getFirstTouchTarget() {
            Lazy lazy = firstTouchTarget$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (Field)object;
        }

        @NotNull
        protected final Field getTouchTargetChild() {
            Lazy lazy = touchTargetChild$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (Field)object;
        }

        protected final boolean getGetChildDrawingOrderNotFound() {
            return getChildDrawingOrderNotFound;
        }

        protected final void setGetChildDrawingOrderNotFound(boolean bl) {
            getChildDrawingOrderNotFound = bl;
        }

        protected final int getChildDrawingOrder(@NotNull ViewGroup parent, int idx) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            if (!this.getGetChildDrawingOrderNotFound() && Build.VERSION.SDK_INT >= 29) {
                try {
                    int childIndex = parent.getChildDrawingOrder(idx);
                    boolean bl = 0 <= childIndex ? childIndex < parent.getChildCount() : false;
                    if (bl) {
                        return childIndex;
                    }
                }
                catch (Throwable e) {
                    this.setGetChildDrawingOrderNotFound(true);
                }
            }
            return idx;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

