/*
 * Decompiled with CFR 0.152.
 */
package com.pitaya.mobile.uinspector.hierarchy;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.core.view.ViewGroupKt;
import com.pitaya.mobile.uinspector.hierarchy.Layer;
import com.pitaya.mobile.uinspector.hierarchy.LayerFactoryPlugin;
import com.pitaya.mobile.uinspector.util.ToStringKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0016H\u0016J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010\"\u001a\u00020#H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018\u00a8\u0006$"}, d2={"Lcom/pitaya/mobile/uinspector/hierarchy/AndroidView;", "Lcom/pitaya/mobile/uinspector/hierarchy/Layer;", "view", "Landroid/view/View;", "<init>", "(Landroid/view/View;)V", "getView", "()Landroid/view/View;", "name", "", "getName", "()Ljava/lang/CharSequence;", "id", "getId", "parent", "getParent", "()Lcom/pitaya/mobile/uinspector/hierarchy/Layer;", "children", "Lkotlin/sequences/Sequence;", "getChildren", "()Lkotlin/sequences/Sequence;", "width", "", "getWidth", "()I", "height", "getHeight", "getLocation", "", "hashCode", "equals", "", "other", "", "toString", "", "UInspector.Uinspector-api"})
@SourceDebugExtension(value={"SMAP\nAndroidView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidView.kt\ncom/pitaya/mobile/uinspector/hierarchy/AndroidView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,40:1\n1#2:41\n*E\n"})
public class AndroidView
implements Layer {
    @NotNull
    private final View view;

    public AndroidView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.view = view;
    }

    @NotNull
    public final View getView() {
        return this.view;
    }

    @Override
    @NotNull
    public CharSequence getName() {
        return ToStringKt.getSimpleName(this.view);
    }

    @Override
    @Nullable
    public CharSequence getId() {
        CharSequence charSequence;
        if (this.view.getId() > 0) {
            Context context = this.view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            charSequence = ToStringKt.idToString(context, this.view.getId());
        } else {
            charSequence = null;
        }
        return charSequence;
    }

    @Override
    @Nullable
    public Layer getParent() {
        Layer layer;
        ViewParent viewParent = this.view.getParent();
        View view = viewParent instanceof View ? (View)viewParent : null;
        if (view != null) {
            View it = view;
            boolean bl = false;
            layer = LayerFactoryPlugin.Companion.create(it);
        } else {
            layer = null;
        }
        return layer;
    }

    @Override
    @NotNull
    public Sequence<Layer> getChildren() {
        return this.view instanceof ViewGroup ? SequencesKt.map((Sequence)ViewGroupKt.getChildren((ViewGroup)((ViewGroup)this.view)), AndroidView::_get_children_$lambda$1) : SequencesKt.emptySequence();
    }

    @Override
    public int getWidth() {
        return this.view.getMeasuredWidth();
    }

    @Override
    public int getHeight() {
        return this.view.getMeasuredHeight();
    }

    @Override
    @NotNull
    public int[] getLocation() {
        int[] nArray;
        int[] it = nArray = new int[2];
        boolean bl = false;
        this.view.getLocationOnScreen(it);
        return nArray;
    }

    public int hashCode() {
        return this.view.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof AndroidView && ((AndroidView)other).view == this.view;
    }

    @NotNull
    public String toString() {
        return ((Object)this.getName()).toString();
    }

    private static final Layer _get_children_$lambda$1(View it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LayerFactoryPlugin.Companion.create(it);
    }
}

