/*
 * Decompiled with CFR 0.152.
 */
package com.pitaya.mobile.uinspector.hierarchy;

import android.app.Activity;
import android.app.Dialog;
import android.app.Fragment;
import android.os.Build;
import android.view.View;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bJ$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u000eH\u0002J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/pitaya/mobile/uinspector/hierarchy/FragmentsFinder;", "", "<init>", "()V", "findFragments", "", "Landroid/view/View;", "activity", "Landroid/app/Activity;", "record", "", "fm", "Landroidx/fragment/app/FragmentManager;", "records", "", "Landroid/app/FragmentManager;", "UInspector.Uinspector-api"})
public final class FragmentsFinder {
    @NotNull
    public static final FragmentsFinder INSTANCE = new FragmentsFinder();

    private FragmentsFinder() {
    }

    @NotNull
    public final Map<View, Object> findFragments(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Map records = new LinkedHashMap();
        if (activity instanceof FragmentActivity) {
            FragmentManager fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"getSupportFragmentManager(...)");
            this.record(fragmentManager, (Map<View, Object>)records);
        }
        android.app.FragmentManager fragmentManager = activity.getFragmentManager();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"getFragmentManager(...)");
        this.record(fragmentManager, (Map<View, Object>)records);
        return records;
    }

    private final void record(FragmentManager fm, Map<View, Object> records) {
        for (androidx.fragment.app.Fragment fragment : fm.getFragments()) {
            View v = fragment.getView();
            if (v != null) {
                records.put(v, fragment);
            } else if (fragment instanceof DialogFragment) {
                View dv;
                Dialog dialog = ((DialogFragment)fragment).getDialog();
                View view = dialog != null && (dialog = dialog.getWindow()) != null ? dialog.getDecorView() : (dv = null);
                if (dv != null) {
                    records.put(dv, fragment);
                }
            }
            FragmentManager fragmentManager = fragment.getChildFragmentManager();
            Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"getChildFragmentManager(...)");
            this.record(fragmentManager, records);
        }
    }

    private final void record(android.app.FragmentManager fm, Map<View, Object> records) {
        if (Build.VERSION.SDK_INT >= 26) {
            for (Fragment fragment : fm.getFragments()) {
                View v = fragment.getView();
                if (v != null) {
                    records.put(v, fragment);
                } else if (fragment instanceof android.app.DialogFragment) {
                    View dv;
                    Dialog dialog = ((android.app.DialogFragment)fragment).getDialog();
                    View view = dialog != null && (dialog = dialog.getWindow()) != null ? dialog.getDecorView() : (dv = null);
                    if (dv != null) {
                        records.put(dv, fragment);
                    }
                }
                android.app.FragmentManager fragmentManager = fragment.getChildFragmentManager();
                Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"getChildFragmentManager(...)");
                this.record(fragmentManager, records);
            }
        }
    }
}

