/*
 * Decompiled with CFR 0.152.
 */
package com.pitaya.mobile.uinspector.hierarchy;

import android.app.Activity;
import android.view.MotionEvent;
import android.view.View;
import com.pitaya.mobile.uinspector.hierarchy.HitTest;
import com.pitaya.mobile.uinspector.hierarchy.HitTestFactoryPlugin;
import com.pitaya.mobile.uinspector.hierarchy.Layer;
import com.pitaya.mobile.uinspector.hierarchy.LayerFactoryPlugin;
import com.pitaya.mobile.uinspector.hierarchy.TouchDispatcher;
import java.util.LinkedList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0010J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0010R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/pitaya/mobile/uinspector/hierarchy/TouchTargets;", "", "<init>", "()V", "hitTest", "Lcom/pitaya/mobile/uinspector/hierarchy/HitTest;", "getHitTest", "()Lcom/pitaya/mobile/uinspector/hierarchy/HitTest;", "hitTest$delegate", "Lkotlin/Lazy;", "findTouchTargets", "", "Lcom/pitaya/mobile/uinspector/hierarchy/Layer;", "activity", "Landroid/app/Activity;", "downEvent", "Landroid/view/MotionEvent;", "excludeDecorView", "Landroid/view/View;", "findFirstTouchTargets", "parent", "touchEvent", "findFirstTouchTarget", "UInspector.Uinspector-api"})
public final class TouchTargets {
    @NotNull
    public static final TouchTargets INSTANCE = new TouchTargets();
    @NotNull
    private static final Lazy hitTest$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, TouchTargets::hitTest_delegate$lambda$0);

    private TouchTargets() {
    }

    @NotNull
    public final HitTest getHitTest() {
        Lazy lazy = hitTest$delegate;
        return (HitTest)lazy.getValue();
    }

    @NotNull
    public final List<Layer> findTouchTargets(@NotNull Activity activity, @NotNull MotionEvent downEvent, @NotNull View excludeDecorView) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)downEvent, (String)"downEvent");
        Intrinsics.checkNotNullParameter((Object)excludeDecorView, (String)"excludeDecorView");
        return TouchDispatcher.INSTANCE.dispatchEventToFindTouchTargets(activity, downEvent, excludeDecorView);
    }

    @NotNull
    public final List<Layer> findFirstTouchTargets(@NotNull View parent, @NotNull MotionEvent touchEvent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)touchEvent, (String)"touchEvent");
        LinkedList<Layer> queue = new LinkedList<Layer>();
        Layer current = LayerFactoryPlugin.Companion.create(parent);
        while (current != null) {
            queue.add(current);
            current = this.getHitTest().findNextTarget(touchEvent, current);
        }
        return queue;
    }

    @Nullable
    public final Layer findFirstTouchTarget(@NotNull View parent, @NotNull MotionEvent touchEvent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)touchEvent, (String)"touchEvent");
        return this.getHitTest().findNextTarget(touchEvent, LayerFactoryPlugin.Companion.create(parent));
    }

    private static final HitTest hitTest_delegate$lambda$0() {
        return HitTestFactoryPlugin.Companion.create();
    }
}

