/*
 * Decompiled with CFR 0.152.
 */
package com.pitaya.mobile.uinspector.impl.properties.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import com.pitaya.mobile.uinspector.properties.PropertiesParser;
import com.pitaya.mobile.uinspector.util.ToStringKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\fH\u0016R\u0016\u0010\u0004\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/pitaya/mobile/uinspector/impl/properties/view/ViewPropertiesParser;", "T", "Landroid/view/View;", "Lcom/pitaya/mobile/uinspector/properties/PropertiesParser;", "view", "(Landroid/view/View;)V", "getView", "()Landroid/view/View;", "Landroid/view/View;", "parse", "", "props", "", "", "", "UInspector.Uinspector"})
public class ViewPropertiesParser<T extends View>
implements PropertiesParser {
    @NotNull
    private final T view;

    public ViewPropertiesParser(@NotNull T view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        this.view = view;
    }

    @NotNull
    protected final T getView() {
        return this.view;
    }

    public void parse(@NotNull Map<String, Object> props) {
        boolean bl;
        Object drawable;
        String string;
        Intrinsics.checkNotNullParameter(props, (String)"props");
        Map<String, Object> map = props;
        Object object = "class";
        Object object2 = ToStringKt.getSimpleName(this.view);
        boolean bl2 = false;
        map.put((String)object, object2);
        map = props;
        object = "id";
        if (this.view.getId() <= 0) {
            string = "NO_ID";
        } else {
            object2 = this.view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"view.context");
            string = ToStringKt.idToString((Context)object2, (int)this.view.getId());
        }
        object2 = string;
        bl2 = false;
        map.put((String)object, object2);
        if (Build.VERSION.SDK_INT >= 29 && this.view.getSourceLayoutResId() > 0) {
            map = props;
            object = "source";
            object2 = this.view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"view.context");
            object2 = ToStringKt.resToString((Context)object2, (int)this.view.getSourceLayoutResId());
            bl2 = false;
            map.put((String)object, object2);
        }
        map = props;
        object = "rect";
        object2 = new Rect(this.view.getLeft(), this.view.getTop(), this.view.getRight(), this.view.getBottom());
        bl2 = false;
        map.put((String)object, object2);
        if (this.view.getVisibility() != 0) {
            map = props;
            object = "visibility";
            object2 = ToStringKt.visibilityToString((int)this.view.getVisibility());
            bl2 = false;
            map.put((String)object, object2);
        }
        if (Build.VERSION.SDK_INT >= 23) {
            ColorStateList tint;
            drawable = this.view.getForeground();
            if (drawable != null) {
                object = props;
                object2 = "foreground";
                CharSequence charSequence = ToStringKt.drawableToString((Drawable)drawable);
                bl = false;
                object.put(object2, charSequence);
            }
            if ((tint = this.view.getForegroundTintList()) != null) {
                object2 = props;
                String string2 = "foregroundTint";
                ColorStateList colorStateList = this.view.getForegroundTintList();
                boolean bl3 = false;
                object2.put(string2, colorStateList);
            }
        }
        if (this.view.getBackground() != null) {
            drawable = props;
            object = "background";
            object2 = this.view.getBackground();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"view.background");
            object2 = ToStringKt.drawableToString((Drawable)object2);
            boolean bl4 = false;
            drawable.put(object, object2);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            ColorStateList tint = this.view.getBackgroundTintList();
            if (tint != null) {
                object = props;
                object2 = "backgroundTint";
                CharSequence charSequence = ToStringKt.colorToString((ColorStateList)tint);
                bl = false;
                object.put(object2, charSequence);
            }
            if (this.view.getBackgroundTintMode() != null) {
                object = props;
                object2 = "backgroundTintMode";
                PorterDuff.Mode mode = this.view.getBackgroundTintMode();
                bl = false;
                object.put(object2, mode);
            }
        }
        if (this.view.getScrollX() != 0) {
            map = props;
            object = "scrollX";
            object2 = this.view.getScrollX();
            boolean bl5 = false;
            map.put((String)object, object2);
        }
        if (this.view.getScrollY() != 0) {
            map = props;
            object = "scrollY";
            object2 = this.view.getScrollY();
            boolean bl6 = false;
            map.put((String)object, object2);
        }
        if (!(this.view.getTranslationX() == 0.0f)) {
            map = props;
            object = "translationX";
            object2 = Float.valueOf(this.view.getTranslationX());
            boolean bl7 = false;
            map.put((String)object, object2);
        }
        if (!(this.view.getTranslationY() == 0.0f)) {
            map = props;
            object = "translationY";
            object2 = Float.valueOf(this.view.getTranslationY());
            boolean bl8 = false;
            map.put((String)object, object2);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            if (!(this.view.getTranslationZ() == 0.0f)) {
                map = props;
                object = "translationZ";
                object2 = Float.valueOf(this.view.getTranslationZ());
                boolean bl9 = false;
                map.put((String)object, object2);
            }
            if (!(this.view.getElevation() == 0.0f)) {
                map = props;
                object = "elevation";
                object2 = ToStringKt.getDpStr((Number)Float.valueOf(this.view.getElevation()));
                boolean bl10 = false;
                map.put((String)object, object2);
            }
        }
        if (!(this.view.getScaleX() == 1.0f)) {
            map = props;
            object = "scaleX";
            object2 = Float.valueOf(this.view.getScaleX());
            boolean bl11 = false;
            map.put((String)object, object2);
        }
        if (!(this.view.getScaleY() == 1.0f)) {
            map = props;
            object = "scaleY";
            object2 = Float.valueOf(this.view.getScaleY());
            boolean bl12 = false;
            map.put((String)object, object2);
        }
        if (!(this.view.getRotation() == 0.0f)) {
            map = props;
            object = "rotation";
            object2 = Float.valueOf(this.view.getRotation());
            boolean bl13 = false;
            map.put((String)object, object2);
        }
        if (!(this.view.getRotationX() == 0.0f)) {
            map = props;
            object = "rotationX";
            object2 = Float.valueOf(this.view.getRotationX());
            boolean bl14 = false;
            map.put((String)object, object2);
        }
        if (!(this.view.getRotationY() == 0.0f)) {
            map = props;
            object = "rotationY";
            object2 = Float.valueOf(this.view.getRotationY());
            boolean bl15 = false;
            map.put((String)object, object2);
        }
        if (this.view.isSelected()) {
            map = props;
            object = "isSelected";
            object2 = this.view.isSelected();
            boolean bl16 = false;
            map.put((String)object, object2);
        }
        if (this.view.isFocusable()) {
            map = props;
            object = "isFocusable";
            object2 = this.view.isFocusable();
            boolean bl17 = false;
            map.put((String)object, object2);
        }
        if (this.view.isFocused()) {
            map = props;
            object = "isFocused";
            object2 = this.view.isFocused();
            boolean bl18 = false;
            map.put((String)object, object2);
        }
        if (this.view.isClickable()) {
            map = props;
            object = "isClickable";
            object2 = this.view.isClickable();
            boolean bl19 = false;
            map.put((String)object, object2);
        }
        if (this.view.isLongClickable()) {
            map = props;
            object = "isLongClickable";
            object2 = this.view.isLongClickable();
            boolean bl20 = false;
            map.put((String)object, object2);
        }
        if (this.view.getContentDescription() != null) {
            map = props;
            object = "contentDescription";
            object2 = ToStringKt.quote((CharSequence)this.view.getContentDescription());
            boolean bl21 = false;
            map.put((String)object, object2);
        }
        if (Build.VERSION.SDK_INT >= 28 && this.view.getAccessibilityPaneTitle() != null) {
            map = props;
            object = "accessibilityPaneTitle";
            object2 = ToStringKt.quote((CharSequence)this.view.getAccessibilityPaneTitle());
            boolean bl22 = false;
            map.put((String)object, object2);
        }
        if (this.view.getKeepScreenOn()) {
            map = props;
            object = "keepScreenOn";
            object2 = this.view.getKeepScreenOn();
            boolean bl23 = false;
            map.put((String)object, object2);
        }
        if ((int)this.view.getPivotX() != this.view.getMeasuredWidth() / 2 || (int)this.view.getPivotY() != this.view.getMeasuredHeight() / 2) {
            map = props;
            object = "pivotX";
            object2 = ToStringKt.getDpStr((Number)Float.valueOf(this.view.getPivotX()));
            boolean bl24 = false;
            map.put((String)object, object2);
            map = props;
            object = "pivotY";
            object2 = ToStringKt.getDpStr((Number)Float.valueOf(this.view.getPivotY()));
            bl24 = false;
            map.put((String)object, object2);
        }
        if (!(this.view.getAlpha() == 1.0f)) {
            map = props;
            object = "alpha";
            object2 = Float.valueOf(this.view.getAlpha());
            boolean bl25 = false;
            map.put((String)object, object2);
        }
        if (Build.VERSION.SDK_INT >= 24 && !this.view.getHasOverlappingRendering()) {
            map = props;
            object = "overlappingRendering";
            object2 = this.view.getHasOverlappingRendering();
            boolean bl26 = false;
            map.put((String)object, object2);
        }
    }
}

