/*
 * Decompiled with CFR 0.152.
 */
package com.pitaya.mobile.uinspector.impl.accessibility;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.pitaya.mobile.uinspector.UInspector;
import com.pitaya.mobile.uinspector.hierarchy.AndroidView;
import com.pitaya.mobile.uinspector.hierarchy.Layer;
import com.pitaya.mobile.uinspector.impl.R;
import com.pitaya.mobile.uinspector.state.UInspectorLifecycleState;
import com.pitaya.mobile.uinspector.state.UInspectorTargetViews;
import com.pitaya.mobile.uinspector.ui.panel.popup.UInspectorChildPanel;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0012\u0013\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/pitaya/mobile/uinspector/impl/accessibility/UInspectorAccessibilityPanel;", "Lcom/pitaya/mobile/uinspector/ui/panel/popup/UInspectorChildPanel;", "priority", "", "(I)V", "actions", "", "Lcom/pitaya/mobile/uinspector/impl/accessibility/UInspectorAccessibilityPanel$AccessibilityAction;", "getPriority", "()I", "title", "", "getTitle", "()Ljava/lang/CharSequence;", "onCreateView", "Landroid/view/View;", "context", "Landroid/content/Context;", "AccessibilityAction", "Adapter", "VH", "UInspector.Uinspector"})
public final class UInspectorAccessibilityPanel
implements UInspectorChildPanel {
    private final int priority;
    @NotNull
    private final CharSequence title;
    @RequiresApi(value=16)
    @NotNull
    private final List<AccessibilityAction> actions;

    public UInspectorAccessibilityPanel(int priority) {
        this.priority = priority;
        this.title = "Accessibility";
        Object[] objectArray = new AccessibilityAction[]{new AccessibilityAction("ACTION_CLICK", 16, null, 4, null), new AccessibilityAction("ACTION_LONG_CLICK", 32, null, 4, null), new AccessibilityAction("ACTION_FOCUS", 1, null, 4, null), new AccessibilityAction("ACTION_CLEAR_FOCUS", 2, null, 4, null), new AccessibilityAction("ACTION_SELECT", 4, null, 4, null), new AccessibilityAction("ACTION_CLEAR_SELECTION", 8, null, 4, null)};
        this.actions = CollectionsKt.listOf((Object[])objectArray);
    }

    public int getPriority() {
        return this.priority;
    }

    @NotNull
    public CharSequence getTitle() {
        return this.title;
    }

    @SuppressLint(value={"SetTextI18n"})
    @NotNull
    public View onCreateView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT >= 16) {
            UInspectorTargetViews uInspectorTargetViews;
            Layer targetView;
            RecyclerView recyclerView = new RecyclerView(context);
            UInspectorLifecycleState uInspectorLifecycleState = UInspector.currentState.getWithLifecycle();
            Layer layer = uInspectorLifecycleState == null ? null : (targetView = (uInspectorTargetViews = uInspectorLifecycleState.getLastTargetViews()) == null ? null : (Layer)CollectionsKt.lastOrNull((List)((List)uInspectorTargetViews)));
            if (targetView != null) {
                recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context, 1, false));
                recyclerView.setAdapter((RecyclerView.Adapter)new Adapter(targetView));
            }
            return (View)recyclerView;
        }
        throw new UnsupportedOperationException(Intrinsics.stringPlus((String)"SDK version must not less than JELLY_BEAN(16) but current is ", (Object)Build.VERSION.SDK_INT));
    }

    public void onDestroyView() {
        UInspectorChildPanel.DefaultImpls.onDestroyView((UInspectorChildPanel)this);
    }

    public void onUserVisibleHint(boolean visible) {
        UInspectorChildPanel.DefaultImpls.onUserVisibleHint((UInspectorChildPanel)this, (boolean)visible);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0083\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/pitaya/mobile/uinspector/impl/accessibility/UInspectorAccessibilityPanel$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/pitaya/mobile/uinspector/impl/accessibility/UInspectorAccessibilityPanel$VH;", "targetView", "Lcom/pitaya/mobile/uinspector/hierarchy/Layer;", "(Lcom/pitaya/mobile/uinspector/impl/accessibility/UInspectorAccessibilityPanel;Lcom/pitaya/mobile/uinspector/hierarchy/Layer;)V", "getTargetView", "()Lcom/pitaya/mobile/uinspector/hierarchy/Layer;", "getItemCount", "", "onBindViewHolder", "", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "UInspector.Uinspector"})
    @RequiresApi(value=16)
    private final class Adapter
    extends RecyclerView.Adapter<VH> {
        @NotNull
        private final Layer targetView;

        public Adapter(Layer targetView) {
            Intrinsics.checkNotNullParameter((Object)UInspectorAccessibilityPanel.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)targetView, (String)"targetView");
            this.targetView = targetView;
        }

        @NotNull
        public final Layer getTargetView() {
            return this.targetView;
        }

        @SuppressLint(value={"InflateParams"})
        @NotNull
        public VH onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            View root = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.uinspector_view_list_item, parent, false);
            TextView textView = (TextView)root.findViewById(R.id.uinspector_view_access_btn);
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"root.uinspector_view_access_btn");
            return new VH(textView);
        }

        public int getItemCount() {
            return UInspectorAccessibilityPanel.this.actions.size();
        }

        public void onBindViewHolder(@NotNull VH holder, int position) {
            Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
            AccessibilityAction action = (AccessibilityAction)UInspectorAccessibilityPanel.this.actions.get(position);
            holder.getTextView().setText((CharSequence)action.getName());
            holder.getTextView().setOnClickListener(arg_0 -> Adapter.onBindViewHolder$lambda-0(this, action, arg_0));
        }

        private static final void onBindViewHolder$lambda-0(Adapter this$0, AccessibilityAction $action, View it) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
            try {
                if (this$0.getTargetView() instanceof AndroidView) {
                    ((AndroidView)this$0.getTargetView()).getView().performAccessibilityAction($action.getAction(), $action.getArguments());
                }
            }
            catch (Throwable e) {
                Log.e((String)"UInspectorAccessibility", (String)e.toString());
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/pitaya/mobile/uinspector/impl/accessibility/UInspectorAccessibilityPanel$VH;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "textView", "Landroid/widget/TextView;", "(Landroid/widget/TextView;)V", "getTextView", "()Landroid/widget/TextView;", "UInspector.Uinspector"})
    private static final class VH
    extends RecyclerView.ViewHolder {
        @NotNull
        private final TextView textView;

        public VH(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
            super((View)textView);
            this.textView = textView;
        }

        @NotNull
        public final TextView getTextView() {
            return this.textView;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/pitaya/mobile/uinspector/impl/accessibility/UInspectorAccessibilityPanel$AccessibilityAction;", "", "name", "", "action", "", "arguments", "Landroid/os/Bundle;", "(Ljava/lang/String;ILandroid/os/Bundle;)V", "getAction", "()I", "getArguments", "()Landroid/os/Bundle;", "getName", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "UInspector.Uinspector"})
    private static final class AccessibilityAction {
        @NotNull
        private final String name;
        private final int action;
        @Nullable
        private final Bundle arguments;

        public AccessibilityAction(@NotNull String name, int action, @Nullable Bundle arguments) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.action = action;
            this.arguments = arguments;
        }

        public /* synthetic */ AccessibilityAction(String string, int n, Bundle bundle, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                bundle = null;
            }
            this(string, n, bundle);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getAction() {
            return this.action;
        }

        @Nullable
        public final Bundle getArguments() {
            return this.arguments;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final int component2() {
            return this.action;
        }

        @Nullable
        public final Bundle component3() {
            return this.arguments;
        }

        @NotNull
        public final AccessibilityAction copy(@NotNull String name, int action, @Nullable Bundle arguments) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new AccessibilityAction(name, action, arguments);
        }

        public static /* synthetic */ AccessibilityAction copy$default(AccessibilityAction accessibilityAction, String string, int n, Bundle bundle, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = accessibilityAction.name;
            }
            if ((n2 & 2) != 0) {
                n = accessibilityAction.action;
            }
            if ((n2 & 4) != 0) {
                bundle = accessibilityAction.arguments;
            }
            return accessibilityAction.copy(string, n, bundle);
        }

        @NotNull
        public String toString() {
            return "AccessibilityAction(name=" + this.name + ", action=" + this.action + ", arguments=" + this.arguments + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Integer.hashCode(this.action);
            result = result * 31 + (this.arguments == null ? 0 : this.arguments.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AccessibilityAction)) {
                return false;
            }
            AccessibilityAction accessibilityAction = (AccessibilityAction)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)accessibilityAction.name)) {
                return false;
            }
            if (this.action != accessibilityAction.action) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.arguments, (Object)accessibilityAction.arguments);
        }
    }
}

