/*
 * Decompiled with CFR 0.152.
 */
package com.pitaya.mobile.uinspector.impl.targets.lzyzsd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RandomColor {
    private static final String TAG = "RandomColor";
    private HashMap<String, ColorInfo> colors = new HashMap();

    public RandomColor() {
        this.loadColorBounds();
    }

    private int getColor(int hue, int saturation, int brightness) {
        return android.graphics.Color.HSVToColor((float[])new float[]{hue, saturation, brightness});
    }

    public int randomColor() {
        return this.randomColor(0, null, null);
    }

    public int randomColor(int value, SaturationType saturationType, Luminosity luminosity) {
        int hue = value;
        hue = this.pickHue(hue);
        int saturation = this.pickSaturation(hue, saturationType, luminosity);
        int brightness = this.pickBrightness(hue, saturation, luminosity);
        int color = this.getColor(hue, saturation, brightness);
        return color;
    }

    public int[] randomColor(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("count must be greater than 0");
        }
        int[] colors = new int[count];
        for (int i = 0; i < count; ++i) {
            colors[i] = this.randomColor();
        }
        return colors;
    }

    public int randomColor(Color color) {
        int hue = this.pickHue(color.name());
        int saturation = this.pickSaturation(color, null, null);
        int brightness = this.pickBrightness(color, saturation, null);
        int colorValue = this.getColor(hue, saturation, brightness);
        return colorValue;
    }

    public int[] random(Color color, int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("count must be greater than 0");
        }
        int[] colors = new int[count];
        for (int i = 0; i < count; ++i) {
            colors[i] = this.randomColor(color);
        }
        return colors;
    }

    private int pickHue(int hue) {
        Range hueRange = this.getHueRange(hue);
        return this.doPickHue(hueRange);
    }

    private int doPickHue(Range hueRange) {
        int hue = this.randomWithin(hueRange);
        if (hue < 0) {
            hue = 360 + hue;
        }
        return hue;
    }

    private int pickHue(String name) {
        Range hueRange = this.getHueRange(name);
        return this.doPickHue(hueRange);
    }

    private Range getHueRange(int number) {
        if (number < 360 && number > 0) {
            return new Range(number, number);
        }
        return new Range(0, 360);
    }

    private Range getHueRange(String name) {
        if (this.colors.containsKey(name)) {
            return this.colors.get(name).getHueRange();
        }
        return new Range(0, 360);
    }

    private int pickSaturation(int hue, SaturationType saturationType, Luminosity luminosity) {
        return this.pickSaturation(this.getColorInfo(hue), saturationType, luminosity);
    }

    private int pickSaturation(Color color, SaturationType saturationType, Luminosity luminosity) {
        ColorInfo colorInfo = this.colors.get(color.name());
        return this.pickSaturation(colorInfo, saturationType, luminosity);
    }

    private int pickSaturation(ColorInfo colorInfo, SaturationType saturationType, Luminosity luminosity) {
        if (saturationType != null) {
            switch (saturationType) {
                case RANDOM: {
                    return this.randomWithin(new Range(0, 100));
                }
                case MONOCHROME: {
                    return 0;
                }
            }
        }
        if (colorInfo == null) {
            return 0;
        }
        Range saturationRange = colorInfo.getSaturationRange();
        int min = saturationRange.start;
        int max = saturationRange.end;
        if (luminosity != null) {
            switch (luminosity) {
                case LIGHT: {
                    min = 55;
                    break;
                }
                case BRIGHT: {
                    min = max - 10;
                    break;
                }
                case DARK: {
                    max = 55;
                }
            }
        }
        return this.randomWithin(new Range(min, max));
    }

    private int pickBrightness(int hue, int saturation, Luminosity luminosity) {
        ColorInfo colorInfo = this.getColorInfo(hue);
        return this.pickBrightness(colorInfo, saturation, luminosity);
    }

    private int pickBrightness(Color color, int saturation, Luminosity luminosity) {
        ColorInfo colorInfo = this.colors.get(color.name());
        return this.pickBrightness(colorInfo, saturation, luminosity);
    }

    private int pickBrightness(ColorInfo colorInfo, int saturation, Luminosity luminosity) {
        int min = this.getMinimumBrightness(colorInfo, saturation);
        int max = 100;
        if (luminosity != null) {
            switch (luminosity) {
                case DARK: {
                    max = min + 20;
                    break;
                }
                case LIGHT: {
                    min = (max + min) / 2;
                    break;
                }
                case RANDOM: {
                    min = 0;
                    max = 100;
                }
            }
        }
        return this.randomWithin(new Range(min, max));
    }

    private int getMinimumBrightness(ColorInfo colorInfo, int saturation) {
        if (colorInfo == null) {
            return 0;
        }
        List<Range> lowerBounds = colorInfo.getLowerBounds();
        for (int i = 0; i < lowerBounds.size() - 1; ++i) {
            int s1 = lowerBounds.get((int)i).start;
            int v1 = lowerBounds.get((int)i).end;
            if (i == lowerBounds.size() - 1) break;
            int s2 = lowerBounds.get((int)(i + 1)).start;
            int v2 = lowerBounds.get((int)(i + 1)).end;
            if (saturation < s1 || saturation > s2) continue;
            float m = (float)(v2 - v1) / (float)(s2 - s1);
            float b = (float)v1 - m * (float)s1;
            return (int)(m * (float)saturation + b);
        }
        return 0;
    }

    private ColorInfo getColorInfo(int hue) {
        if (hue >= 334 && hue <= 360) {
            hue -= 360;
        }
        for (String key : this.colors.keySet()) {
            ColorInfo colorInfo = this.colors.get(key);
            if (colorInfo.getHueRange() == null || !colorInfo.getHueRange().contain(hue)) continue;
            return colorInfo;
        }
        return null;
    }

    private int randomWithin(Range range) {
        return (int)Math.floor((double)range.start + Math.random() * (double)(range.end + 1 - range.start));
    }

    public void defineColor(String name, Range hueRange, List<Range> lowerBounds) {
        int sMin = lowerBounds.get((int)0).start;
        int sMax = lowerBounds.get((int)(lowerBounds.size() - 1)).start;
        int bMin = lowerBounds.get((int)(lowerBounds.size() - 1)).end;
        int bMax = lowerBounds.get((int)0).end;
        this.colors.put(name, new ColorInfo(hueRange, new Range(sMin, sMax), new Range(bMin, bMax), lowerBounds));
    }

    private void loadColorBounds() {
        ArrayList<Range> lowerBounds1 = new ArrayList<Range>();
        lowerBounds1.add(new Range(0, 0));
        lowerBounds1.add(new Range(100, 0));
        this.defineColor(Color.MONOCHROME.name(), null, lowerBounds1);
        ArrayList<Range> lowerBounds2 = new ArrayList<Range>();
        lowerBounds2.add(new Range(20, 100));
        lowerBounds2.add(new Range(30, 92));
        lowerBounds2.add(new Range(40, 89));
        lowerBounds2.add(new Range(50, 85));
        lowerBounds2.add(new Range(60, 78));
        lowerBounds2.add(new Range(70, 70));
        lowerBounds2.add(new Range(80, 60));
        lowerBounds2.add(new Range(90, 55));
        lowerBounds2.add(new Range(100, 50));
        this.defineColor(Color.RED.name(), new Range(-26, 18), lowerBounds2);
        ArrayList<Range> lowerBounds3 = new ArrayList<Range>();
        lowerBounds3.add(new Range(20, 100));
        lowerBounds3.add(new Range(30, 93));
        lowerBounds3.add(new Range(40, 88));
        lowerBounds3.add(new Range(50, 86));
        lowerBounds3.add(new Range(60, 85));
        lowerBounds3.add(new Range(70, 70));
        lowerBounds3.add(new Range(100, 70));
        this.defineColor(Color.ORANGE.name(), new Range(19, 46), lowerBounds3);
        ArrayList<Range> lowerBounds4 = new ArrayList<Range>();
        lowerBounds4.add(new Range(25, 100));
        lowerBounds4.add(new Range(40, 94));
        lowerBounds4.add(new Range(50, 89));
        lowerBounds4.add(new Range(60, 86));
        lowerBounds4.add(new Range(70, 84));
        lowerBounds4.add(new Range(80, 82));
        lowerBounds4.add(new Range(90, 80));
        lowerBounds4.add(new Range(100, 75));
        this.defineColor(Color.YELLOW.name(), new Range(47, 62), lowerBounds4);
        ArrayList<Range> lowerBounds5 = new ArrayList<Range>();
        lowerBounds5.add(new Range(30, 100));
        lowerBounds5.add(new Range(40, 90));
        lowerBounds5.add(new Range(50, 85));
        lowerBounds5.add(new Range(60, 81));
        lowerBounds5.add(new Range(70, 74));
        lowerBounds5.add(new Range(80, 64));
        lowerBounds5.add(new Range(90, 50));
        lowerBounds5.add(new Range(100, 40));
        this.defineColor(Color.GREEN.name(), new Range(63, 178), lowerBounds5);
        ArrayList<Range> lowerBounds6 = new ArrayList<Range>();
        lowerBounds6.add(new Range(20, 100));
        lowerBounds6.add(new Range(30, 86));
        lowerBounds6.add(new Range(40, 80));
        lowerBounds6.add(new Range(50, 74));
        lowerBounds6.add(new Range(60, 60));
        lowerBounds6.add(new Range(70, 52));
        lowerBounds6.add(new Range(80, 44));
        lowerBounds6.add(new Range(90, 39));
        lowerBounds6.add(new Range(100, 35));
        this.defineColor(Color.BLUE.name(), new Range(179, 257), lowerBounds6);
        ArrayList<Range> lowerBounds7 = new ArrayList<Range>();
        lowerBounds7.add(new Range(20, 100));
        lowerBounds7.add(new Range(30, 87));
        lowerBounds7.add(new Range(40, 79));
        lowerBounds7.add(new Range(50, 70));
        lowerBounds7.add(new Range(60, 65));
        lowerBounds7.add(new Range(70, 59));
        lowerBounds7.add(new Range(80, 52));
        lowerBounds7.add(new Range(90, 45));
        lowerBounds7.add(new Range(100, 42));
        this.defineColor(Color.PURPLE.name(), new Range(258, 282), lowerBounds7);
        ArrayList<Range> lowerBounds8 = new ArrayList<Range>();
        lowerBounds8.add(new Range(20, 100));
        lowerBounds8.add(new Range(30, 90));
        lowerBounds8.add(new Range(40, 86));
        lowerBounds8.add(new Range(60, 84));
        lowerBounds8.add(new Range(80, 80));
        lowerBounds8.add(new Range(90, 75));
        lowerBounds8.add(new Range(100, 73));
        this.defineColor(Color.PINK.name(), new Range(283, 334), lowerBounds8);
    }

    public static class Range {
        int start;
        int end;

        public Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public boolean contain(int value) {
            return value >= this.start && value <= this.end;
        }

        public String toString() {
            return "start: " + this.start + " end: " + this.end;
        }
    }

    public static class ColorInfo {
        Range hueRange;
        Range saturationRange;
        Range brightnessRange;
        List<Range> lowerBounds;

        public ColorInfo(Range hueRange, Range saturationRange, Range brightnessRange, List<Range> lowerBounds) {
            this.hueRange = hueRange;
            this.saturationRange = saturationRange;
            this.brightnessRange = brightnessRange;
            this.lowerBounds = lowerBounds;
        }

        public Range getHueRange() {
            return this.hueRange;
        }

        public void setHueRange(Range hueRange) {
            this.hueRange = hueRange;
        }

        public Range getSaturationRange() {
            return this.saturationRange;
        }

        public void setSaturationRange(Range saturationRange) {
            this.saturationRange = saturationRange;
        }

        public Range getBrightnessRange() {
            return this.brightnessRange;
        }

        public void setBrightnessRange(Range brightnessRange) {
            this.brightnessRange = brightnessRange;
        }

        public List<Range> getLowerBounds() {
            return this.lowerBounds;
        }

        public void setLowerBounds(List<Range> lowerBounds) {
            this.lowerBounds = lowerBounds;
        }
    }

    public static enum Color {
        MONOCHROME,
        RED,
        ORANGE,
        YELLOW,
        GREEN,
        BLUE,
        PURPLE,
        PINK;

    }

    public static class Options {
        int hue;
        SaturationType saturationType;
        Luminosity luminosity;

        public int getHue() {
            return this.hue;
        }

        public void setHue(int hue) {
            this.hue = hue;
        }

        public SaturationType getSaturationType() {
            return this.saturationType;
        }

        public void setSaturationType(SaturationType saturationType) {
            this.saturationType = saturationType;
        }

        public Luminosity getLuminosity() {
            return this.luminosity;
        }

        public void setLuminosity(Luminosity luminosity) {
            this.luminosity = luminosity;
        }
    }

    public static enum Luminosity {
        BRIGHT,
        LIGHT,
        DARK,
        RANDOM;

    }

    public static enum SaturationType {
        RANDOM,
        MONOCHROME;

    }
}

