/*
 * Decompiled with CFR 0.152.
 */
package com.pitaya.mobile.uinspector.impl.properties.view;

import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.widget.ImageView;
import com.pitaya.mobile.uinspector.impl.properties.view.ViewPropertiesParser;
import com.pitaya.mobile.uinspector.util.ToStringKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/pitaya/mobile/uinspector/impl/properties/view/ImageViewPropertiesParser;", "Lcom/pitaya/mobile/uinspector/impl/properties/view/ViewPropertiesParser;", "Landroid/widget/ImageView;", "view", "<init>", "(Landroid/widget/ImageView;)V", "parse", "", "props", "", "", "", "UInspector.Uinspector"})
public class ImageViewPropertiesParser
extends ViewPropertiesParser<ImageView> {
    public ImageViewPropertiesParser(@NotNull ImageView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super((View)view);
    }

    @Override
    public void parse(@NotNull Map<String, Object> props) {
        Intrinsics.checkNotNullParameter(props, (String)"props");
        super.parse(props);
        props.put("scaleType", ((ImageView)this.getView()).getScaleType());
        if (((ImageView)this.getView()).getDrawable() != null) {
            Map<String, Object> map = props;
            String string = "src";
            Drawable drawable = ((ImageView)this.getView()).getDrawable();
            Intrinsics.checkNotNullExpressionValue((Object)drawable, (String)"getDrawable(...)");
            CharSequence charSequence = ToStringKt.drawableToString((Drawable)drawable);
            map.put(string, charSequence);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            if (((ImageView)this.getView()).getImageAlpha() != 255) {
                props.put("imageAlpha", ((ImageView)this.getView()).getImageAlpha());
            }
            if (((ImageView)this.getView()).getCropToPadding()) {
                props.put("cropToPadding", ((ImageView)this.getView()).getCropToPadding());
            }
            if (((ImageView)this.getView()).getAdjustViewBounds()) {
                props.put("adjustViewBounds", ((ImageView)this.getView()).getAdjustViewBounds());
            }
        }
        if (Build.VERSION.SDK_INT >= 21) {
            ColorStateList tint = ((ImageView)this.getView()).getImageTintList();
            if (tint != null) {
                props.put("imageTint", ToStringKt.colorToString((ColorStateList)tint));
            }
            if (((ImageView)this.getView()).getImageTintMode() != null) {
                props.put("imageTintMode", ((ImageView)this.getView()).getImageTintMode());
            }
        }
        if (((ImageView)this.getView()).getBaseline() > 0) {
            props.put("baseline", ((ImageView)this.getView()).getBaseline());
        }
        if (((ImageView)this.getView()).getBaselineAlignBottom()) {
            props.put("baselineAlignBottom", ((ImageView)this.getView()).getBaselineAlignBottom());
        }
    }
}

