/*
 * Decompiled with CFR 0.152.
 */
package com.pitaya.mobile.uinspector.impl.properties.view;

import android.content.res.ColorStateList;
import android.os.Build;
import android.view.View;
import android.widget.TextView;
import com.pitaya.mobile.uinspector.impl.properties.view.ViewPropertiesParser;
import com.pitaya.mobile.uinspector.util.ToStringKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/pitaya/mobile/uinspector/impl/properties/view/TextViewPropertiesParser;", "Lcom/pitaya/mobile/uinspector/impl/properties/view/ViewPropertiesParser;", "Landroid/widget/TextView;", "view", "<init>", "(Landroid/widget/TextView;)V", "parse", "", "props", "", "", "", "UInspector.Uinspector"})
public class TextViewPropertiesParser
extends ViewPropertiesParser<TextView> {
    public TextViewPropertiesParser(@NotNull TextView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super((View)view);
    }

    @Override
    public void parse(@NotNull Map<String, Object> props) {
        Intrinsics.checkNotNullParameter(props, (String)"props");
        super.parse(props);
        if (((TextView)this.getView()).getText() != null) {
            props.put("text", ToStringKt.quote((CharSequence)((TextView)this.getView()).getText()));
        }
        props.put("textSize", ToStringKt.getSpStr((Number)Float.valueOf(((TextView)this.getView()).getTextSize())));
        Map<String, Object> map = props;
        String string = "textColor";
        ColorStateList colorStateList = ((TextView)this.getView()).getTextColors();
        Intrinsics.checkNotNullExpressionValue((Object)colorStateList, (String)"getTextColors(...)");
        CharSequence charSequence = ToStringKt.colorToString((ColorStateList)colorStateList);
        map.put(string, charSequence);
        if (((TextView)this.getView()).getTypeface() != null) {
            if (((TextView)this.getView()).getTypeface().isBold()) {
                props.put("isBold", "true");
            }
            if (((TextView)this.getView()).getTypeface().isItalic()) {
                props.put("isItalic", "true");
            }
        }
        if (((TextView)this.getView()).getHint() != null) {
            props.put("hint", ToStringKt.quote((CharSequence)((TextView)this.getView()).getHint()));
        }
        if (((TextView)this.getView()).getEllipsize() != null) {
            props.put("ellipsize", ((TextView)this.getView()).getEllipsize());
        }
        if (((TextView)this.getView()).getGravity() != 0x800033) {
            props.put("gravity", ToStringKt.gravityToString((int)((TextView)this.getView()).getGravity()));
        }
        if (Build.VERSION.SDK_INT >= 29 && ((TextView)this.getView()).isSingleLine()) {
            props.put("isSingleLine", ((TextView)this.getView()).isSingleLine());
        }
        if (Build.VERSION.SDK_INT >= 16) {
            if (((TextView)this.getView()).getMaxLines() != Integer.MAX_VALUE && ((TextView)this.getView()).getMaxLines() != -1) {
                props.put("maxLines", ((TextView)this.getView()).getMaxLines());
            }
            if (((TextView)this.getView()).getMaxHeight() != Integer.MAX_VALUE && ((TextView)this.getView()).getMaxHeight() != -1) {
                props.put("maxHeight", ((TextView)this.getView()).getMaxHeight());
            }
            if (((TextView)this.getView()).getMinHeight() != 0 && ((TextView)this.getView()).getMinHeight() != -1) {
                props.put("minHeight", ((TextView)this.getView()).getMinHeight());
            }
            if (((TextView)this.getView()).getMaxWidth() != Integer.MAX_VALUE && ((TextView)this.getView()).getMaxWidth() != -1) {
                props.put("maxWidth", ((TextView)this.getView()).getMaxWidth());
            }
            if (((TextView)this.getView()).getMinWidth() != 0 && ((TextView)this.getView()).getMinWidth() != -1) {
                props.put("minWidth", ((TextView)this.getView()).getMinWidth());
            }
            if (((TextView)this.getView()).getMaxEms() == ((TextView)this.getView()).getMinEms() && ((TextView)this.getView()).getMaxEms() != -1) {
                props.put("ems", ((TextView)this.getView()).getMaxEms());
            } else {
                if (((TextView)this.getView()).getMaxEms() != Integer.MAX_VALUE && ((TextView)this.getView()).getMaxEms() != -1) {
                    props.put("maxEms", ((TextView)this.getView()).getMaxEms());
                }
                if (((TextView)this.getView()).getMinEms() != 0 && ((TextView)this.getView()).getMinEms() != -1) {
                    props.put("minEms", ((TextView)this.getView()).getMinEms());
                }
            }
        }
    }
}

