/*
 * Decompiled with CFR 0.152.
 */
package com.pitaya.mobile.uinspector.impl.properties.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import com.pitaya.mobile.uinspector.properties.PropertiesParser;
import com.pitaya.mobile.uinspector.util.ToStringKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\n\u001a\u00020\u000b2\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\rH\u0016R\u0016\u0010\u0004\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/pitaya/mobile/uinspector/impl/properties/view/ViewPropertiesParser;", "T", "Landroid/view/View;", "Lcom/pitaya/mobile/uinspector/properties/PropertiesParser;", "view", "<init>", "(Landroid/view/View;)V", "getView", "()Landroid/view/View;", "Landroid/view/View;", "parse", "", "props", "", "", "", "UInspector.Uinspector"})
public class ViewPropertiesParser<T extends View>
implements PropertiesParser {
    @NotNull
    private final T view;

    public ViewPropertiesParser(@NotNull T view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        this.view = view;
    }

    @NotNull
    protected final T getView() {
        return this.view;
    }

    public void parse(@NotNull Map<String, Object> props) {
        Object drawable;
        String string;
        Intrinsics.checkNotNullParameter(props, (String)"props");
        props.put("class", ToStringKt.getSimpleName(this.view));
        Map<String, Object> map = props;
        String string2 = "id";
        if (this.view.getId() <= 0) {
            string = "NO_ID";
        } else {
            Context context = this.view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            string = ToStringKt.idToString((Context)context, (int)this.view.getId());
        }
        CharSequence charSequence = string;
        map.put(string2, charSequence);
        if (Build.VERSION.SDK_INT >= 29 && this.view.getSourceLayoutResId() > 0) {
            map = props;
            string2 = "source";
            Context context = this.view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            charSequence = ToStringKt.resToString((Context)context, (int)this.view.getSourceLayoutResId());
            map.put(string2, charSequence);
        }
        props.put("rect", new Rect(this.view.getLeft(), this.view.getTop(), this.view.getRight(), this.view.getBottom()));
        if (this.view.getVisibility() != 0) {
            props.put("visibility", ToStringKt.visibilityToString((int)this.view.getVisibility()));
        }
        if (Build.VERSION.SDK_INT >= 23) {
            ColorStateList tint;
            drawable = this.view.getForeground();
            if (drawable != null) {
                props.put("foreground", ToStringKt.drawableToString((Drawable)drawable));
            }
            if ((tint = this.view.getForegroundTintList()) != null) {
                props.put("foregroundTint", this.view.getForegroundTintList());
            }
        }
        if (this.view.getBackground() != null) {
            drawable = props;
            string2 = "background";
            Drawable drawable2 = this.view.getBackground();
            Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"getBackground(...)");
            charSequence = ToStringKt.drawableToString((Drawable)drawable2);
            drawable.put(string2, charSequence);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            ColorStateList tint = this.view.getBackgroundTintList();
            if (tint != null) {
                props.put("backgroundTint", ToStringKt.colorToString((ColorStateList)tint));
            }
            if (this.view.getBackgroundTintMode() != null) {
                props.put("backgroundTintMode", this.view.getBackgroundTintMode());
            }
        }
        if (this.view.getScrollX() != 0) {
            props.put("scrollX", this.view.getScrollX());
        }
        if (this.view.getScrollY() != 0) {
            props.put("scrollY", this.view.getScrollY());
        }
        if (!(this.view.getTranslationX() == 0.0f)) {
            props.put("translationX", Float.valueOf(this.view.getTranslationX()));
        }
        if (!(this.view.getTranslationY() == 0.0f)) {
            props.put("translationY", Float.valueOf(this.view.getTranslationY()));
        }
        if (Build.VERSION.SDK_INT >= 21) {
            if (!(this.view.getTranslationZ() == 0.0f)) {
                props.put("translationZ", Float.valueOf(this.view.getTranslationZ()));
            }
            if (!(this.view.getElevation() == 0.0f)) {
                props.put("elevation", ToStringKt.getDpStr((Number)Float.valueOf(this.view.getElevation())));
            }
        }
        if (!(this.view.getScaleX() == 1.0f)) {
            props.put("scaleX", Float.valueOf(this.view.getScaleX()));
        }
        if (!(this.view.getScaleY() == 1.0f)) {
            props.put("scaleY", Float.valueOf(this.view.getScaleY()));
        }
        if (!(this.view.getRotation() == 0.0f)) {
            props.put("rotation", Float.valueOf(this.view.getRotation()));
        }
        if (!(this.view.getRotationX() == 0.0f)) {
            props.put("rotationX", Float.valueOf(this.view.getRotationX()));
        }
        if (!(this.view.getRotationY() == 0.0f)) {
            props.put("rotationY", Float.valueOf(this.view.getRotationY()));
        }
        if (this.view.isSelected()) {
            props.put("isSelected", this.view.isSelected());
        }
        if (this.view.isFocusable()) {
            props.put("isFocusable", this.view.isFocusable());
        }
        if (this.view.isFocused()) {
            props.put("isFocused", this.view.isFocused());
        }
        if (this.view.isClickable()) {
            props.put("isClickable", this.view.isClickable());
        }
        if (this.view.isLongClickable()) {
            props.put("isLongClickable", this.view.isLongClickable());
        }
        if (this.view.getContentDescription() != null) {
            props.put("contentDescription", ToStringKt.quote((CharSequence)this.view.getContentDescription()));
        }
        if (Build.VERSION.SDK_INT >= 28 && this.view.getAccessibilityPaneTitle() != null) {
            props.put("accessibilityPaneTitle", ToStringKt.quote((CharSequence)this.view.getAccessibilityPaneTitle()));
        }
        if (this.view.getKeepScreenOn()) {
            props.put("keepScreenOn", this.view.getKeepScreenOn());
        }
        if ((int)this.view.getPivotX() != this.view.getMeasuredWidth() / 2 || (int)this.view.getPivotY() != this.view.getMeasuredHeight() / 2) {
            props.put("pivotX", ToStringKt.getDpStr((Number)Float.valueOf(this.view.getPivotX())));
            props.put("pivotY", ToStringKt.getDpStr((Number)Float.valueOf(this.view.getPivotY())));
        }
        if (!(this.view.getAlpha() == 1.0f)) {
            props.put("alpha", Float.valueOf(this.view.getAlpha()));
        }
        if (Build.VERSION.SDK_INT >= 24 && !this.view.getHasOverlappingRendering()) {
            props.put("overlappingRendering", this.view.getHasOverlappingRendering());
        }
    }
}

