/*
 * Decompiled with CFR 0.152.
 */
package io.github.z4kn4fein.semver.constraints;

import io.github.z4kn4fein.semver.Patterns;
import io.github.z4kn4fein.semver.Version;
import io.github.z4kn4fein.semver.VersionExtensionsKt;
import io.github.z4kn4fein.semver.constraints.Condition;
import io.github.z4kn4fein.semver.constraints.ConstraintFormatException;
import io.github.z4kn4fein.semver.constraints.Op;
import io.github.z4kn4fein.semver.constraints.OpKt;
import io.github.z4kn4fein.semver.constraints.Range;
import io.github.z4kn4fein.semver.constraints.VersionDescriptor;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b`\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\t"}, d2={"Lio/github/z4kn4fein/semver/constraints/VersionComparator;", "", "isSatisfiedBy", "", "version", "Lio/github/z4kn4fein/semver/Version;", "opposite", "", "Companion", "semver"})
public interface VersionComparator {
    @NotNull
    public static final Companion Companion = io.github.z4kn4fein.semver.constraints.VersionComparator$Companion.$$INSTANCE;

    public boolean isSatisfiedBy(@NotNull Version var1);

    @NotNull
    public String opposite();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\tH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lio/github/z4kn4fein/semver/constraints/VersionComparator$Companion;", "", "()V", "greaterThanMin", "Lio/github/z4kn4fein/semver/constraints/VersionComparator;", "getGreaterThanMin", "()Lio/github/z4kn4fein/semver/constraints/VersionComparator;", "createFromHyphenRange", "startDescriptor", "Lio/github/z4kn4fein/semver/constraints/VersionDescriptor;", "endDescriptor", "createFromOperator", "operatorString", "", "versionDescriptor", "fromCaret", "fromMinorWildcardCaret", "fromPatchWildcardCaret", "fromTilde", "semver"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final VersionComparator greaterThanMin;

        private Companion() {
        }

        @NotNull
        public final VersionComparator getGreaterThanMin() {
            return greaterThanMin;
        }

        @NotNull
        public final VersionComparator createFromOperator(@NotNull String operatorString, @NotNull VersionDescriptor versionDescriptor) {
            VersionComparator versionComparator;
            Intrinsics.checkNotNullParameter((Object)operatorString, (String)"operatorString");
            Intrinsics.checkNotNullParameter((Object)versionDescriptor, (String)"versionDescriptor");
            String string = operatorString;
            if (ArraysKt.contains((Object[])Patterns.INSTANCE.getComparisonOperators(), (Object)string) ? true : Intrinsics.areEqual((Object)string, (Object)"")) {
                versionComparator = versionDescriptor.toComparator(OpKt.toOperator(operatorString));
            } else if (ArraysKt.contains((Object[])Patterns.INSTANCE.getTildeOperators(), (Object)string)) {
                versionComparator = this.fromTilde(versionDescriptor);
            } else if (Intrinsics.areEqual((Object)string, (Object)"^")) {
                versionComparator = this.fromCaret(versionDescriptor);
            } else {
                throw new ConstraintFormatException("Invalid constraint operator: " + operatorString + " in " + versionDescriptor);
            }
            return versionComparator;
        }

        @NotNull
        public final VersionComparator createFromHyphenRange(@NotNull VersionDescriptor startDescriptor, @NotNull VersionDescriptor endDescriptor) {
            Intrinsics.checkNotNullParameter((Object)startDescriptor, (String)"startDescriptor");
            Intrinsics.checkNotNullParameter((Object)endDescriptor, (String)"endDescriptor");
            return new Range(startDescriptor.toComparator(Op.GREATER_THAN_OR_EQUAL), endDescriptor.toComparator(Op.LESS_THAN_OR_EQUAL), Op.EQUAL);
        }

        private final VersionComparator fromTilde(VersionDescriptor versionDescriptor) {
            VersionComparator versionComparator;
            if (versionDescriptor.isWildcard()) {
                versionComparator = VersionDescriptor.toComparator$default(versionDescriptor, null, 1, null);
            } else {
                Version version = new Version(versionDescriptor.getMajor(), versionDescriptor.getMinor(), versionDescriptor.getPatch(), versionDescriptor.getPreRelease(), versionDescriptor.getBuildMetadata());
                versionComparator = new Range(new Condition(Op.GREATER_THAN_OR_EQUAL, version), new Condition(Op.LESS_THAN, VersionExtensionsKt.nextMinor(version, "")), Op.EQUAL);
            }
            return versionComparator;
        }

        private final VersionComparator fromCaret(VersionDescriptor versionDescriptor) {
            VersionComparator versionComparator;
            if (versionDescriptor.isMajorWildcard()) {
                versionComparator = greaterThanMin;
            } else if (versionDescriptor.isMinorWildcard()) {
                versionComparator = this.fromMinorWildcardCaret(versionDescriptor);
            } else if (versionDescriptor.isPatchWildcard()) {
                versionComparator = this.fromPatchWildcardCaret(versionDescriptor);
            } else {
                Version version = new Version(versionDescriptor.getMajor(), versionDescriptor.getMinor(), versionDescriptor.getPatch(), versionDescriptor.getPreRelease(), versionDescriptor.getBuildMetadata());
                Version endVersion = !Intrinsics.areEqual((Object)versionDescriptor.getMajorString(), (Object)"0") ? VersionExtensionsKt.nextMajor(version, "") : (!Intrinsics.areEqual((Object)versionDescriptor.getMinorString(), (Object)"0") ? VersionExtensionsKt.nextMinor(version, "") : (!Intrinsics.areEqual((Object)versionDescriptor.getPatchString(), (Object)"0") ? VersionExtensionsKt.nextPatch(version, "") : new Version(0, 0, 1, "", null, 19, null)));
                versionComparator = new Range(new Condition(Op.GREATER_THAN_OR_EQUAL, version), new Condition(Op.LESS_THAN, endVersion), Op.EQUAL);
            }
            return versionComparator;
        }

        private final VersionComparator fromMinorWildcardCaret(VersionDescriptor versionDescriptor) {
            return Intrinsics.areEqual((Object)versionDescriptor.getMajorString(), (Object)"0") ? (VersionComparator)new Range(greaterThanMin, new Condition(Op.LESS_THAN, new Version(1, 0, 0, "", null, 22, null)), Op.EQUAL) : VersionDescriptor.toComparator$default(versionDescriptor, null, 1, null);
        }

        private final VersionComparator fromPatchWildcardCaret(VersionDescriptor versionDescriptor) {
            VersionComparator versionComparator;
            if (Intrinsics.areEqual((Object)versionDescriptor.getMajorString(), (Object)"0") && Intrinsics.areEqual((Object)versionDescriptor.getMinorString(), (Object)"0")) {
                versionComparator = new Range(greaterThanMin, new Condition(Op.LESS_THAN, new Version(0, 1, 0, "", null, 21, null)), Op.EQUAL);
            } else if (!Intrinsics.areEqual((Object)versionDescriptor.getMajorString(), (Object)"0")) {
                Version version = new Version(versionDescriptor.getMajor(), versionDescriptor.getMinor(), 0, null, null, 28, null);
                versionComparator = new Range(new Condition(Op.GREATER_THAN_OR_EQUAL, version), new Condition(Op.LESS_THAN, VersionExtensionsKt.nextMajor(version, "")), Op.EQUAL);
            } else {
                versionComparator = VersionDescriptor.toComparator$default(versionDescriptor, null, 1, null);
            }
            return versionComparator;
        }

        static {
            $$INSTANCE = new Companion();
            greaterThanMin = new Condition(Op.GREATER_THAN_OR_EQUAL, Version.Companion.getMin());
        }
    }
}

