/*
 * Decompiled with CFR 0.152.
 */
package io.zenwave360.jsonrefparser.parser;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import io.zenwave360.jsonrefparser.parser.CustomYAMLParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class JsonDeserializerWithLocations
extends UntypedObjectDeserializer {
    private Map<String, Pair<JsonLocation, JsonLocation>> locations = new HashMap<String, Pair<JsonLocation, JsonLocation>>();

    public Map<String, Pair<JsonLocation, JsonLocation>> getLocations() {
        return this.locations;
    }

    JsonDeserializerWithLocations() {
        super(null, null);
    }

    public Object deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        boolean isObjectStart;
        String pathName = this.getFullPathName(jsonParser);
        JsonLocation startLocation = ((CustomYAMLParser)jsonParser).getLastEventStartLocation();
        boolean bl = isObjectStart = jsonParser.currentTokenId() == 1 || jsonParser.currentTokenId() == 3;
        if (pathName != null && isObjectStart) {
            this.saveLocationStart(this.getFullPathName(jsonParser), startLocation);
        }
        Object result = super.deserialize(jsonParser, ctxt);
        if (pathName != null && isObjectStart) {
            this.saveLocationEnd(pathName, jsonParser.getCurrentLocation());
        }
        return result;
    }

    void saveLocationStart(String pathName, JsonLocation start) throws IOException {
        this.locations.put(pathName, (Pair<JsonLocation, JsonLocation>)Pair.of((Object)start, null));
    }

    void saveLocationEnd(String pathName, JsonLocation end) throws IOException {
        Pair<JsonLocation, JsonLocation> location = this.locations.get(pathName);
        this.locations.put(pathName, (Pair<JsonLocation, JsonLocation>)Pair.of((Object)((JsonLocation)location.getLeft()), (Object)end));
    }

    String getFullPathName(JsonParser jsonParser) throws IOException {
        ArrayList<Object> paths = new ArrayList<Object>();
        JsonStreamContext context = jsonParser.getParsingContext();
        if (context.inRoot()) {
            paths.add("$");
        } else {
            do {
                if (context.inRoot()) {
                    paths.add("$");
                    continue;
                }
                if (context.inArray() && jsonParser.getCurrentToken() != JsonToken.START_ARRAY) {
                    paths.add("" + context.getCurrentIndex());
                    continue;
                }
                if (context.getCurrentName() == null) continue;
                paths.add(context.getCurrentName());
            } while ((context = context.getParent()) != null);
        }
        Collections.reverse(paths);
        return StringUtils.join(paths, (String)".");
    }
}

